/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android.log;

import android.util.Log;
import com.sendbird.android.log.LoggerConfig;
import com.sendbird.android.log.Tag;
import java.util.HashSet;
import java.util.Locale;

public class Logger {
    public static final int NONE = 0;
    public static final int INFO = 1;
    public static final int DEBUG = 98765;
    private static int sLevel = 0;
    private static LoggerConfig loggerConfig = Logger.initLogConfig();
    private static boolean withStack = true;
    private static final int LOG_SEGMENT_SIZE = 2000;

    private Logger() {
    }

    private static LoggerConfig initLogConfig() {
        int printLogLevel = 2;
        withStack = true;
        if (sLevel == 0) {
            printLogLevel = 5;
        } else if (sLevel == 1) {
            printLogLevel = 4;
        }
        LoggerConfig.Builder builder = new LoggerConfig.Builder();
        builder = builder.setDefaultTag(Tag.DEFAULT).setStackPrefix(Tag.DEFAULT.tag()).setPrintLoggerLevel(printLogLevel);
        HashSet<String> set = new HashSet<String>();
        set.add(Logger.class.getName());
        builder.setIgnoreSet(set);
        return builder.build();
    }

    public static void setLoggerLevel(int level) {
        sLevel = level;
        loggerConfig = Logger.initLogConfig();
    }

    private static int printLog(Tag tag, int logLevel, String msg) {
        int remainLen;
        if (msg == null) {
            return 0;
        }
        String message = loggerConfig.getMessage(withStack, msg);
        if (!loggerConfig.isPrintLoggable(logLevel)) {
            return 0;
        }
        if (message == null) {
            message = loggerConfig.getMessage(withStack, msg);
        }
        if (message == null) {
            return 0;
        }
        String tagMsg = tag.tag();
        int messageLen = message.length();
        int depth = 0;
        int totalPrintLen = 0;
        for (int curIdx = 0; curIdx < messageLen; curIdx += remainLen) {
            remainLen = messageLen - curIdx;
            if (remainLen > 2000) {
                remainLen = 2000;
            }
            totalPrintLen += Logger.printLogPartially(logLevel, tagMsg, message.substring(curIdx, curIdx + remainLen), depth++);
        }
        return totalPrintLen;
    }

    private static int printLogPartially(int logLevel, String tagMsg, String msg, int depth) {
        int msgLen = msg.length();
        int writtenLen = 0;
        String prefix = "";
        if (depth > 0) {
            prefix = String.format(Locale.US, "Cont(%d) ", depth);
        }
        String printMsg = msgLen > 2000 ? msg.substring(0, 2000) : msg;
        switch (logLevel) {
            case 0: 
            case 3: {
                writtenLen = Log.d((String)tagMsg, (String)(prefix + printMsg));
                break;
            }
            case 2: {
                writtenLen = Log.v((String)tagMsg, (String)(prefix + printMsg));
                break;
            }
            case 4: {
                writtenLen = Log.i((String)tagMsg, (String)(prefix + printMsg));
                break;
            }
            case 5: {
                writtenLen = Log.w((String)tagMsg, (String)(prefix + printMsg));
                break;
            }
            case 6: {
                writtenLen = Log.e((String)tagMsg, (String)(prefix + printMsg));
            }
        }
        return writtenLen;
    }

    public static String getCallerTraceInfo(Class klass) {
        if (!loggerConfig.isPrintLoggable(3)) {
            return "unknown caller";
        }
        StackTraceElement[] stacks = Thread.currentThread().getStackTrace();
        String threadName = Thread.currentThread().getName();
        StackTraceElement stack = null;
        String className = null;
        String callerClassName = klass.getName();
        boolean found = false;
        for (StackTraceElement stack1 : stacks) {
            className = stack1.getClassName();
            if (className.startsWith(callerClassName)) {
                found = true;
                continue;
            }
            if (!found) continue;
            stack = stack1;
            break;
        }
        if (stack == null) {
            return "";
        }
        String klassName = stack.getClassName();
        String method = stack.getMethodName();
        int line = stack.getLineNumber();
        return String.format(Locale.US, "{%s}-[%s.%s():%d]", threadName, klassName, method, line);
    }

    private static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        return Log.getStackTraceString((Throwable)tr);
    }

    public static int vt(Tag tag, Throwable tr) {
        return Logger.vt(tag, Logger.getStackTraceString(tr));
    }

    public static int vt(Tag tag, String msg, Throwable tr) {
        return Logger.vt(tag, "%s\n%s", msg, Logger.getStackTraceString(tr));
    }

    private static int vt(Tag tag, String format, Object ... args) {
        if (loggerConfig.isPrintLoggable(2)) {
            String message = null;
            message = args != null && args.length > 0 ? String.format(format, args) : format;
            return Logger.printLog(tag, 2, message);
        }
        return 0;
    }

    public static int vt(Tag tag, String msg) {
        return Logger.printLog(tag, 2, msg);
    }

    public static int v(String format, Object ... args) {
        return Logger.vt(loggerConfig.getDefaultTag(), format, args);
    }

    public static int v(Throwable tr) {
        return Logger.vt(loggerConfig.getDefaultTag(), tr);
    }

    public static int v(String msg, Throwable tr) {
        return Logger.vt(loggerConfig.getDefaultTag(), msg, tr);
    }

    public static int dt(Tag tag, Throwable tr) {
        return Logger.dt(tag, Logger.getStackTraceString(tr));
    }

    public static int dt(Tag tag, String msg, Throwable tr) {
        return Logger.dt(tag, "%s\n%s", msg, Logger.getStackTraceString(tr));
    }

    private static int dt(Tag tag, String format, Object ... args) {
        if (loggerConfig.isPrintLoggable(3)) {
            String message = null;
            message = args != null && args.length > 0 ? String.format(format, args) : format;
            return Logger.printLog(tag, 3, message);
        }
        return 0;
    }

    public static int dt(Tag tag, String msg) {
        return Logger.printLog(tag, 3, msg);
    }

    public static int d(String format, Object ... args) {
        return Logger.dt(loggerConfig.getDefaultTag(), format, args);
    }

    public static int d(String msg) {
        return Logger.dt(loggerConfig.getDefaultTag(), msg);
    }

    public static int d(Throwable tr) {
        return Logger.dt(loggerConfig.getDefaultTag(), tr);
    }

    public static int d(String msg, Throwable tr) {
        return Logger.dt(loggerConfig.getDefaultTag(), msg, tr);
    }

    public static int it(Tag tag, Throwable tr) {
        return Logger.it(tag, Logger.getStackTraceString(tr));
    }

    public static int it(Tag tag, String msg, Throwable tr) {
        return Logger.it(tag, "%s\n%s", msg, Logger.getStackTraceString(tr));
    }

    private static int it(Tag tag, String format, Object ... args) {
        if (loggerConfig.isPrintLoggable(4)) {
            String message = null;
            message = args != null && args.length > 0 ? String.format(format, args) : format;
            return Logger.printLog(tag, 4, message);
        }
        return 0;
    }

    public static int it(Tag tag, String msg) {
        return Logger.printLog(tag, 4, msg);
    }

    public static int i(String format, Object ... args) {
        return Logger.it(loggerConfig.getDefaultTag(), format, args);
    }

    public static int i(Throwable tr) {
        return Logger.it(loggerConfig.getDefaultTag(), tr);
    }

    public static int i(String msg, Throwable tr) {
        return Logger.it(loggerConfig.getDefaultTag(), msg, tr);
    }

    public static int wt(Tag tag, Throwable tr) {
        return Logger.wt(tag, Logger.getStackTraceString(tr));
    }

    public static int wt(Tag tag, String msg, Throwable tr) {
        return Logger.wt(tag, "%s\n%s", msg, Logger.getStackTraceString(tr));
    }

    private static int wt(Tag tag, String format, Object ... args) {
        if (loggerConfig.isPrintLoggable(5)) {
            String message = String.format(format, args);
            return Logger.printLog(tag, 5, message);
        }
        return 0;
    }

    public static int wt(Tag tag, String msg) {
        return Logger.printLog(tag, 5, msg);
    }

    public static int w(String format, Object ... args) {
        return Logger.wt(loggerConfig.getDefaultTag(), format, args);
    }

    public static int w(String msg) {
        return Logger.wt(loggerConfig.getDefaultTag(), msg);
    }

    public static int w(Throwable tr) {
        return Logger.wt(loggerConfig.getDefaultTag(), tr);
    }

    public static int w(String msg, Throwable tr) {
        return Logger.wt(loggerConfig.getDefaultTag(), msg, tr);
    }

    public static int et(Tag tag, Throwable tr) {
        return Logger.et(tag, Logger.getStackTraceString(tr));
    }

    public static int et(Tag tag, String msg, Throwable tr) {
        return Logger.et(tag, "%s\n%s", msg, Logger.getStackTraceString(tr));
    }

    private static int et(Tag tag, String format, Object ... args) {
        if (loggerConfig.isPrintLoggable(6)) {
            String message = null;
            message = args != null && args.length > 0 ? String.format(format, args) : format;
            return Logger.printLog(tag, 6, message);
        }
        return 0;
    }

    public static int et(Tag tag, String msg) {
        return Logger.printLog(tag, 6, msg);
    }

    public static int e(String format, Object ... args) {
        return Logger.et(loggerConfig.getDefaultTag(), format, args);
    }

    public static int e(String msg) {
        return Logger.et(loggerConfig.getDefaultTag(), msg);
    }

    public static int e(Throwable tr) {
        return Logger.et(loggerConfig.getDefaultTag(), tr);
    }

    public static int e(String msg, Throwable tr) {
        return Logger.et(loggerConfig.getDefaultTag(), msg, tr);
    }

    public static int devt(Tag tag, Throwable tr) {
        return Logger.devt(tag, Logger.getStackTraceString(tr));
    }

    public static int devt(Tag tag, String msg, Throwable tr) {
        return Logger.devt(tag, "%s\n%s", msg, Logger.getStackTraceString(tr));
    }

    private static int devt(Tag tag, String format, Object ... args) {
        if (loggerConfig.isPrintLoggable(0)) {
            String message = null;
            message = args != null && args.length > 0 ? String.format(format, args) : format;
            return Logger.printLog(tag, 0, message);
        }
        return 0;
    }

    public static int devt(Tag tag, String msg) {
        return Logger.printLog(tag, 0, msg);
    }

    public static int dev(String format, Object ... args) {
        return Logger.devt(loggerConfig.getDefaultTag(), format, args);
    }

    public static int dev(String msg) {
        return Logger.devt(loggerConfig.getDefaultTag(), msg);
    }

    public static int dev(Throwable tr) {
        return Logger.devt(loggerConfig.getDefaultTag(), tr);
    }

    public static int dev(String msg, Throwable tr) {
        return Logger.devt(loggerConfig.getDefaultTag(), msg, tr);
    }
}

