/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Base64;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.FileMessage;
import com.sendbird.android.HashUtils;
import com.sendbird.android.MessageMetaArray;
import com.sendbird.android.Reaction;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseMessage {
    static final int NEVER_DELETED_AUTOMATICALLY = -1;
    protected static final Set<Integer> RESENDABLE_ERROR_CODES = new HashSet<Integer>(Arrays.asList(800101, 800120, 800180, 800200, 800210));
    protected long mMessageId;
    protected String mChannelUrl;
    protected String mChannelType;
    protected String mData = "";
    protected String mCustomType = "";
    protected long mCreatedAt;
    protected long mUpdatedAt;
    protected BaseMessageParams.MentionType mMentionType = BaseMessageParams.MentionType.USERS;
    protected List<String> mMentionedUserIds;
    protected List<User> mMentionedUsers;
    protected List<MessageMetaArray> mMetaArrays;
    protected boolean mIsGlobalBlocked;
    protected int mErrorCode = 0;
    private boolean mIsSilent = false;
    private boolean forceUpdateLastMessage = false;
    private final List<Reaction> reactionList = new ArrayList<Reaction>();
    private SendingStatus sendingStatus = SendingStatus.NONE;
    private int messageSurvivalSeconds;

    public abstract String getRequestId();

    public abstract String getMessage();

    public abstract Sender getSender();

    void setSendingStatus(SendingStatus sendingStatus) {
        this.sendingStatus = sendingStatus;
    }

    public SendingStatus getSendingStatus() {
        return this.sendingStatus;
    }

    public boolean isResendable() {
        return this.sendingStatus == SendingStatus.CANCELED || this.sendingStatus == SendingStatus.FAILED && RESENDABLE_ERROR_CODES.contains(this.mErrorCode);
    }

    public static boolean belongsTo(BaseMessage message, String userId) {
        if (TextUtils.isEmpty((CharSequence)userId)) {
            return false;
        }
        Sender sender = message.getSender();
        return sender != null && sender.getUserId().equalsIgnoreCase(userId);
    }

    protected static BaseMessage build(JsonElement el, String channelUrl, String channelType) {
        try {
            JsonObject obj = el.getAsJsonObject();
            String type = obj.get("type").getAsString();
            int messageSurvivalSeconds = obj.has("message_survival_seconds") ? obj.get("message_survival_seconds").getAsInt() : -1;
            switch (type) {
                case "MESG": {
                    String mentionTypeString;
                    String reqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
                    SendingStatus sendingStatus = SendingStatus.SUCCEEDED;
                    if (obj.has("request_state")) {
                        sendingStatus = SendingStatus.fromValue(obj.get("request_state").getAsString());
                    }
                    Sender sender = new Sender(obj.get("user"));
                    long msgId = obj.has("message_id") ? obj.get("message_id").getAsLong() : 0L;
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String translations = obj.has("translations") ? obj.get("translations").toString() : null;
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String reactions = obj.has("reactions") ? obj.get("reactions").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    String metaArrayKeyOrder = obj.has("metaarray_key_order") ? obj.get("metaarray_key_order").toString() : null;
                    String sortedMetaArray = obj.has("sorted_metaarray") ? obj.get("sorted_metaarray").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    int errorCode = obj.has("error_code") ? obj.get("error_code").getAsInt() : 0;
                    boolean isSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
                    boolean forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
                    return new UserMessage(UserMessage.build(reqId, sendingStatus, msgId, sender, channelUrl, channelType, message, data, customType, translations, createdAt, updatedAt, mentionType, null, mentionedUsers, reactions, metaArray, metaArrayKeyOrder, sortedMetaArray, isGlobalBlocked, errorCode, isSilent, forceUpdateLastMessage, messageSurvivalSeconds));
                }
                case "FILE": {
                    String mentionTypeString;
                    String reqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
                    SendingStatus sendingStatus = SendingStatus.SUCCEEDED;
                    if (obj.has("request_state")) {
                        sendingStatus = SendingStatus.fromValue(obj.get("request_state").getAsString());
                    }
                    Sender sender = new Sender(obj.get("user"));
                    long msgId = obj.get("message_id").getAsLong();
                    JsonObject file = obj.get("file").getAsJsonObject();
                    String url = file.get("url").getAsString();
                    String name = file.get("name").getAsString();
                    String fileType = file.get("type").getAsString();
                    int size = file.get("size").getAsInt();
                    String data = file.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String thumbnails = obj.has("thumbnails") ? obj.get("thumbnails").toString() : null;
                    boolean requireAuth = obj.has("require_auth") && obj.get("require_auth").getAsBoolean();
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String reactions = obj.has("reactions") ? obj.get("reactions").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    String metaArrayKeyOrder = obj.has("metaarray_key_order") ? obj.get("metaarray_key_order").toString() : null;
                    String sortedMetaArray = obj.has("sorted_metaarray") ? obj.get("sorted_metaarray").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    int errorCode = obj.has("error_code") ? obj.get("error_code").getAsInt() : 0;
                    boolean isSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
                    boolean forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
                    return new FileMessage(FileMessage.build(reqId, sendingStatus, msgId, sender, channelUrl, channelType, url, name, fileType, size, data, customType, thumbnails, requireAuth, createdAt, updatedAt, mentionType, null, mentionedUsers, reactions, metaArray, metaArrayKeyOrder, sortedMetaArray, isGlobalBlocked, errorCode, isSilent, forceUpdateLastMessage, messageSurvivalSeconds));
                }
                case "BRDM": 
                case "ADMM": {
                    String mentionTypeString;
                    long msgId = obj.get("message_id").getAsLong();
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String reactions = obj.has("reactions") ? obj.get("reactions").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    String metaArrayKeyOrder = obj.has("metaarray_key_order") ? obj.get("metaarray_key_order").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    boolean isSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
                    boolean forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
                    return new AdminMessage(AdminMessage.build(msgId, channelUrl, channelType, message, data, customType, createdAt, updatedAt, mentionType, null, mentionedUsers, reactions, metaArray, metaArrayKeyOrder, isGlobalBlocked, isSilent, forceUpdateLastMessage, messageSurvivalSeconds));
                }
            }
            Logger.e("Unknown message type: " + type);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        return null;
    }

    public BaseMessage(String channelUrl, long msgId, long createdAt) {
        this.mChannelUrl = channelUrl;
        this.mMessageId = msgId;
        this.mCreatedAt = createdAt;
    }

    protected BaseMessage(JsonElement el) {
        int i;
        JsonArray array;
        JsonObject obj = el.getAsJsonObject();
        this.mMessageId = obj.has("msg_id") ? obj.get("msg_id").getAsLong() : 0L;
        this.mChannelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.mChannelType = obj.has("channel_type") ? obj.get("channel_type").getAsString() : "group";
        this.mCreatedAt = obj.has("ts") ? obj.get("ts").getAsLong() : 0L;
        long l = this.mUpdatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
        if (obj.has("mention_type")) {
            String mentionType = obj.get("mention_type").getAsString();
            if (mentionType.equals("users")) {
                this.mMentionType = BaseMessageParams.MentionType.USERS;
            } else if (mentionType.equals("channel")) {
                this.mMentionType = BaseMessageParams.MentionType.CHANNEL;
            }
        }
        this.mMentionedUserIds = new ArrayList<String>();
        if (obj.has("mentioned_user_ids")) {
            array = obj.getAsJsonArray("mentioned_user_ids");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i) == null) continue;
                this.mMentionedUserIds.add(array.get(i).getAsString());
            }
        }
        this.mMentionedUsers = new ArrayList<User>();
        if (obj.has("mentioned_users")) {
            array = obj.getAsJsonArray("mentioned_users");
            for (i = 0; i < array.size(); ++i) {
                this.mMentionedUsers.add(new User(array.get(i)));
            }
        }
        if (obj.has("reactions")) {
            array = obj.getAsJsonArray("reactions");
            for (i = 0; i < array.size(); ++i) {
                Reaction reaction = new Reaction(array.get(i));
                if (reaction.getUserIds().size() <= 0) continue;
                this.addReaction(reaction);
            }
        }
        this.mMetaArrays = new ArrayList<MessageMetaArray>();
        if (obj.has("metaarray")) {
            HashMap<String, MessageMetaArray> metaArrayMap = new HashMap<String, MessageMetaArray>();
            JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
            for (String key : metaArrayObj.keySet()) {
                if (key == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                JsonArray array2 = metaArrayObj.get(key).getAsJsonArray();
                for (int i2 = 0; i2 < array2.size(); ++i2) {
                    String value = array2.get(i2).getAsString();
                    values.add(value);
                }
                metaArrayMap.put(key, new MessageMetaArray(key, values));
            }
            if (obj.has("metaarray_key_order")) {
                JsonArray metaArrayKeyOrderArray = obj.getAsJsonArray("metaarray_key_order");
                for (int i3 = 0; i3 < metaArrayKeyOrderArray.size(); ++i3) {
                    String orderedKey = metaArrayKeyOrderArray.get(i3).getAsString();
                    if (!metaArrayMap.containsKey(orderedKey)) continue;
                    this.mMetaArrays.add((MessageMetaArray)metaArrayMap.get(orderedKey));
                }
            } else {
                this.mMetaArrays.addAll(metaArrayMap.values());
            }
        } else if (obj.has("sorted_metaarray")) {
            JsonArray sortedMetaArray = obj.get("sorted_metaarray").getAsJsonArray();
            for (i = 0; i < sortedMetaArray.size(); ++i) {
                JsonArray valueArray;
                JsonObject metaArrayObj = sortedMetaArray.get(i).getAsJsonObject();
                String key = metaArrayObj.has("key") ? metaArrayObj.get("key").getAsString() : null;
                JsonArray jsonArray = valueArray = metaArrayObj.has("value") ? metaArrayObj.get("value").getAsJsonArray() : null;
                if (key == null) continue;
                ArrayList<String> value = new ArrayList<String>();
                if (valueArray != null) {
                    for (int j = 0; j < valueArray.size(); ++j) {
                        value.add(valueArray.get(j).getAsString());
                    }
                }
                this.mMetaArrays.add(new MessageMetaArray(key, value));
            }
        }
        this.mIsGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
        this.mIsSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
        boolean bl = this.forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
        if (obj.has("request_state")) {
            this.sendingStatus = SendingStatus.fromValue(obj.get("request_state").getAsString());
        }
        if (this.sendingStatus == SendingStatus.NONE && this.mMessageId > 0L) {
            this.sendingStatus = SendingStatus.SUCCEEDED;
        }
        this.messageSurvivalSeconds = obj.has("message_survival_seconds") ? obj.get("message_survival_seconds").getAsInt() : -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JsonElement toJson() {
        JsonArray array;
        JsonObject obj = new JsonObject();
        obj.addProperty("message_id", (Number)this.mMessageId);
        obj.addProperty("channel_url", this.mChannelUrl);
        obj.addProperty("channel_type", this.mChannelType);
        obj.addProperty("created_at", (Number)this.mCreatedAt);
        obj.addProperty("updated_at", (Number)this.mUpdatedAt);
        if (this.mMentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (this.mMentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (this.mMentionedUserIds != null && this.mMentionedUserIds.size() > 0) {
            array = new JsonArray();
            for (String string : this.mMentionedUserIds) {
                if (string == null) continue;
                array.add(string);
            }
            obj.add("mentioned_user_ids", (JsonElement)array);
        }
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            array = new JsonArray();
            for (User user : this.mMentionedUsers) {
                if (user == null) continue;
                array.add(user.toJson());
            }
            obj.add("mentioned_users", (JsonElement)array);
        }
        if (this.reactionList.size() > 0) {
            array = new JsonArray();
            Iterator<MessageMetaArray> iterator = this.reactionList;
            synchronized (iterator) {
                for (Reaction reaction : this.reactionList) {
                    if (reaction == null) continue;
                    array.add(reaction.toJson());
                }
            }
            obj.add("reactions", (JsonElement)array);
        }
        if (this.mMetaArrays != null && this.mMetaArrays.size() > 0) {
            JsonArray sortedMetaArray = new JsonArray();
            for (MessageMetaArray messageMetaArray : this.mMetaArrays) {
                sortedMetaArray.add((JsonElement)messageMetaArray.toJson());
            }
            obj.add("sorted_metaarray", (JsonElement)sortedMetaArray);
        }
        obj.addProperty("is_global_block", Boolean.valueOf(this.mIsGlobalBlocked));
        obj.addProperty("silent", Boolean.valueOf(this.mIsSilent));
        obj.addProperty("force_update_last_message", Boolean.valueOf(this.forceUpdateLastMessage));
        obj.addProperty("request_state", this.sendingStatus.getValue());
        obj.addProperty("message_survival_seconds", (Number)this.messageSurvivalSeconds);
        return obj;
    }

    public static BaseMessage buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
            return BaseMessage.build((JsonElement)obj, obj.get("channel_url").getAsString(), obj.get("channel_type").getAsString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getMessageId() {
        return this.mMessageId;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public long getUpdatedAt() {
        return this.mUpdatedAt;
    }

    public BaseMessageParams.MentionType getMentionType() {
        return this.mMentionType;
    }

    public List<User> getMentionedUsers() {
        return this.mMentionedUsers;
    }

    List<String> getMentionedUserIds() {
        ArrayList<String> mentionedUserIds = null;
        if (this.sendingStatus != SendingStatus.SUCCEEDED && this.mMentionedUserIds != null && this.mMentionedUserIds.size() > 0) {
            mentionedUserIds = new ArrayList<String>(this.mMentionedUserIds);
            return mentionedUserIds;
        }
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            mentionedUserIds = new ArrayList();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null || mentionedUser.getUserId() == null || mentionedUser.getUserId().length() <= 0) continue;
                mentionedUserIds.add(mentionedUser.getUserId());
            }
        }
        return mentionedUserIds;
    }

    boolean isMentionedFromSomeoneToMe(User sender) {
        String currentUserId;
        boolean result = false;
        String string = currentUserId = SendBird.getCurrentUser() != null ? SendBird.getCurrentUser().getUserId() : null;
        if (sender == null || currentUserId != null && !currentUserId.equals(sender.getUserId())) {
            if (this.mMentionType == BaseMessageParams.MentionType.CHANNEL) {
                result = true;
            } else if (currentUserId != null && currentUserId.length() > 0 && this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
                for (User mentionedUser : this.mMentionedUsers) {
                    if (!mentionedUser.getUserId().equals(currentUserId)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public boolean isOpenChannel() {
        return this.mChannelType.equals("open");
    }

    public boolean isGroupChannel() {
        return this.mChannelType.equals("group");
    }

    public String getData() {
        return this.mData;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public List<Reaction> getReactions() {
        return Collections.unmodifiableList(this.reactionList);
    }

    public Map<String, List<String>> getAllMetaArray() {
        HashMap<String, List<String>> metaArrayMap = new HashMap<String, List<String>>();
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            metaArrayMap.put(metaArray.getKey(), metaArray.getValue());
        }
        return metaArrayMap;
    }

    public List<MessageMetaArray> getAllMetaArrays() {
        return new ArrayList<MessageMetaArray>(this.mMetaArrays);
    }

    public Map<String, List<String>> getMetaArray(Collection<String> metaArrayKeys) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        List<MessageMetaArray> metaArrays = this.getMetaArrays(metaArrayKeys);
        for (MessageMetaArray metaArray : metaArrays) {
            resultMap.put(metaArray.getKey(), metaArray.getValue());
        }
        return resultMap;
    }

    public List<MessageMetaArray> getMetaArrays(Collection<String> metaArrayKeys) {
        ArrayList<MessageMetaArray> metaArrays = new ArrayList<MessageMetaArray>();
        if (this.mMetaArrays != null && metaArrayKeys != null && metaArrayKeys.size() > 0) {
            for (String key : metaArrayKeys) {
                MessageMetaArray metaArray = this.getMetaArrayByKey(key);
                if (metaArray == null) continue;
                metaArrays.add(metaArray);
            }
        }
        return metaArrays;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public int getMessageSurvivalSeconds() {
        return this.messageSurvivalSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReaction(Reaction reaction) {
        List<Reaction> list = this.reactionList;
        synchronized (list) {
            this.reactionList.add(reaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeReaction(Reaction reaction) {
        List<Reaction> list = this.reactionList;
        synchronized (list) {
            this.reactionList.remove(reaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reaction getReaction(String key) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        List<Reaction> list = this.reactionList;
        synchronized (list) {
            for (Reaction reaction : this.reactionList) {
                if (!key.equals(reaction.getKey())) continue;
                return reaction;
            }
        }
        return null;
    }

    public boolean applyReactionEvent(ReactionEvent reactionEvent) {
        if (reactionEvent == null) {
            return false;
        }
        if (this.mMessageId != reactionEvent.getMessageId()) {
            return false;
        }
        String key = reactionEvent.getKey();
        Reaction reaction = this.getReaction(key);
        if (reaction != null) {
            if (reaction.merge(reactionEvent)) {
                if (reactionEvent.getOperation() == ReactionEvent.ReactionEventAction.DELETE && reaction.getUserIds().size() == 0) {
                    this.removeReaction(reaction);
                }
                return true;
            }
            return false;
        }
        if (reactionEvent.getOperation() == ReactionEvent.ReactionEventAction.ADD) {
            this.addReaction(new Reaction(reactionEvent));
            return true;
        }
        return false;
    }

    MessageMetaArray getMetaArrayByKey(String key) {
        if (key == null) {
            return null;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            return metaArray;
        }
        return null;
    }

    void addMetaArray(String key) {
        this.addMetaArray(key, new ArrayList<String>());
    }

    void addMetaArray(String key, List<String> value) {
        if (key == null) {
            return;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            return;
        }
        this.mMetaArrays.add(new MessageMetaArray(key, value));
    }

    void setMetaArray(String key, List<String> value) {
        if (key == null) {
            return;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            metaArray.setValue(value);
            return;
        }
        this.mMetaArrays.add(new MessageMetaArray(key, value));
    }

    void removeMetaArrayByKey(String key) {
        if (key == null) {
            return;
        }
        for (int i = 0; i < this.mMetaArrays.size(); ++i) {
            if (!key.equals(this.mMetaArrays.get(i).getKey())) continue;
            this.mMetaArrays.remove(i);
            break;
        }
    }

    boolean isSilent() {
        return this.mIsSilent;
    }

    boolean shouldForceUpdateLastMessage() {
        return this.forceUpdateLastMessage;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BaseMessage message = (BaseMessage)o;
        if (this.getMessageId() != message.getMessageId() || !this.getChannelUrl().equals(message.getChannelUrl()) || this.getCreatedAt() != message.getCreatedAt()) {
            return false;
        }
        if (this.getMessageId() == 0L && message.getMessageId() == 0L) {
            return this.getRequestId().equals(message.getRequestId());
        }
        return true;
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getMessageId(), this.getChannelUrl(), this.getCreatedAt(), this.getRequestId());
    }

    public String toString() {
        return "BaseMessage{mMessageId=" + this.mMessageId + ", mChannelUrl='" + this.mChannelUrl + '\'' + ", mChannelType='" + this.mChannelType + '\'' + ", mData='" + this.mData + '\'' + ", mCustomType='" + this.mCustomType + '\'' + ", mCreatedAt=" + this.mCreatedAt + ", mUpdatedAt=" + this.mUpdatedAt + ", mMentionType=" + (Object)((Object)this.mMentionType) + ", mMentionedUserIds=" + this.mMentionedUserIds + ", mMentionedUsers=" + this.mMentionedUsers + ", mMetaArrays=" + this.mMetaArrays + ", mIsGlobalBlocked=" + this.mIsGlobalBlocked + ", mErrorCode=" + this.mErrorCode + ", mIsSilent=" + this.mIsSilent + ", forceUpdateLastMessage=" + this.forceUpdateLastMessage + ", reactionList=" + this.reactionList + ", sendingStatus=" + (Object)((Object)this.sendingStatus) + ", messageSurvivalSeconds=" + this.messageSurvivalSeconds + '}';
    }

    public static enum SendingStatus {
        NONE("none"),
        PENDING("pending"),
        FAILED("failed"),
        SUCCEEDED("succeeded"),
        CANCELED("canceled");

        private String value;

        private SendingStatus(String value) {
            this.value = value;
        }

        public static SendingStatus fromValue(String value) {
            for (SendingStatus status : SendingStatus.values()) {
                if (!status.getValue().equals(value)) continue;
                return status;
            }
            return NONE;
        }

        public String getValue() {
            return this.value;
        }
    }
}

