/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.Sender;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.List;

public final class AdminMessage
extends BaseMessage {
    private String mMessage = "";

    static JsonElement build(long msgId, String channelUrl, String channelType, String message, String data, String customType, long createdAt, long updatedAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String reactions, String metaArray, String metaArrayKeyOrder, boolean isGlobalBlocked, boolean isSilent, boolean forceUpdateLastMessage, int messageSurvivalSeconds) {
        JsonObject obj = new JsonObject();
        obj.addProperty("msg_id", (Number)msgId);
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("channel_type", channelType);
        obj.addProperty("ts", (Number)createdAt);
        obj.addProperty("updated_at", (Number)updatedAt);
        obj.addProperty("message", message);
        if (data != null) {
            obj.addProperty("data", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            JsonArray array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                if (mentionedUserId == null || mentionedUserId.length() <= 0) continue;
                array.add(mentionedUserId);
            }
            obj.add("mentioned_user_ids", (JsonElement)array);
        }
        if (mentionedUsers != null) {
            obj.add("mentioned_users", new JsonParser().parse(mentionedUsers));
        }
        if (reactions != null) {
            obj.add("reactions", new JsonParser().parse(reactions));
        }
        if (metaArray != null) {
            obj.add("metaarray", new JsonParser().parse(metaArray));
        }
        if (metaArrayKeyOrder != null) {
            obj.add("metaarray_key_order", new JsonParser().parse(metaArrayKeyOrder));
        }
        obj.addProperty("is_global_block", Boolean.valueOf(isGlobalBlocked));
        obj.addProperty("silent", Boolean.valueOf(isSilent));
        obj.addProperty("force_update_last_message", Boolean.valueOf(forceUpdateLastMessage));
        obj.addProperty("message_survival_seconds", (Number)messageSurvivalSeconds);
        return obj;
    }

    AdminMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mMessage = obj.get("message").getAsString();
        this.mData = obj.has("data") ? obj.get("data").getAsString() : "";
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", "ADMM");
        obj.addProperty("message", this.mMessage);
        obj.addProperty("data", this.mData);
        obj.addProperty("custom_type", this.mCustomType);
        return obj;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    @Override
    public String getRequestId() {
        return "";
    }

    @Override
    public Sender getSender() {
        return null;
    }

    @Override
    public BaseMessage.SendingStatus getSendingStatus() {
        return BaseMessage.SendingStatus.NONE;
    }

    @Override
    public boolean isResendable() {
        return false;
    }

    @Override
    public int getMessageSurvivalSeconds() {
        return -1;
    }

    @Override
    public String toString() {
        return super.toString() + "\nAdminMessage{mMessage='" + this.mMessage + '}';
    }
}

