/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import com.google.firebase.messaging.RemoteMessage;
import com.sendbird.android.APIClient;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.OnPushTokenReceiveListener;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.SendBirdPushHandler;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;
import org.json.JSONObject;

public class SendBirdPushHelper {
    private static SendBirdPushHandler handler;
    private static final AtomicReference<String> pushToken;
    private static final AtomicReference<RegisterTokenStatus> tokenStatus;
    private static final Map<Long, Long> delieverdMessageCache;

    static void retryPendingAction() {
        Logger.d(">> SendBirdPushHelper::retryPendingAction() tokenStatus : " + tokenStatus);
        switch (tokenStatus.get()) {
            case NeedToRegisterPushToken: {
                SendBirdPushHelper.requestSendBirdPushNotification(false, true, null);
                break;
            }
        }
    }

    private static void registerPushToken(final String token, boolean unique, final OnPushRequestCompleteListener listener) {
        SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.NeedToRegisterPushToken, token);
        if (SendBird.getCurrentUser() == null) {
            if (listener != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onError(new SendBirdException("Connection must be made.", 800101));
                        }
                    }
                });
            }
            return;
        }
        Logger.d(">> SendBirdPushHelper::registerPushToken()");
        if (token != null && !token.equals(pushToken.get())) {
            Logger.d("++ requested token : " + token + ", unique : " + unique);
            SendBird.registerPushTokenForCurrentUser(token, unique, new SendBird.RegisterPushTokenWithStatusHandler(){

                @Override
                public void onRegistered(SendBird.PushTokenRegistrationStatus status, SendBirdException e) {
                    if (e != null) {
                        Logger.e(e);
                        if (e.getCode() == 400111) {
                            SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.Empty, token);
                        }
                        if (listener != null) {
                            listener.onError(e);
                        }
                        return;
                    }
                    SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.PushTokenRegistered, token);
                    if (listener != null) {
                        listener.onComplete(true, token);
                    }
                }
            });
        } else {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        if (token == null) {
                            listener.onError(new SendBirdException("token is null. you have to fill token value."));
                        } else {
                            listener.onComplete(false, token);
                        }
                    }
                }
            });
        }
    }

    private static void unregisterPushToken(boolean unRegisterAll, final String token, final OnPushRequestCompleteListener listener) {
        Logger.d(">> SendBirdPushHelper::unregisterPushToken()");
        Logger.d("++ token : " + token);
        if (TextUtils.isEmpty((CharSequence)token)) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    if (listener != null) {
                        listener.onError(new SendBirdException("token is null. you have to fill token value."));
                    }
                }
            });
            return;
        }
        if (SendBird.getCurrentUser() == null) {
            if (listener != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (listener != null) {
                            listener.onError(new SendBirdException("Connection must be made.", 800101));
                        }
                    }
                });
            }
            return;
        }
        if (unRegisterAll) {
            APIClient.getInstance().unregisterPushTokenAll(new APIClient.APIClientHandler(){

                @Override
                public void onResult(JsonElement response, SendBirdException e) {
                    SendBirdPushHelper.processUnRegisterPushToken(token, listener, e);
                }
            });
        } else {
            APIClient.getInstance().unregisterPushToken(token, new APIClient.APIClientHandler(){

                @Override
                public void onResult(JsonElement response, SendBirdException e) {
                    SendBirdPushHelper.processUnRegisterPushToken(token, listener, e);
                }
            });
        }
    }

    private static void processUnRegisterPushToken(final String token, final OnPushRequestCompleteListener listener, final SendBirdException e) {
        SendBird.runOnUIThread(new Runnable(){

            @Override
            public void run() {
                if (e != null) {
                    Logger.e(e);
                    if (e.getCode() == 400111) {
                        SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.Empty, token);
                    }
                    if (listener != null) {
                        listener.onError(e);
                    }
                    return;
                }
                SendBirdPushHelper.changeTokenStatus(RegisterTokenStatus.Empty, token);
                if (listener != null) {
                    listener.onComplete(false, null);
                }
            }
        });
    }

    public static void registerPushHandler(SendBirdPushHandler handler) {
        Logger.d(">> SendBirdPushHelper::registerPushHandler()");
        SendBirdPushHelper.handler = handler;
        delieverdMessageCache.clear();
        SendBirdPushHelper.requestSendBirdPushNotification(false, true, null);
    }

    public static void unregisterPushHandler(OnPushRequestCompleteListener listener) {
        SendBirdPushHelper.unregisterPushHandler(false, listener);
    }

    public static void unregisterPushHandler(boolean unRegisterAll, final OnPushRequestCompleteListener listener) {
        Logger.d(">> SendBirdPushHelper::unregisterPushHandler()");
        SendBirdPushHelper.requestSendBirdPushNotification(unRegisterAll, false, new OnPushRequestCompleteListener(){

            @Override
            public void onComplete(boolean isRegisted, String token) {
                handler = null;
                delieverdMessageCache.clear();
                if (listener != null) {
                    listener.onComplete(isRegisted, token);
                }
            }

            @Override
            public void onError(SendBirdException e) {
                if (listener != null) {
                    listener.onError(e);
                }
            }
        });
    }

    private static void requestSendBirdPushNotification(final boolean unRegisterAll, final boolean enable, final OnPushRequestCompleteListener listener) {
        Logger.d(">> SendBirdPushHelper::requestSendBirdPushNotification() enable : " + enable);
        String currentPushToken = pushToken.get();
        if (!enable && !TextUtils.isEmpty((CharSequence)currentPushToken)) {
            SendBirdPushHelper.unregisterPushToken(unRegisterAll, currentPushToken, listener);
        } else {
            SendBirdPushHelper.getPushToken(new OnPushTokenReceiveListener(){

                @Override
                public void onReceived(final String token, final SendBirdException e) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (e != null) {
                                Logger.e(e);
                                if (listener != null) {
                                    listener.onError(e);
                                }
                                return;
                            }
                            if (enable) {
                                if (handler == null) {
                                    if (listener != null) {
                                        listener.onError(new SendBirdException("you have to register handler first. call setFirebasePushHandler()", 800110));
                                    }
                                    return;
                                }
                                boolean unique = handler.isUniquePushToken();
                                SendBirdPushHelper.registerPushToken(token, unique, listener);
                            } else {
                                SendBirdPushHelper.unregisterPushToken(unRegisterAll, token, listener);
                            }
                        }
                    });
                }
            });
        }
    }

    public static boolean isDuplicateMessage(RemoteMessage remoteMessage) {
        try {
            JSONObject sendBird;
            Long msgId;
            if (remoteMessage.getData().containsKey("sendbird") && delieverdMessageCache.get(msgId = Long.valueOf((sendBird = new JSONObject((String)remoteMessage.getData().get("sendbird"))).optLong("message_id"))) != null) {
                Logger.d("__duplicated sendbird message. [" + msgId + "]");
                return true;
            }
        }
        catch (JSONException e) {
            Logger.e(e);
        }
        return false;
    }

    static void messageDeleivered(BaseMessage message) {
        Logger.d(">> SendBirdPushHelper::messageDeleivered()");
        Logger.d("++ MsgId : " + message.getMessageId());
        long msgId = message.getMessageId();
        delieverdMessageCache.put(msgId, msgId);
    }

    static void onNewToken(String token) {
        if (handler != null) {
            SendBirdPushHelper.registerPushToken(token, handler.isUniquePushToken(), null);
            handler.onNewToken(token);
        }
    }

    static void onMessageReceived(Context context, RemoteMessage remoteMessage) {
        Logger.d(">> SendBirdPushHelper::onMessageReceived()");
        if (SendBirdPushHelper.isSendBirdMessage(remoteMessage)) {
            if (!SendBird.isInitialized() || SendBird.getCurrentUser() == null) {
                return;
            }
            if (SendBirdPushHelper.isDuplicateMessage(remoteMessage)) {
                return;
            }
            if (!SendBird.isAppBackground()) {
                return;
            }
        }
        if (handler != null) {
            handler.onMessageReceived(context, remoteMessage);
        }
    }

    private static boolean isSendBirdMessage(RemoteMessage remoteMessage) {
        return remoteMessage.getData().containsKey("sendbird");
    }

    public static void getPushToken(final OnPushTokenReceiveListener listener) {
        block2: {
            try {
                FirebaseInstanceId.getInstance().getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){
                    private String errorMessage = "FCM token access is failure.";

                    public void onComplete(Task<InstanceIdResult> task) {
                        if (!task.isSuccessful()) {
                            if (listener != null) {
                                Exception e = task.getException();
                                Log.w((String)"FCM", (String)"getInstanceId failed", (Throwable)e);
                                if (e != null && !TextUtils.isEmpty((CharSequence)e.getMessage())) {
                                    this.errorMessage = e.getMessage();
                                }
                                listener.onReceived(this.errorMessage, new SendBirdException(this.errorMessage, 800220));
                            }
                            return;
                        }
                        InstanceIdResult result = (InstanceIdResult)task.getResult();
                        if (result != null) {
                            String token = result.getToken();
                            Log.d((String)"FCM", (String)("FCM token : " + token + " by OnCompleteListener"));
                            if (listener != null) {
                                listener.onReceived(token, null);
                            }
                        } else {
                            listener.onReceived("getting fcm token is failed", new SendBirdException(this.errorMessage, 800220));
                        }
                    }
                });
            }
            catch (Throwable e) {
                Log.w((String)"FCM", (Throwable)e);
                String token = FirebaseInstanceId.getInstance().getToken();
                if (listener == null) break block2;
                listener.onReceived(token, null);
            }
        }
    }

    private static synchronized void changeTokenStatus(RegisterTokenStatus status, String currentToken) {
        tokenStatus.set(status);
        switch (status) {
            case PushTokenRegistered: {
                pushToken.set(currentToken);
                break;
            }
            case NeedToRegisterPushToken: 
            case Empty: {
                pushToken.set(null);
                break;
            }
        }
    }

    static {
        pushToken = new AtomicReference();
        tokenStatus = new AtomicReference<RegisterTokenStatus>(RegisterTokenStatus.Empty);
        delieverdMessageCache = new ConcurrentHashMap<Long, Long>();
    }

    public static interface OnPushRequestCompleteListener {
        public void onComplete(boolean var1, String var2);

        public void onError(SendBirdException var1);
    }

    private static enum RegisterTokenStatus {
        Empty,
        PushTokenRegistered,
        NeedToRegisterPushToken;

    }
}

