/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.text.TextUtils;
import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class AES256Chiper {
    private static final byte[] ivBytes = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";

    private AES256Chiper() {
    }

    static String encrypt(String key, String str) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, UnsupportedEncodingException, BadPaddingException, IllegalBlockSizeException {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        Key keySpec = AES256Chiper.createKeySpec(key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(1, keySpec, new IvParameterSpec(ivBytes));
        byte[] encrypted = cipher.doFinal(str.getBytes(DEFAULT_CHARSET));
        return Base64.encodeToString((byte[])encrypted, (int)2);
    }

    static String decrypt(String key, String encodedStr) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, UnsupportedEncodingException {
        if (TextUtils.isEmpty((CharSequence)encodedStr)) {
            return encodedStr;
        }
        Key keySpec = AES256Chiper.createKeySpec(key);
        Cipher cipher = Cipher.getInstance(ALGORITHM);
        cipher.init(2, keySpec, new IvParameterSpec(ivBytes));
        byte[] textBytes = Base64.decode((String)encodedStr, (int)2);
        return new String(cipher.doFinal(textBytes), DEFAULT_CHARSET);
    }

    private static Key createKeySpec(String key) throws UnsupportedEncodingException {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return null;
        }
        byte[] keyBytes = new byte[16];
        byte[] b = key.getBytes(DEFAULT_CHARSET);
        int length = b.length;
        if (length > keyBytes.length) {
            length = keyBytes.length;
        }
        System.arraycopy(b, 0, keyBytes, 0, length);
        return new SecretKeySpec(keyBytes, "AES");
    }
}

