/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.HashUtils;
import com.sendbird.android.MessageMetaArray;
import com.sendbird.android.SendBird;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public final class ScheduledUserMessage {
    private long mScheduledId;
    private String mScheduledDateTime;
    private String mScheduledTimezone;
    private String mStatus;
    private int mErrorCode;
    private String mErrorMessage;
    private String mPushOption;
    private String mChannelUrl;
    private String mChannelType;
    private long mCreatedAt;
    private long mUpdatedAt;
    private BaseMessageParams.MentionType mMentionType = BaseMessageParams.MentionType.USERS;
    private List<User> mMentionedUsers;
    private List<MessageMetaArray> mMetaArrays;
    private String mData = "";
    private String mCustomType = "";
    private String mMessage = "";
    private User mSender;
    private ArrayList<String> mTargetLanguages;

    ScheduledUserMessage(JsonElement el) {
        int i;
        JsonArray array;
        JsonObject obj = el.getAsJsonObject();
        this.mScheduledId = obj.has("scheduled_id") ? obj.get("scheduled_id").getAsLong() : 0L;
        this.mScheduledDateTime = obj.has("scheduled_dt") ? obj.get("scheduled_dt").getAsString() : "";
        this.mScheduledTimezone = obj.has("scheduled_timezone") ? obj.get("scheduled_timezone").getAsString() : "UTC";
        String string = this.mStatus = obj.has("status") ? obj.get("status").getAsString() : "";
        if (obj.has("error")) {
            JsonObject errorObj = obj.get("error").getAsJsonObject();
            this.mErrorCode = errorObj.has("code") ? errorObj.get("code").getAsInt() : 0;
            this.mErrorMessage = errorObj.has("message") ? errorObj.get("message").getAsString() : "";
        }
        this.mPushOption = obj.has("push_option") ? obj.get("push_option").getAsString() : "";
        this.mChannelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.mChannelType = obj.has("channel_type") ? obj.get("channel_type").getAsString() : "group";
        this.mCreatedAt = obj.has("created_at") ? obj.get("created_at").getAsLong() : 0L;
        long l = this.mUpdatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
        if (obj.has("mention_type")) {
            String mentionType = obj.get("mention_type").getAsString();
            if (mentionType.equals("users")) {
                this.mMentionType = BaseMessageParams.MentionType.USERS;
            } else if (mentionType.equals("channel")) {
                this.mMentionType = BaseMessageParams.MentionType.CHANNEL;
            }
        }
        this.mMentionedUsers = new ArrayList<User>();
        if (obj.has("mentioned_users")) {
            array = obj.getAsJsonArray("mentioned_users");
            for (i = 0; i < array.size(); ++i) {
                this.mMentionedUsers.add(new User(array.get(i)));
            }
        }
        this.mMetaArrays = new ArrayList<MessageMetaArray>();
        if (obj.has("metaarray")) {
            HashMap<String, MessageMetaArray> metaArrayMap = new HashMap<String, MessageMetaArray>();
            JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
            for (String key : metaArrayObj.keySet()) {
                if (key == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                JsonArray array2 = metaArrayObj.get(key).getAsJsonArray();
                for (int i2 = 0; i2 < array2.size(); ++i2) {
                    String value = array2.get(i2).getAsString();
                    values.add(value);
                }
                metaArrayMap.put(key, new MessageMetaArray(key, values));
            }
            if (obj.has("metaarray_key_order")) {
                JsonArray metaArrayKeyOrderArray = obj.getAsJsonArray("metaarray_key_order");
                for (int i3 = 0; i3 < metaArrayKeyOrderArray.size(); ++i3) {
                    String orderedKey = metaArrayKeyOrderArray.get(i3).getAsString();
                    if (!metaArrayMap.containsKey(orderedKey)) continue;
                    this.mMetaArrays.add((MessageMetaArray)metaArrayMap.get(orderedKey));
                }
            } else {
                this.mMetaArrays.addAll(metaArrayMap.values());
            }
        }
        this.mMessage = obj.get("message").getAsString();
        this.mData = obj.has("data") ? obj.get("data").getAsString() : "";
        this.mSender = new User(obj.get("user"));
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mTargetLanguages = new ArrayList();
        if (obj.has("translation_target_langs")) {
            array = obj.getAsJsonArray("translation_target_langs");
            for (i = 0; i < array.size(); ++i) {
                this.mTargetLanguages.add(array.get(i).getAsString());
            }
        }
    }

    public long getScheduledId() {
        return this.mScheduledId;
    }

    public Date getScheduledDateTime() {
        Date date = null;
        try {
            if (this.mScheduledDateTime != null && this.mScheduledDateTime.length() > 0 && this.mScheduledTimezone != null && this.mScheduledTimezone.length() > 0) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm", Locale.US);
                dateFormat.setTimeZone(TimeZone.getTimeZone(this.mScheduledTimezone));
                date = dateFormat.parse(this.mScheduledDateTime);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (date == null) {
            date = new Date();
        }
        return date;
    }

    public String getScheduledTimezone() {
        return this.mScheduledTimezone;
    }

    public Status getStatus() {
        Status status = Status.FAILED;
        if (this.mStatus != null) {
            if (this.mStatus.equals("scheduled")) {
                status = Status.SCHEDULED;
            } else if (this.mStatus.equals("sent")) {
                status = Status.SENT;
            } else if (this.mStatus.equals("canceled")) {
                status = Status.CANCELED;
            } else if (this.mStatus.equals("failed")) {
                status = Status.FAILED;
            }
        }
        return status;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public BaseMessageParams.PushNotificationDeliveryOption getPushNotificationDeliveryOption() {
        BaseMessageParams.PushNotificationDeliveryOption pushOption = BaseMessageParams.PushNotificationDeliveryOption.DEFAULT;
        if (this.mPushOption != null && this.mPushOption.equals("suppress")) {
            pushOption = BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS;
        }
        return pushOption;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public long getUpdatedAt() {
        return this.mUpdatedAt;
    }

    public BaseMessageParams.MentionType getMentionType() {
        return this.mMentionType;
    }

    public List<User> getMentionedUsers() {
        return this.mMentionedUsers;
    }

    List<String> getMentionedUserIds() {
        ArrayList<String> mentionedUserIds = null;
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            mentionedUserIds = new ArrayList<String>();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null || mentionedUser.getUserId() == null || mentionedUser.getUserId().length() <= 0) continue;
                mentionedUserIds.add(mentionedUser.getUserId());
            }
        }
        return mentionedUserIds;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public boolean isOpenChannel() {
        return this.mChannelType.equals("open");
    }

    public boolean isGroupChannel() {
        return this.mChannelType.equals("group");
    }

    public String getData() {
        return this.mData;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public Map<String, List<String>> getAllMetaArray() {
        HashMap<String, List<String>> metaArrayMap = new HashMap<String, List<String>>();
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            metaArrayMap.put(metaArray.getKey(), metaArray.getValue());
        }
        return metaArrayMap;
    }

    public List<MessageMetaArray> getAllMetaArrays() {
        return new ArrayList<MessageMetaArray>(this.mMetaArrays);
    }

    public Map<String, List<String>> getMetaArray(Collection<String> metaArrayKeys) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        List<MessageMetaArray> metaArrays = this.getMetaArrays(metaArrayKeys);
        for (MessageMetaArray metaArray : metaArrays) {
            resultMap.put(metaArray.getKey(), metaArray.getValue());
        }
        return resultMap;
    }

    public List<MessageMetaArray> getMetaArrays(Collection<String> metaArrayKeys) {
        ArrayList<MessageMetaArray> metaArrays = new ArrayList<MessageMetaArray>();
        if (this.mMetaArrays != null && metaArrayKeys != null && metaArrayKeys.size() > 0) {
            for (String key : metaArrayKeys) {
                MessageMetaArray metaArray = this.getMetaArrayByKey(key);
                if (metaArray == null) continue;
                metaArrays.add(metaArray);
            }
        }
        return metaArrays;
    }

    MessageMetaArray getMetaArrayByKey(String key) {
        if (key == null) {
            return null;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            return metaArray;
        }
        return null;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public User getSender() {
        if (this.mSender == null) {
            return null;
        }
        if (SendBird.Options.useMemberAsMessageSender && GroupChannel.sCachedChannels.containsKey(this.mChannelUrl)) {
            GroupChannel channel = GroupChannel.sCachedChannels.get(this.mChannelUrl);
            User member = channel.mMemberMap.get(this.mSender.getUserId());
            if (member != null) {
                this.mSender.updatePropertiesByUser(member);
            }
        }
        return this.mSender;
    }

    public ArrayList<String> getTranslationTargetLanguages() {
        return this.mTargetLanguages;
    }

    public String toString() {
        return "ScheduledUserMessage{mScheduledId=" + this.mScheduledId + ", mScheduledDateTime='" + this.mScheduledDateTime + '\'' + ", mScheduledTimezone='" + this.mScheduledTimezone + '\'' + ", mStatus='" + this.mStatus + '\'' + ", mErrorCode=" + this.mErrorCode + ", mErrorMessage='" + this.mErrorMessage + '\'' + ", mPushOption='" + this.mPushOption + '\'' + ", mChannelUrl='" + this.mChannelUrl + '\'' + ", mChannelType='" + this.mChannelType + '\'' + ", mCreatedAt=" + this.mCreatedAt + ", mUpdatedAt=" + this.mUpdatedAt + ", mMentionType=" + (Object)((Object)this.mMentionType) + ", mMentionedUsers=" + this.mMentionedUsers + ", mMetaArrays=" + this.mMetaArrays + ", mData='" + this.mData + '\'' + ", mCustomType='" + this.mCustomType + '\'' + ", mMessage='" + this.mMessage + '\'' + ", mSender=" + this.mSender + ", mTargetLanguages=" + this.mTargetLanguages + '}';
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ScheduledUserMessage scheduledUserMessage = (ScheduledUserMessage)o;
        return this.getScheduledId() == scheduledUserMessage.getScheduledId() && this.getChannelUrl().equals(scheduledUserMessage.getChannelUrl()) && this.getCreatedAt() == scheduledUserMessage.getCreatedAt();
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getScheduledId(), this.getChannelUrl(), this.getCreatedAt());
    }

    public static enum Status {
        SCHEDULED,
        SENT,
        CANCELED,
        FAILED;

    }
}

