/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.BaseMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserMessage
extends BaseMessage {
    private String mMessage = "";
    Sender mSender;
    private String mReqId;
    private HashMap<String, String> mTranslations;

    static JsonElement build(String requestId, BaseMessage.SendingStatus sendingStatus, long msgId, Sender sender, String channelUrl, String channelType, String message, String data, String customType, String translations, long createdAt, long updatedAt, BaseMessageParams.MentionType mentionType, List<String> mentionedUserIds, String mentionedUsers, String reactions, String metaArray, String metaArrayKeyOrder, String sortedMetaArray, boolean isGlobalBlocked, int errorCode, boolean isSilent, boolean forceUpdateLastMessage, int messageSurvivalSeconds) {
        JsonObject obj = new JsonObject();
        obj.addProperty("req_id", requestId);
        obj.addProperty("request_state", sendingStatus.getValue());
        obj.addProperty("msg_id", (Number)msgId);
        obj.addProperty("channel_url", channelUrl);
        obj.addProperty("channel_type", channelType);
        obj.addProperty("ts", (Number)createdAt);
        obj.addProperty("updated_at", (Number)updatedAt);
        obj.addProperty("message", message);
        if (data != null) {
            obj.addProperty("data", data);
        }
        if (customType != null) {
            obj.addProperty("custom_type", customType);
        }
        if (translations != null) {
            obj.add("translations", new JsonParser().parse(translations));
        }
        if (sender != null) {
            JsonObject userObj = sender.toJson().getAsJsonObject();
            obj.add("user", (JsonElement)userObj);
        }
        if (mentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
            JsonArray array = new JsonArray();
            for (String mentionedUserId : mentionedUserIds) {
                if (mentionedUserId == null || mentionedUserId.length() <= 0) continue;
                array.add(mentionedUserId);
            }
            obj.add("mentioned_user_ids", (JsonElement)array);
        }
        if (mentionedUsers != null) {
            obj.add("mentioned_users", new JsonParser().parse(mentionedUsers));
        }
        if (reactions != null) {
            obj.add("reactions", new JsonParser().parse(reactions));
        }
        if (metaArray != null) {
            obj.add("metaarray", new JsonParser().parse(metaArray));
        }
        if (metaArrayKeyOrder != null) {
            obj.add("metaarray_key_order", new JsonParser().parse(metaArrayKeyOrder));
        }
        if (sortedMetaArray != null) {
            obj.add("sorted_metaarray", new JsonParser().parse(sortedMetaArray));
        }
        obj.addProperty("is_global_block", Boolean.valueOf(isGlobalBlocked));
        obj.addProperty("error_code", (Number)errorCode);
        obj.addProperty("silent", Boolean.valueOf(isSilent));
        obj.addProperty("force_update_last_message", Boolean.valueOf(forceUpdateLastMessage));
        obj.addProperty("message_survival_seconds", (Number)messageSurvivalSeconds);
        return obj;
    }

    UserMessage(JsonElement el) {
        super(el);
        JsonObject obj = el.getAsJsonObject();
        this.mMessage = obj.get("message").getAsString();
        this.mData = obj.has("data") ? obj.get("data").getAsString() : "";
        this.mSender = obj.has("user") && !obj.get("user").isJsonNull() ? new Sender(obj.get("user")) : null;
        this.mReqId = "";
        if (obj.has("request_id")) {
            this.mReqId = obj.get("request_id").getAsString();
        }
        if (obj.has("req_id")) {
            this.mReqId = obj.get("req_id").getAsString();
        }
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : "";
        this.mTranslations = new HashMap();
        if (obj.has("translations")) {
            JsonObject transObj = obj.get("translations").getAsJsonObject();
            for (Map.Entry entry : transObj.entrySet()) {
                this.mTranslations.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
        }
        this.mErrorCode = obj.has("error_code") ? obj.get("error_code").getAsInt() : 0;
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("type", "MESG");
        obj.addProperty("req_id", this.mReqId);
        obj.addProperty("message", this.mMessage);
        obj.addProperty("data", this.mData);
        obj.addProperty("custom_type", this.mCustomType);
        obj.add("user", this.mSender != null ? this.mSender.toJson() : null);
        JsonObject transObj = new JsonObject();
        for (Map.Entry<String, String> entry : this.mTranslations.entrySet()) {
            transObj.addProperty(entry.getKey(), entry.getValue());
        }
        obj.add("translations", (JsonElement)transObj);
        obj.addProperty("error_code", (Number)this.mErrorCode);
        return obj;
    }

    @Override
    public String getMessage() {
        return this.mMessage;
    }

    @Override
    public Sender getSender() {
        if (this.mSender == null) {
            return null;
        }
        if (SendBird.Options.useMemberAsMessageSender && GroupChannel.sCachedChannels.containsKey(this.mChannelUrl)) {
            GroupChannel channel = GroupChannel.sCachedChannels.get(this.mChannelUrl);
            User member = channel.mMemberMap.get(this.mSender.getUserId());
            if (member != null) {
                this.mSender.updatePropertiesByUser(member);
            }
        }
        return this.mSender;
    }

    @Override
    public String getRequestId() {
        return this.mReqId;
    }

    public Map<String, String> getTranslations() {
        return this.mTranslations;
    }

    @Deprecated
    public RequestState getRequestState() {
        if (this.getSendingStatus() == BaseMessage.SendingStatus.SUCCEEDED) {
            return RequestState.SUCCEEDED;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.FAILED) {
            return RequestState.FAILED;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.PENDING) {
            return RequestState.PENDING;
        }
        if (this.getSendingStatus() == BaseMessage.SendingStatus.CANCELED) {
            return RequestState.FAILED;
        }
        return RequestState.NONE;
    }

    public List<String> getRequestedMentionUserIds() {
        if (this.getSendingStatus() == BaseMessage.SendingStatus.PENDING || this.getSendingStatus() == BaseMessage.SendingStatus.FAILED || this.getSendingStatus() == BaseMessage.SendingStatus.CANCELED) {
            return this.getMentionedUserIds();
        }
        return new ArrayList<String>();
    }

    @Override
    public String toString() {
        return super.toString() + "\nUserMessage{mMessage='" + this.mMessage + '\'' + ", mSender=" + this.mSender + ", mReqId='" + this.mReqId + '\'' + ", mTranslations=" + this.mTranslations + '}';
    }

    @Deprecated
    public static enum RequestState {
        NONE,
        PENDING,
        FAILED,
        SUCCEEDED;

    }
}

