/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class TimeoutScheduler {
    private long timeout;
    private final long initialDelay;
    private final TimeoutEventhandler handler;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final AtomicBoolean repeat = new AtomicBoolean(false);
    private ScheduledExecutorService scheduler;
    private Object extra;

    TimeoutScheduler(long timeout, TimeoutEventhandler handler) {
        this(0L, timeout, false, handler, null);
    }

    TimeoutScheduler(long timeout, TimeoutEventhandler handler, Object extra) {
        this(0L, timeout, false, handler, extra);
    }

    TimeoutScheduler(long timeout, boolean repeat, TimeoutEventhandler handler, Object extra) {
        this(0L, timeout, repeat, handler, extra);
    }

    TimeoutScheduler(long initialDelay, long timeout, boolean repeat, TimeoutEventhandler handler, Object extra) {
        if (handler == null) {
            throw new NullPointerException("callback must Non null");
        }
        this.initialDelay = initialDelay;
        this.timeout = timeout;
        this.repeat.set(repeat);
        this.handler = handler;
        this.extra = extra;
    }

    void setExtra(Object extra) {
        this.extra = extra;
    }

    void restart() {
        this.restart(this.timeout);
    }

    void restart(long newTimeout) {
        this.timeout = newTimeout;
        if (this.isRunning.get()) {
            this.stop();
        }
        this.start();
    }

    synchronized void stop() {
        if (this.isRunning.getAndSet(false) && this.isEnabled()) {
            this.scheduler.shutdown();
        }
    }

    synchronized void start() {
        if (this.isRunning.get()) {
            return;
        }
        if (!this.isEnabled()) {
            this.scheduler = Executors.newSingleThreadScheduledExecutor();
        }
        this.scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                TimeoutScheduler.this.handler.onTimeout(TimeoutScheduler.this.extra);
                if (!TimeoutScheduler.this.repeat.get()) {
                    TimeoutScheduler.this.stop();
                }
            }
        }, this.initialDelay, this.timeout, TimeUnit.MILLISECONDS);
        this.isRunning.compareAndSet(false, true);
    }

    private boolean isEnabled() {
        return this.scheduler != null && !this.scheduler.isShutdown() && !this.scheduler.isTerminated();
    }

    boolean isRunning() {
        return this.isRunning.get();
    }

    static interface TimeoutEventhandler {
        public void onTimeout(Object var1);
    }
}

