/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.BannedUserListQuery;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.Command;
import com.sendbird.android.MutedUserListQuery;
import com.sendbird.android.OpenChannelListQuery;
import com.sendbird.android.ParticipantListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public final class OpenChannel
extends BaseChannel {
    private static final ConcurrentHashMap<String, OpenChannel> sCachedChannels = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, OpenChannel> sEnteredChannels = new ConcurrentHashMap();
    protected int mParticipantCount;
    protected List<User> mOperators;
    private String mCustomType;

    static synchronized void clearCache() {
        sCachedChannels.clear();
    }

    protected static void clearEnteredChannels() {
        sEnteredChannels.clear();
    }

    static synchronized void removeChannelFromCache(String channelUrl) {
        sCachedChannels.remove(channelUrl);
    }

    static synchronized void removeChannelFromEntered(String channelUrl) {
        sEnteredChannels.remove(channelUrl);
    }

    protected static Collection<OpenChannel> getEnteredChannels() {
        return sEnteredChannels.values();
    }

    static boolean isEnteredChannel(String channelUrl) {
        return sEnteredChannels.get(channelUrl) != null;
    }

    public void refresh(final OpenChannelRefreshHandler handler) {
        OpenChannel.getChannelWithoutCache(this.getUrl(), new OpenChannelGetHandler(){

            @Override
            public void onResult(OpenChannel channel, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    protected static synchronized OpenChannel upsert(JsonElement el, boolean dirty) {
        String channelUrl = el.getAsJsonObject().get("channel_url").getAsString();
        if (sCachedChannels.containsKey(channelUrl)) {
            OpenChannel channel = sCachedChannels.get(channelUrl);
            if (!dirty || channel.isDirty()) {
                channel.update(el);
                channel.setDirty(dirty);
            }
        } else {
            sCachedChannels.put(channelUrl, new OpenChannel(el));
        }
        return sCachedChannels.get(channelUrl);
    }

    protected static synchronized void setDirtyToAllCachedChannels(boolean dirty) {
        if (sCachedChannels != null) {
            for (OpenChannel channel : sCachedChannels.values()) {
                channel.setDirty(dirty);
            }
        }
    }

    protected OpenChannel(JsonElement el) {
        super(el);
    }

    @Override
    protected void update(JsonElement el) {
        super.update(el);
        this.parse(el);
    }

    private void parse(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("participant_count")) {
            this.mParticipantCount = obj.get("participant_count").getAsInt();
        }
        if (obj.has("operators") && obj.get("operators").isJsonArray()) {
            this.mOperators = new ArrayList<User>();
            JsonArray ops = obj.get("operators").getAsJsonArray();
            for (int i = 0; i < ops.size(); ++i) {
                this.mOperators.add(new User(ops.get(i)));
            }
        }
        if (obj.has("custom_type")) {
            this.mCustomType = obj.get("custom_type").getAsString();
        }
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("channel_type", "open");
        obj.addProperty("participant_count", (Number)this.mParticipantCount);
        if (this.mCustomType != null) {
            obj.addProperty("custom_type", this.mCustomType);
        }
        if (this.mOperators != null) {
            JsonArray opsObj = new JsonArray();
            for (User operator : this.mOperators) {
                opsObj.add(operator.toJson());
            }
            obj.add("operators", (JsonElement)opsObj);
        }
        return obj;
    }

    public int getParticipantCount() {
        return this.mParticipantCount;
    }

    protected void setParticipantCount(int count) {
        this.mParticipantCount = count;
    }

    public List<User> getOperators() {
        return this.mOperators;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public static OpenChannelListQuery createOpenChannelListQuery() {
        return new OpenChannelListQuery();
    }

    public static void createChannel(OpenChannelCreateHandler handler) {
        OpenChannel.createChannelWithOperatorUserIds(null, null, null, null, handler);
    }

    @Deprecated
    public static void createChannel(String name, Object coverUrlOrImage, String data, OpenChannelCreateHandler handler) throws ClassCastException {
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, handler);
    }

    @Deprecated
    public static void createChannel(String name, Object coverUrlOrImage, String data, List<User> operatorUsers, OpenChannelCreateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, operatorUserIds, handler);
    }

    public static void createChannel(String name, Object coverUrlOrImage, String data, String customType, List<User> operatorUsers, OpenChannelCreateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, customType, operatorUserIds, handler);
    }

    public static void createChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, List<String> operatorUserIds, OpenChannelCreateHandler handler) throws ClassCastException {
        OpenChannel.createChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, operatorUserIds, handler);
    }

    public static void createChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, String customType, List<String> operatorUserIds, final OpenChannelCreateHandler handler) throws ClassCastException {
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException();
        }
        APIClient.APIClientHandler apiClientHandler = new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final OpenChannel channel = OpenChannel.upsert(response, false);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channel, null);
                        }
                    });
                }
            }
        };
        if (coverUrlOrImage instanceof String || coverUrlOrImage == null) {
            APIClient.getInstance().createOpenChannel(name, null, (String)coverUrlOrImage, data, customType, operatorUserIds, apiClientHandler);
        } else {
            APIClient.getInstance().createOpenChannel(name, null, (File)coverUrlOrImage, data, customType, operatorUserIds, apiClientHandler);
        }
    }

    public static void createChannelWithOperatorUserIds(String name, String channelUrl, Object coverUrlOrImage, String data, String customType, List<String> operatorUserIds, final OpenChannelCreateHandler handler) throws ClassCastException {
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException();
        }
        APIClient.APIClientHandler apiClientHandler = new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final OpenChannel channel = OpenChannel.upsert(response, false);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channel, null);
                        }
                    });
                }
            }
        };
        if (coverUrlOrImage instanceof String || coverUrlOrImage == null) {
            APIClient.getInstance().createOpenChannel(name, channelUrl, (String)coverUrlOrImage, data, customType, operatorUserIds, apiClientHandler);
        } else {
            APIClient.getInstance().createOpenChannel(name, channelUrl, (File)coverUrlOrImage, data, customType, operatorUserIds, apiClientHandler);
        }
    }

    protected static void getChannelWithoutCache(final String channelUrl, final OpenChannelGetHandler handler) {
        APIClient.getInstance().getOpenChannel(channelUrl, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                OpenChannel.upsert(response, false);
                if (handler != null) {
                    handler.onResult((OpenChannel)sCachedChannels.get(channelUrl), null);
                }
            }
        });
    }

    public static void getChannel(final String channelUrl, final OpenChannelGetHandler handler) {
        if (channelUrl == null || channelUrl.length() == 0) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (sCachedChannels.containsKey(channelUrl) && !sCachedChannels.get(channelUrl).isDirty()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        OpenChannel channel = (OpenChannel)sCachedChannels.get(channelUrl);
                        if (channel == null) {
                            return;
                        }
                        handler.onResult(channel, null);
                    }
                });
            }
        } else {
            OpenChannel.getChannelWithoutCache(channelUrl, new OpenChannelGetHandler(){

                @Override
                public void onResult(final OpenChannel channel, final SendBirdException e) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(channel, e);
                            }
                        });
                    }
                }
            });
        }
    }

    public void delete(final OpenChannelDeleteHandler handler) {
        final String channelUrl = this.getUrl();
        APIClient.getInstance().deleteChannel(true, channelUrl, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(e);
                    }
                    return;
                }
                OpenChannel.removeChannelFromEntered(channelUrl);
                OpenChannel.removeChannelFromCache(channelUrl);
                if (handler != null) {
                    handler.onResult(null);
                }
            }
        });
    }

    public void updateChannel(String name, Object coverUrlOrImage, String data, OpenChannelUpdateHandler handler) throws ClassCastException {
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, handler);
    }

    @Deprecated
    public void updateChannel(String name, Object coverUrlOrImage, String data, List<User> operatorUsers, OpenChannelUpdateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, operatorUserIds, handler);
    }

    public void updateChannel(String name, Object coverUrlOrImage, String data, String customType, List<User> operatorUsers, OpenChannelUpdateHandler handler) throws ClassCastException {
        ArrayList<String> operatorUserIds = new ArrayList<String>();
        if (operatorUsers != null) {
            for (User user : operatorUsers) {
                if (user == null) continue;
                operatorUserIds.add(user.getUserId());
            }
        }
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, customType, operatorUserIds, handler);
    }

    public void updateChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, List<String> operatorUserIds, OpenChannelUpdateHandler handler) throws ClassCastException {
        this.updateChannelWithOperatorUserIds(name, coverUrlOrImage, data, null, operatorUserIds, handler);
    }

    public void updateChannelWithOperatorUserIds(String name, Object coverUrlOrImage, String data, String customType, List<String> operatorUserIds, final OpenChannelUpdateHandler handler) throws ClassCastException {
        if (!(coverUrlOrImage instanceof String) && !(coverUrlOrImage instanceof File) && coverUrlOrImage != null) {
            throw new ClassCastException();
        }
        APIClient.APIClientHandler apiClientHandler = new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final OpenChannel channel = OpenChannel.upsert(response, false);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channel, null);
                        }
                    });
                }
            }
        };
        if (coverUrlOrImage instanceof String || coverUrlOrImage == null) {
            APIClient.getInstance().updateOpenChannel(this.getUrl(), name, (String)coverUrlOrImage, data, customType, operatorUserIds, apiClientHandler);
        } else {
            APIClient.getInstance().updateOpenChannel(this.getUrl(), name, (File)coverUrlOrImage, data, customType, operatorUserIds, apiClientHandler);
        }
    }

    public void enter(OpenChannelEnterHandler handler) {
        this.enter(true, handler);
    }

    void enter(boolean lazy, final OpenChannelEnterHandler handler) {
        Command cmd = Command.bEnter(this.getUrl());
        SendBird.getInstance().sendCommand(cmd, lazy, new Command.SendCommandHandler(){

            @Override
            public void onResult(Command acked, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                sEnteredChannels.put(OpenChannel.this.getUrl(), OpenChannel.this);
                OpenChannel.this.refresh(new OpenChannelRefreshHandler(){

                    @Override
                    public void onResult(SendBirdException e) {
                        if (handler != null) {
                            handler.onResult(null);
                        }
                    }
                });
            }
        });
    }

    public void exit(final OpenChannelExitHandler handler) {
        Command cmd = Command.bExit(this.getUrl());
        SendBird.getInstance().sendCommand(cmd, true, new Command.SendCommandHandler(){

            @Override
            public void onResult(Command acked, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                sEnteredChannels.remove(OpenChannel.this.getUrl());
                JsonObject obj = acked.getJsonElement().getAsJsonObject();
                if (obj.has("participant_count")) {
                    OpenChannel.this.setParticipantCount(obj.get("participant_count").getAsInt());
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public ParticipantListQuery createParticipantListQuery() {
        return new ParticipantListQuery(this);
    }

    public MutedUserListQuery createMutedUserListQuery() {
        return new MutedUserListQuery(this);
    }

    public BannedUserListQuery createBannedUserListQuery() {
        return new BannedUserListQuery(this);
    }

    public void banUser(User user, int seconds, final OpenChannelBanHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.banUserWithUserId(user.getUserId(), seconds, handler);
    }

    public void banUserWithUserId(String userId, int seconds, final OpenChannelBanHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().banUser(true, this.getUrl(), userId, null, seconds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void unbanUser(User user, final OpenChannelUnbanHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.unbanUserWithUserId(user.getUserId(), handler);
    }

    public void unbanUserWithUserId(String userId, final OpenChannelUnbanHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unbanUser(true, this.getUrl(), userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void muteUser(User user, final OpenChannelMuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.localMuteUserWithUserId(user.getUserId(), null, null, handler);
    }

    public void muteUserWithUserId(String userId, OpenChannelMuteHandler handler) {
        this.localMuteUserWithUserId(userId, null, null, handler);
    }

    public void muteUser(User user, String description, int seconds, final OpenChannelMuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.localMuteUserWithUserId(user.getUserId(), description, seconds, handler);
    }

    public void muteUserWithUserId(String userId, String description, int seconds, OpenChannelMuteHandler handler) {
        this.localMuteUserWithUserId(userId, description, seconds, handler);
    }

    private void localMuteUserWithUserId(String userId, String description, Integer seconds, final OpenChannelMuteHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().muteUser(true, this.getUrl(), userId, description, seconds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void unmuteUser(User user, final OpenChannelUnmuteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        this.unmuteUserWithUserId(user.getUserId(), handler);
    }

    public void unmuteUserWithUserId(String userId, final OpenChannelUnmuteHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unmuteUser(true, this.getUrl(), userId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public boolean isOperator(User user) {
        if (user == null) {
            return false;
        }
        return this.isOperatorWithUserId(user.getUserId());
    }

    public boolean isOperatorWithUserId(String userId) {
        boolean result = false;
        for (User operator : this.mOperators) {
            if (!operator.getUserId().equals(userId)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String toString() {
        return super.toString() + "\nOpenChannel{mParticipantCount=" + this.mParticipantCount + ", mOperators=" + this.mOperators + ", mCustomType='" + this.mCustomType + '\'' + '}';
    }

    public static interface OpenChannelDeleteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelUnmuteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelMuteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelUnbanHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelBanHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelUpdateHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelCreateHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelGetHandler {
        public void onResult(OpenChannel var1, SendBirdException var2);
    }

    public static interface OpenChannelExitHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelEnterHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface OpenChannelRefreshHandler {
        public void onResult(SendBirdException var1);
    }
}

