/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class MessageMetaArray {
    private String mKey;
    private List<String> mValue;

    public MessageMetaArray(String key) {
        this.mKey = key;
        this.mValue = new ArrayList<String>();
    }

    public MessageMetaArray(String key, List<String> value) {
        this.mKey = key;
        this.mValue = new ArrayList<String>(new LinkedHashSet<String>(value));
    }

    public String getKey() {
        return this.mKey;
    }

    public List<String> getValue() {
        return new ArrayList<String>(this.mValue);
    }

    public synchronized void addValue(String value) {
        if (!this.mValue.contains(value)) {
            this.mValue.add(value);
        }
    }

    public void addValue(List<String> value) {
        for (String v : value) {
            this.addValue(v);
        }
    }

    public synchronized void removeValue(String value) {
        this.mValue.remove(value);
    }

    void setValue(List<String> value) {
        this.mValue = value;
    }

    JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("key", this.mKey);
        JsonArray valueArray = new JsonArray();
        for (String value : this.mValue) {
            valueArray.add(value);
        }
        obj.add("value", (JsonElement)valueArray);
        return obj;
    }
}

