/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.content.Context;
import android.text.TextUtils;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.ConnectionManager;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.GroupChannelMemberListQuery;
import com.sendbird.android.GroupChannelTotalUnreadMessageCountParams;
import com.sendbird.android.KeyStore;
import com.sendbird.android.MessageMetaArray;
import com.sendbird.android.PublicGroupChannelListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.Gson;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonNull;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import com.sendbird.android.shadow.okhttp3.Call;
import com.sendbird.android.shadow.okhttp3.Callback;
import com.sendbird.android.shadow.okhttp3.Headers;
import com.sendbird.android.shadow.okhttp3.MediaType;
import com.sendbird.android.shadow.okhttp3.OkHttpClient;
import com.sendbird.android.shadow.okhttp3.Request;
import com.sendbird.android.shadow.okhttp3.RequestBody;
import com.sendbird.android.shadow.okhttp3.Response;
import com.sendbird.android.shadow.okhttp3.internal.Util;
import com.sendbird.android.shadow.okio.Buffer;
import com.sendbird.android.shadow.okio.BufferedSink;
import com.sendbird.android.shadow.okio.ByteString;
import com.sendbird.android.shadow.okio.ForwardingSink;
import com.sendbird.android.shadow.okio.Okio;
import com.sendbird.android.shadow.okio.Sink;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

class APIClient {
    private static final Gson sGson = new Gson();
    private static final String ROUTING_URL = "https://api-p.sendbird.com/routing/%s";
    private static final String API_USERS = "/v3/users";
    private static final String API_USERS_USERID_LOGIN = "/v3/users/%s/login";
    private static final String API_USERS_USERID = "/v3/users/%s";
    private static final String API_USERS_USERID_UNREADCOUNT = "/v3/users/%s/unread_count";
    private static final String API_USERS_USERID_UNREADMESSAGECOUNT = "/v3/users/%s/unread_message_count";
    private static final String API_USERS_USERID_UNREADITEMCOUNT = "/v3/users/%s/unread_item_count";
    private static final String API_USERS_USERID_UNREADCHANNELCOUNT = "/v3/users/%s/unread_channel_count";
    private static final String API_USERS_USERID_GROUPCHANNELCOUNT = "/v3/users/%s/group_channel_count";
    private static final String API_USERS_USERID_MARKASREADALL = "/v3/users/%s/mark_as_read_all";
    private static final String API_USERS_USERID_PUSH_GCM_TOKEN = "/v3/users/%s/push/gcm/%s";
    private static final String API_USERS_USERID_PUSH_GCM = "/v3/users/%s/push/gcm";
    private static final String API_USERS_USERID_PUSH_TOKENTYPE_DEVICETOKENS = "/v3/users/%s/push/%s/device_tokens";
    private static final String API_USERS_USERID_PUSH = "/v3/users/%s/push";
    private static final String API_USERS_USERID_PUSH_TEMPLATE = "/v3/users/%s/push/template";
    private static final String API_USERS_USERID_PUSHPREFERENCE_CHANNELURL = "/v3/users/%s/push_preference/%s";
    private static final String API_USERS_USERID_PUSHPREFERENCE = "/v3/users/%s/push_preference/";
    private static final String API_USERS_USERID_COUNTPREFERENCE_CHANNELURL = "/v3/users/%s/count_preference/%s";
    private static final String API_USERS_USERID_BLOCK = "/v3/users/%s/block";
    private static final String API_USERS_USERID_BLOCK_TARGETID = "/v3/users/%s/block/%s";
    private static final String API_USERS_USERID_FRIENDS = "/v3/users/%s/friends";
    private static final String API_USERS_USERID_FRIENDS_USERID = "/v3/users/%s/friends/%s";
    private static final String API_USERS_USERID_FRIENDDISCOVERIES = "/v3/users/%s/friend_discoveries";
    private static final String API_USERS_USERID_FRIENDDISCOVERIES_DISCOVERYKEY = "/v3/users/%s/friend_discoveries/%s";
    private static final String API_USERS_USERID_FRIENDS_CHANGELOGS = "/v3/users/%s/friends/changelogs";
    private static final String API_USERS_USERID_MYGROUPCHANNELS_CHANGELOGS = "/v3/users/%s/my_group_channels/changelogs";
    private static final String API_USERS_USERID_MYGROUPCHANNELS = "/v3/users/%s/my_group_channels";
    private static final String API_USERS_USERID_MYGROUPCHANNELS_CHANNELURL_MEMBERS = "/v3/users/%s/my_group_channels/%s/members";
    private static final String API_USERS_USERID_CHANNELINVITATIONPREFERENCE = "/v3/users/%s/channel_invitation_preference";
    private static final String API_USERS_USERID_METADATA = "/v3/users/%s/metadata";
    private static final String API_USERS_USERID_METADATA_KEY = "/v3/users/%s/metadata/%s";
    private static final String API_OPENCHANNELS = "/v3/open_channels";
    private static final String API_OPENCHANNELS_CHANNELURL = "/v3/open_channels/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES = "/v3/open_channels/%s/messages";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_TRANSLATION = "/v3/open_channels/%s/messages/%s/translation";
    private static final String API_OPENCHANNELS_CHANNELURL_SCHEDULED_MESSAGES = "/v3/open_channels/%s/scheduled_messages";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS = "/v3/open_channels/%s/messages/changelogs";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID = "/v3/open_channels/%s/messages/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_METAARRAY = "/v3/open_channels/%s/messages/%s/metaarray";
    private static final String API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS = "/v3/open_channels/%s/messages/%s/reactions";
    private static final String API_OPENCHANNELS_CHANNELURL_PARTICIPANTS = "/v3/open_channels/%s/participants";
    private static final String API_OPENCHANNELS_CHANNELURL_METADATA = "/v3/open_channels/%s/metadata";
    private static final String API_OPENCHANNELS_CHANNELURL_METADATA_KEY = "/v3/open_channels/%s/metadata/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_METACOUNTER = "/v3/open_channels/%s/metacounter";
    private static final String API_OPENCHANNELS_CHANNELURL_METACOUNTER_KEY = "/v3/open_channels/%s/metacounter/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_BAN = "/v3/open_channels/%s/ban";
    private static final String API_OPENCHANNELS_CHANNELURL_BAN_USERID = "/v3/open_channels/%s/ban/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_MUTE = "/v3/open_channels/%s/mute";
    private static final String API_OPENCHANNELS_CHANNELURL_MUTE_USERID = "/v3/open_channels/%s/mute/%s";
    private static final String API_OPENCHANNELS_CHANNELURL_OPERATORS = "/v3/open_channels/%s/operators";
    private static final String API_GROUPCHANNELS = "/v3/group_channels";
    private static final String API_GROUPCHANNELS_CHANNELURL = "/v3/group_channels/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_INVITE = "/v3/group_channels/%s/invite";
    private static final String API_GROUPCHANNELS_CHANNELURL_JOIN = "/v3/group_channels/%s/join";
    private static final String API_GROUPCHANNELS_CHANNELURL_HIDE = "/v3/group_channels/%s/hide";
    private static final String API_GROUPCHANNELS_CHANNELURL_LEAVE = "/v3/group_channels/%s/leave";
    private static final String API_GROUPCHANNELS_CHANNELURL_ACCEPT = "/v3/group_channels/%s/accept";
    private static final String API_GROUPCHANNELS_CHANNELURL_DECLINE = "/v3/group_channels/%s/decline";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES = "/v3/group_channels/%s/messages";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_TRANSLATION = "/v3/group_channels/%s/messages/%s/translation";
    private static final String API_GROUPCHANNELS_CHANNELURL_SCHEDULED_MESSAGES = "/v3/group_channels/%s/scheduled_messages";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS = "/v3/group_channels/%s/messages/changelogs";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASREAD = "/v3/group_channels/%s/messages/mark_as_read";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASDELIVERED = "/v3/group_channels/%s/messages/mark_as_delivered";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_TOTALCOUNT = "/v3/group_channels/%s/messages/total_count";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_UNREADCOUNT = "/v3/group_channels/%s/messages/unread_count";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID = "/v3/group_channels/%s/messages/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_METAARRAY = "/v3/group_channels/%s/messages/%s/metaarray";
    private static final String API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS = "/v3/group_channels/%s/messages/%s/reactions";
    private static final String API_GROUPCHANNELS_CHANNELURL_MEMBERS = "/v3/group_channels/%s/members";
    private static final String API_GROUPCHANNELS_CHANNELURL_METADATA = "/v3/group_channels/%s/metadata";
    private static final String API_GROUPCHANNELS_CHANNELURL_METADATA_KEY = "/v3/group_channels/%s/metadata/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_METACOUNTER = "/v3/group_channels/%s/metacounter";
    private static final String API_GROUPCHANNELS_CHANNELURL_METACOUNTER_KEY = "/v3/group_channels/%s/metacounter/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_RESETUSERHISTORY = "/v3/group_channels/%s/reset_user_history";
    private static final String API_GROUPCHANNELS_CHANNELURL_BAN = "/v3/group_channels/%s/ban";
    private static final String API_GROUPCHANNELS_CHANNELURL_BAN_USERID = "/v3/group_channels/%s/ban/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_MUTE = "/v3/group_channels/%s/mute";
    private static final String API_GROUPCHANNELS_CHANNELURL_MUTE_USERID = "/v3/group_channels/%s/mute/%s";
    private static final String API_GROUPCHANNELS_CHANNELURL_FREEZE = "/v3/group_channels/%s/freeze";
    private static final String API_GROUPCHANNELS_CHANNELURL_OPERATORS = "/v3/group_channels/%s/operators";
    private static final String API_STORAGE_FILE = "/v3/storage/file";
    private static final String API_STORAGE_PROFILEIMAGE = "/v3/storage/profile_image";
    private static final String API_REPORT_OPENCHANNELS_CHANNELURL = "/v3/report/open_channels/%s";
    private static final String API_REPORT_GROUPCHANNELS_CHANNELURL = "/v3/report/group_channels/%s";
    private static final String API_REPORT_USERS_OFFENDINGUSERID = "/v3/report/users/%s";
    private static final String API_REPORT_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID = "/v3/report/open_channels/%s/messages/%s";
    private static final String API_REPORT_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID = "/v3/report/group_channels/%s/messages/%s";
    private static final String API_SEARCH_MESSAGES = "/v3/search/messages";
    private static final MediaType MIME_JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private static APIClient sInstance;
    private String mSessionKey = "";
    private String mEKey = "";
    private OkHttpClient mOkHttpClient = new OkHttpClient();
    private OkHttpClient mOkHttpClientLong = new OkHttpClient.Builder().writeTimeout(60000L, TimeUnit.MILLISECONDS).build();
    private ConcurrentHashMap<String, Call> mOngoingRequestsMap;
    private final Object mOngoingRequestsLock = new Object();
    static final int UPDATE_META_COUNTER_MODE_SET = 0;
    static final int UPDATE_META_COUNTER_MODE_INC = 1;
    static final int UPDATE_META_COUNTER_MODE_DEC = 2;

    static synchronized APIClient getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    static synchronized void init(Context context) {
        if (sInstance == null) {
            sInstance = new APIClient();
            KeyStore.init(context.getApplicationContext());
        }
    }

    void clearKeys() {
        APIClient.getInstance().setSessionKey("");
        APIClient.getInstance().setEKey("");
        KeyStore.clearAll();
    }

    protected APIClient() {
        this.mOngoingRequestsMap = new ConcurrentHashMap();
    }

    void evictAllConnections() {
        Logger.d("Evict all connections.");
        try {
            new Thread(){

                @Override
                public void run() {
                    APIClient.this.mOkHttpClient.connectionPool().evictAll();
                    APIClient.this.mOkHttpClientLong.connectionPool().evictAll();
                }
            }.start();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cancelAllRequests() {
        Logger.d("Cancel all API calls.");
        this.mOkHttpClient.dispatcher().cancelAll();
        this.mOkHttpClientLong.dispatcher().cancelAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelRequest(String requestId) {
        Object object = this.mOngoingRequestsLock;
        synchronized (object) {
            if (this.mOngoingRequestsMap.containsKey(requestId)) {
                this.mOngoingRequestsMap.get(requestId).cancel();
                this.mOngoingRequestsMap.remove(requestId);
                return true;
            }
        }
        return false;
    }

    void groupChannelInvite(final String channelUrl, final List<String> userIds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_INVITE, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                JsonArray userIdsObj = new JsonArray();
                for (String userId : userIds) {
                    userIdsObj.add(userId);
                }
                form.add("user_ids", (JsonElement)userIdsObj);
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelJoin(final String channelUrl, final String accessCode, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_JOIN, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                if (accessCode != null) {
                    form.addProperty("access_code", accessCode);
                }
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelHide(final String channelUrl, final boolean hidePreviousMessages, final boolean allowAutoUnhide, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_HIDE, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                form.addProperty("hide_previous_messages", Boolean.valueOf(hidePreviousMessages));
                form.addProperty("allow_auto_unhide", Boolean.valueOf(allowAutoUnhide));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelUnhide(final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_HIDE, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelLeave(final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_LEAVE, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelAcceptInvitation(final String channelUrl, final String accessCode, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_ACCEPT, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                if (accessCode != null) {
                    form.addProperty("access_code", accessCode);
                }
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelDeclineInvitation(final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_DECLINE, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelMarkAsDelivered(final String channelUrl, final long msgId, final long ts, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASDELIVERED, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                if (msgId > 0L) {
                    form.addProperty("msg_id", (Number)msgId);
                }
                if (ts > 0L) {
                    form.addProperty("ts", (Number)ts);
                }
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelMarkAsRead(final String channelUrl, final long ts, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES_MARKASREAD, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                form.addProperty("ts", (Number)ts);
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelMarkAsReadAll(final List<String> channelUrls, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_MARKASREADALL, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                if (channelUrls != null) {
                    JsonArray channelUrlsArray = new JsonArray();
                    for (String channelUrl : channelUrls) {
                        channelUrlsArray.add(channelUrl);
                    }
                    form.add("channel_urls", (JsonElement)channelUrlsArray);
                }
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void groupChannelResetMyHistory(final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_RESETUSERHISTORY, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void sendFileMessage(final boolean isOpenChannel, final String channelUrl, final String fileUrl, final String fileName, final int fileSize, final String fileType, final String customType, final String data, final String thumbnails, final boolean requireAuth, final BaseMessageParams.MentionType mentionType, final List<String> mentionedUserIds, final BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, final List<MessageMetaArray> metaArrays, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                JsonArray array;
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("message_type", "FILE");
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                form.addProperty("url", fileUrl);
                if (fileName != null) {
                    form.addProperty("file_name", fileName);
                }
                if (fileSize > 0) {
                    form.addProperty("file_size", (Number)fileSize);
                }
                if (fileType != null) {
                    form.addProperty("file_type", fileType);
                }
                if (customType != null) {
                    form.addProperty("custom_type", customType);
                }
                if (data != null) {
                    form.addProperty("custom_field", data);
                }
                if (thumbnails != null) {
                    form.add("thumbnails", new JsonParser().parse(thumbnails));
                }
                if (requireAuth) {
                    form.addProperty("require_auth", Boolean.valueOf(true));
                }
                if (mentionType == BaseMessageParams.MentionType.USERS) {
                    form.addProperty("mention_type", "users");
                    if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                        array = new JsonArray();
                        for (String mentionedUserId : mentionedUserIds) {
                            array.add(mentionedUserId);
                        }
                        form.add("mentioned_user_ids", (JsonElement)array);
                    }
                } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
                    form.addProperty("mention_type", "channel");
                }
                if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                    array = new JsonArray();
                    for (String mentionedUserId : mentionedUserIds) {
                        array.add(mentionedUserId);
                    }
                    form.add("mentioned_user_ids", (JsonElement)array);
                }
                if (pushNotificationDeliveryOption != null && pushNotificationDeliveryOption == BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS) {
                    form.addProperty("push_option", "suppress");
                }
                if (metaArrays != null && metaArrays.size() > 0) {
                    JsonObject metaArrayObj = new JsonObject();
                    JsonArray metaArrayKeyOrderArray = new JsonArray();
                    for (MessageMetaArray metaArray : metaArrays) {
                        String key = metaArray.getKey();
                        List<String> values = metaArray.getValue();
                        if (key == null) continue;
                        JsonArray array2 = new JsonArray();
                        for (String value : values) {
                            array2.add(value);
                        }
                        metaArrayObj.add(key, (JsonElement)array2);
                        metaArrayKeyOrderArray.add(key);
                    }
                    form.add("metaarray", (JsonElement)metaArrayObj);
                    form.add("metaarray_key_order", (JsonElement)metaArrayKeyOrderArray);
                }
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void sendUserMessage(final boolean isOpenChannel, final String channelUrl, final String message, final String data, final String customType, final BaseMessageParams.MentionType mentionType, final List<String> mentionedUserIds, final BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, final List<MessageMetaArray> metaArrays, final List<String> targetLanguages, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                JsonArray array;
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("message_type", "MESG");
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                form.addProperty("message", message);
                if (data != null) {
                    form.addProperty("data", data);
                }
                if (customType != null) {
                    form.addProperty("custom_type", customType);
                }
                if (mentionType == BaseMessageParams.MentionType.USERS) {
                    form.addProperty("mention_type", "users");
                    if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                        array = new JsonArray();
                        for (Object userId : mentionedUserIds) {
                            array.add((String)userId);
                        }
                        form.add("mentioned_user_ids", (JsonElement)array);
                    }
                } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
                    form.addProperty("mention_type", "channel");
                }
                if (pushNotificationDeliveryOption != null && pushNotificationDeliveryOption == BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS) {
                    form.addProperty("push_option", "suppress");
                }
                if (metaArrays != null && metaArrays.size() > 0) {
                    JsonObject metaArrayObj = new JsonObject();
                    JsonArray metaArrayKeyOrderArray = new JsonArray();
                    for (MessageMetaArray metaArray : metaArrays) {
                        String key = metaArray.getKey();
                        List<String> values = metaArray.getValue();
                        if (key == null) continue;
                        JsonArray array2 = new JsonArray();
                        for (String value : values) {
                            array2.add(value);
                        }
                        metaArrayObj.add(key, (JsonElement)array2);
                        metaArrayKeyOrderArray.add(key);
                    }
                    form.add("metaarray", (JsonElement)metaArrayObj);
                    form.add("metaarray_key_order", (JsonElement)metaArrayKeyOrderArray);
                }
                if (targetLanguages != null && targetLanguages.size() > 0) {
                    array = new JsonArray();
                    for (String targetLanguage : targetLanguages) {
                        array.add(targetLanguage);
                    }
                    form.add("target_langs", (JsonElement)array);
                }
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void translateUserMessage(final boolean isOpenChannel, final String channelUrl, final long messageId, final List<String> targetLanguages, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_TRANSLATION, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_TRANSLATION, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId));
                JsonObject form = APIClient.this.defaultForm();
                if (targetLanguages != null && targetLanguages.size() > 0) {
                    JsonArray array = new JsonArray();
                    for (String targetLanguage : targetLanguages) {
                        array.add(targetLanguage);
                    }
                    form.add("target_langs", (JsonElement)array);
                }
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void registerScheduledUserMessage(final boolean isOpenChannel, final String channelUrl, final String scheduleDt, final String message, final String data, final String customType, final BaseMessageParams.MentionType mentionType, final List<String> mentionedUserIds, final BaseMessageParams.PushNotificationDeliveryOption pushNotificationDeliveryOption, final List<MessageMetaArray> metaArrays, final List<String> targetLanguages, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                JsonArray array;
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_SCHEDULED_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_SCHEDULED_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                form.addProperty("scheduled_dt", scheduleDt);
                form.addProperty("message", message);
                if (data != null) {
                    form.addProperty("data", data);
                }
                if (customType != null) {
                    form.addProperty("custom_type", customType);
                }
                if (mentionType == BaseMessageParams.MentionType.USERS) {
                    form.addProperty("mention_type", "users");
                    if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                        array = new JsonArray();
                        for (Object mentionedUserId : mentionedUserIds) {
                            array.add((String)mentionedUserId);
                        }
                        form.add("mentioned_user_ids", (JsonElement)array);
                    }
                } else if (mentionType == BaseMessageParams.MentionType.CHANNEL) {
                    form.addProperty("mention_type", "channel");
                }
                if (mentionedUserIds != null && mentionedUserIds.size() > 0) {
                    array = new JsonArray();
                    for (Object mentionedUserId : mentionedUserIds) {
                        array.add((String)mentionedUserId);
                    }
                    form.add("mentioned_user_ids", (JsonElement)array);
                }
                if (pushNotificationDeliveryOption != null && pushNotificationDeliveryOption == BaseMessageParams.PushNotificationDeliveryOption.SUPPRESS) {
                    form.addProperty("push_option", "suppress");
                }
                if (metaArrays != null && metaArrays.size() > 0) {
                    JsonObject metaArrayObj = new JsonObject();
                    JsonArray metaArrayKeyOrderArray = new JsonArray();
                    for (MessageMetaArray metaArray : metaArrays) {
                        String key = metaArray.getKey();
                        List<String> values = metaArray.getValue();
                        if (key == null) continue;
                        JsonArray array2 = new JsonArray();
                        for (String value : values) {
                            array2.add(value);
                        }
                        metaArrayObj.add(key, (JsonElement)array2);
                        metaArrayKeyOrderArray.add(key);
                    }
                    form.add("metaarray", (JsonElement)metaArrayObj);
                    form.add("metaarray_key_order", (JsonElement)metaArrayKeyOrderArray);
                }
                if (targetLanguages != null && targetLanguages.size() > 0) {
                    array = new JsonArray();
                    for (String targetLanguage : targetLanguages) {
                        array.add(targetLanguage);
                    }
                    form.add("translation_target_langs", (JsonElement)array);
                }
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void messageList(final boolean isOpenChannel, final String channelUrl, final long messageTimestamp, final int prevLimit, final int nextLimit, final boolean include, final boolean reverse, final String messageType, final String customType, final Collection<String> senderUserIds, final boolean includeMetaArray, final boolean includeReactions, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("is_sdk", String.valueOf(true));
                params.put("message_ts", String.valueOf(messageTimestamp));
                params.put("prev_limit", String.valueOf(prevLimit));
                params.put("next_limit", String.valueOf(nextLimit));
                params.put("include", String.valueOf(include));
                params.put("reverse", String.valueOf(reverse));
                if (messageType != null) {
                    params.put("message_type", messageType);
                }
                if (customType != null) {
                    params.put("custom_type", customType);
                }
                if (includeMetaArray) {
                    params.put("with_sorted_meta_array", "true");
                }
                if (includeReactions) {
                    params.put("include_reactions", "true");
                }
                HashMap<String, Collection> paramsWithListValue = new HashMap<String, Collection>();
                if (senderUserIds != null && senderUserIds.size() > 0) {
                    paramsWithListValue.put("sender_ids", senderUserIds);
                }
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void messageListById(final boolean isOpenChannel, final String channelUrl, final long messageId, final int prevLimit, final int nextLimit, final boolean include, final boolean reverse, final String messageType, final String customType, final Collection<String> senderUserIds, final boolean includeMetaArray, final boolean includeReactions, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("is_sdk", String.valueOf(true));
                params.put("message_id", String.valueOf(messageId));
                params.put("prev_limit", String.valueOf(prevLimit));
                params.put("next_limit", String.valueOf(nextLimit));
                params.put("include", String.valueOf(include));
                params.put("reverse", String.valueOf(reverse));
                if (messageType != null) {
                    params.put("message_type", messageType);
                }
                if (customType != null) {
                    params.put("custom_type", customType);
                }
                if (includeMetaArray) {
                    params.put("with_sorted_meta_array", "true");
                }
                if (includeReactions) {
                    params.put("include_reactions", "true");
                }
                HashMap<String, Collection> paramsWithListValue = new HashMap<String, Collection>();
                if (senderUserIds != null && senderUserIds.size() > 0) {
                    paramsWithListValue.put("sender_ids", senderUserIds);
                }
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void messageChangeLogs(final boolean isOpenChannel, final String channelUrl, final String token, final Long ts, final boolean includeMetaArray, final boolean includeReactions, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES_CHANGELOGS, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                if (token != null) {
                    params.put("token", token);
                }
                if (ts != null) {
                    params.put("change_ts", String.valueOf(ts));
                }
                if (includeMetaArray) {
                    params.put("with_sorted_meta_array", "true");
                }
                if (includeReactions) {
                    params.put("include_reactions", "true");
                }
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void getMyGroupChannelChangeLogs(final String token, final Long ts, final List<String> customTypes, final boolean includeEmpty, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_MYGROUPCHANNELS_CHANGELOGS, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, String> params = new HashMap<String, String>();
                if (token != null) {
                    params.put("token", token);
                }
                if (ts != null) {
                    params.put("change_ts", String.valueOf(ts));
                }
                HashMap<String, List> paramsWithListValue = new HashMap<String, List>();
                if (customTypes != null && customTypes.size() > 0) {
                    paramsWithListValue.put("custom_types", customTypes);
                }
                params.put("show_member", "true");
                params.put("show_read_receipt", "true");
                params.put("show_empty", String.valueOf(includeEmpty));
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void login(final String accessToken, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_LOGIN, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("app_id", SendBird.getApplicationId());
                if (accessToken != null) {
                    form.addProperty("access_token", accessToken);
                }
                APIClient.this.requestPOST(url, (JsonElement)form, new APIClientHandler(){

                    @Override
                    public void onResult(JsonElement response, SendBirdException e) {
                        if (e != null) {
                            if (handler != null) {
                                handler.onResult(null, e);
                            }
                            return;
                        }
                        String sessionKey = response.getAsJsonObject().get("key").getAsString();
                        APIClient.this.setSessionKey(sessionKey);
                        if (handler != null) {
                            handler.onResult(response, null);
                        }
                    }
                });
            }
        });
    }

    void updateUserInfo(final String nickname, final String profileUrl, final List<String> discoveryKeys, final List<String> preferredLanguages, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                JsonObject form = APIClient.this.defaultForm();
                if (nickname != null) {
                    form.addProperty("nickname", nickname);
                }
                if (profileUrl != null) {
                    form.addProperty("profile_url", profileUrl);
                }
                if (discoveryKeys != null) {
                    JsonArray discoveryKeysArray = new JsonArray();
                    for (String discoveryKey : discoveryKeys) {
                        discoveryKeysArray.add(discoveryKey);
                    }
                    form.add("discovery_keys", (JsonElement)discoveryKeysArray);
                }
                if (preferredLanguages != null) {
                    JsonArray preferredLanguagesArray = new JsonArray();
                    for (String preferredLanguage : preferredLanguages) {
                        preferredLanguagesArray.add(preferredLanguage);
                    }
                    form.add("preferred_languages", (JsonElement)preferredLanguagesArray);
                }
                String url = String.format(APIClient.API_USERS_USERID, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void updateUserInfo(final String nickname, final File profileFile, final List<String> discoveryKeys, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                HashMap<String, String> form = new HashMap<String, String>();
                String filename = null;
                if (nickname != null) {
                    form.put("nickname", nickname);
                }
                if (profileFile != null) {
                    filename = "profile_file";
                }
                if (discoveryKeys != null) {
                    StringBuilder sb = new StringBuilder();
                    String separator = "";
                    for (String str : discoveryKeys) {
                        sb.append(separator);
                        separator = ",";
                        sb.append(str);
                    }
                    String result = sb.toString();
                    form.put("discovery_keys", result);
                }
                String url = String.format(APIClient.API_USERS_USERID, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestPUT(url, form, filename, profileFile, handler);
            }
        });
    }

    void getGroupChannel(final String channelUrl, final boolean member, final boolean readReceipt, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("member", String.valueOf(member));
                params.put("read_receipt", String.valueOf(readReceipt));
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void getOpenChannel(final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void createGroupChannel(final List<String> userIds, final List<String> operatorUserIds, final Boolean isSuper, final Boolean isPublic, final Boolean isEphemeral, final Boolean isDistinct, final Boolean isDiscoverable, final String channelUrl, final String name, final String coverUrl, final String data, final String customType, final String accessCode, final Boolean strict, final Boolean isBroadcast, final Integer messageSurvivalSeconds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = APIClient.API_GROUPCHANNELS;
                JsonObject form = APIClient.this.defaultForm();
                JsonArray userIdsObj = new JsonArray();
                LinkedHashSet<String> userIdSet = new LinkedHashSet<String>(userIds);
                userIdSet.add(SendBird.getCurrentUser().getUserId());
                for (String userId : userIdSet) {
                    userIdsObj.add(userId);
                }
                form.add("user_ids", (JsonElement)userIdsObj);
                if (operatorUserIds != null && operatorUserIds.size() > 0) {
                    JsonArray operatorUserIdsObj = new JsonArray();
                    for (String operatorUserId : operatorUserIds) {
                        operatorUserIdsObj.add(operatorUserId);
                    }
                    form.add("operator_ids", (JsonElement)operatorUserIdsObj);
                }
                if (isSuper != null) {
                    form.addProperty("is_super", isSuper);
                }
                if (isPublic != null) {
                    form.addProperty("is_public", isPublic);
                }
                if (isEphemeral != null) {
                    form.addProperty("is_ephemeral", isEphemeral);
                }
                if (isDistinct != null) {
                    form.addProperty("is_distinct", isDistinct);
                }
                if (isDiscoverable != null) {
                    form.addProperty("is_discoverable", isDiscoverable);
                }
                if (channelUrl != null) {
                    form.addProperty("channel_url", channelUrl);
                }
                if (name != null) {
                    form.addProperty("name", name);
                }
                if (coverUrl != null) {
                    form.addProperty("cover_url", coverUrl);
                }
                if (data != null) {
                    form.addProperty("data", data);
                }
                if (customType != null) {
                    form.addProperty("custom_type", customType);
                }
                if (accessCode != null) {
                    form.addProperty("access_code", accessCode);
                }
                if (strict != null) {
                    form.addProperty("strict", strict);
                }
                if (isBroadcast != null) {
                    form.addProperty("is_broadcast", isBroadcast);
                }
                if (messageSurvivalSeconds != null) {
                    form.addProperty("message_survival_seconds", (Number)messageSurvivalSeconds);
                }
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void createGroupChannel(final List<String> userIds, final List<String> operatorUserIds, final Boolean isSuper, final Boolean isPublic, final Boolean isEphemeral, final Boolean isDistinct, final Boolean isDiscoverable, final String channelUrl, final String name, final File coverFile, final String data, final String customType, final String accessCode, final Boolean strict, final Boolean isBroadcast, final Integer messageSurvivalSeconds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = APIClient.API_GROUPCHANNELS;
                HashMap<String, String> form = new HashMap<String, String>();
                String filename = null;
                LinkedHashSet<String> userIdSet = new LinkedHashSet<String>(userIds);
                userIdSet.add(SendBird.getCurrentUser().getUserId());
                form.put("user_ids", UrlUtil.urlEncodeUTF8(userIdSet));
                if (operatorUserIds != null && operatorUserIds.size() > 0) {
                    form.put("operator_ids", UrlUtil.urlEncodeUTF8(operatorUserIds));
                }
                if (isSuper != null) {
                    form.put("is_super", isSuper != false ? "true" : "false");
                }
                if (isPublic != null) {
                    form.put("is_public", isPublic != false ? "true" : "false");
                }
                if (isEphemeral != null) {
                    form.put("is_ephemeral", isEphemeral != false ? "true" : "false");
                }
                if (isDistinct != null) {
                    form.put("is_distinct", isDistinct != false ? "true" : "false");
                }
                if (isDiscoverable != null) {
                    form.put("is_discoverable", isDiscoverable != false ? "true" : "false");
                }
                if (channelUrl != null) {
                    form.put("channel_url", channelUrl);
                }
                if (name != null) {
                    form.put("name", name);
                }
                if (coverFile != null) {
                    filename = "cover_file";
                }
                if (data != null) {
                    form.put("data", data);
                }
                if (customType != null) {
                    form.put("custom_type", customType);
                }
                if (accessCode != null) {
                    form.put("access_code", accessCode);
                }
                if (strict != null) {
                    form.put("strict", strict != false ? "true" : "false");
                }
                if (isBroadcast != null) {
                    form.put("is_broadcast", String.valueOf(isBroadcast));
                }
                if (messageSurvivalSeconds != null) {
                    form.put("message_survival_seconds", messageSurvivalSeconds.toString());
                }
                APIClient.this.requestPOST(url, form, filename, coverFile, handler);
            }
        });
    }

    void updateGroupChannel(final String channelUrl, final Boolean isPublic, final Boolean isEphemeral, final Boolean isDistinct, final Boolean isDiscoverable, final String name, final String coverUrl, final String data, final String customType, final String accessCode, final Boolean strict, final Integer messageSurvivalSeconds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                if (isPublic != null) {
                    form.addProperty("is_public", isPublic);
                }
                if (isEphemeral != null) {
                    form.addProperty("is_ephemeral", isEphemeral);
                }
                if (isDistinct != null) {
                    form.addProperty("is_distinct", isDistinct);
                }
                if (isDiscoverable != null) {
                    form.addProperty("is_discoverable", isDiscoverable);
                }
                if (name != null) {
                    form.addProperty("name", name);
                }
                if (coverUrl != null) {
                    form.addProperty("cover_url", coverUrl);
                }
                if (data != null) {
                    form.addProperty("data", data);
                }
                if (customType != null) {
                    form.addProperty("custom_type", customType);
                }
                if (accessCode != null) {
                    form.addProperty("access_code", accessCode);
                }
                if (strict != null) {
                    form.addProperty("strict", strict);
                }
                if (messageSurvivalSeconds != null) {
                    form.addProperty("message_survival_seconds", (Number)messageSurvivalSeconds);
                }
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void updateGroupChannel(final String channelUrl, final Boolean isPublic, final Boolean isEphemeral, final Boolean isDistinct, final Boolean isDiscoverable, final String name, final File coverFile, final String data, final String customType, final String accessCode, final Boolean strict, final Integer messageSurvivalSeconds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> form = new HashMap<String, String>();
                String filename = null;
                if (isPublic != null) {
                    form.put("is_public", isPublic != false ? "true" : "false");
                }
                if (isEphemeral != null) {
                    form.put("is_ephemeral", isEphemeral != false ? "true" : "false");
                }
                if (isDistinct != null) {
                    form.put("is_distinct", isDistinct != false ? "true" : "false");
                }
                if (isDiscoverable != null) {
                    form.put("is_discoverable", isDiscoverable != false ? "true" : "false");
                }
                if (name != null) {
                    form.put("name", name);
                }
                if (coverFile != null) {
                    filename = "cover_file";
                }
                if (data != null) {
                    form.put("data", data);
                }
                if (customType != null) {
                    form.put("custom_type", customType);
                }
                if (accessCode != null) {
                    form.put("access_code", accessCode);
                }
                if (strict != null) {
                    form.put("strict", strict != false ? "true" : "false");
                }
                if (messageSurvivalSeconds != null) {
                    form.put("message_survival_seconds", messageSurvivalSeconds.toString());
                }
                APIClient.this.requestPUT(url, form, filename, coverFile, handler);
            }
        });
    }

    void createOpenChannel(final String name, final String channelUrl, final String coverUrl, final String data, final String customType, final List<String> operatorUserIds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = APIClient.API_OPENCHANNELS;
                JsonObject form = APIClient.this.defaultForm();
                if (name != null) {
                    form.addProperty("name", name);
                }
                if (channelUrl != null) {
                    form.addProperty("channel_url", channelUrl);
                }
                if (coverUrl != null) {
                    form.addProperty("cover_url", coverUrl);
                }
                if (data != null) {
                    form.addProperty("data", data);
                }
                if (customType != null) {
                    form.addProperty("custom_type", customType);
                }
                if (operatorUserIds != null && operatorUserIds.size() > 0) {
                    JsonArray operatorUserIdsObj = new JsonArray();
                    for (String operatorUserId : operatorUserIds) {
                        operatorUserIdsObj.add(operatorUserId);
                    }
                    form.add("operators", (JsonElement)operatorUserIdsObj);
                }
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void createOpenChannel(final String name, final String channelUrl, final File coverFile, final String data, final String customType, final List<String> operatorUserIds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = APIClient.API_OPENCHANNELS;
                HashMap<String, String> form = new HashMap<String, String>();
                String filename = null;
                if (name != null) {
                    form.put("name", name);
                }
                if (channelUrl != null) {
                    form.put("channel_url", channelUrl);
                }
                if (coverFile != null) {
                    filename = "cover_file";
                }
                if (data != null) {
                    form.put("data", data);
                }
                if (customType != null) {
                    form.put("custom_type", customType);
                }
                if (operatorUserIds != null && operatorUserIds.size() > 0) {
                    form.put("operators", UrlUtil.urlEncodeUTF8(operatorUserIds));
                }
                APIClient.this.requestPOST(url, form, filename, coverFile, handler);
            }
        });
    }

    void updateOpenChannel(final String channelUrl, final String name, final String coverUrl, final String data, final String customType, final List<String> operatorUserIds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                if (name != null) {
                    form.addProperty("name", name);
                }
                if (coverUrl != null) {
                    form.addProperty("cover_url", coverUrl);
                }
                if (data != null) {
                    form.addProperty("data", data);
                }
                if (customType != null) {
                    form.addProperty("custom_type", customType);
                }
                if (operatorUserIds != null && operatorUserIds.size() > 0) {
                    JsonArray operatorUserIdsObj = new JsonArray();
                    for (String operatorUserId : operatorUserIds) {
                        operatorUserIdsObj.add(operatorUserId);
                    }
                    form.add("operators", (JsonElement)operatorUserIdsObj);
                }
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void updateOpenChannel(final String channelUrl, final String name, final File coverFile, final String data, final String customType, final List<String> operatorUserIds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> form = new HashMap<String, String>();
                String filename = null;
                if (name != null) {
                    form.put("name", name);
                }
                if (coverFile != null) {
                    filename = "cover_file";
                }
                if (data != null) {
                    form.put("data", data);
                }
                if (customType != null) {
                    form.put("custom_type", customType);
                }
                if (operatorUserIds != null && operatorUserIds.size() > 0) {
                    form.put("operators", UrlUtil.urlEncodeUTF8(operatorUserIds));
                }
                APIClient.this.requestPUT(url, form, filename, coverFile, handler);
            }
        });
    }

    void createMetaCounters(final boolean isOpenChannel, final String channelUrl, final Map<String, Integer> metaCounterMap, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                JsonObject metas = new JsonObject();
                for (Map.Entry entry : metaCounterMap.entrySet()) {
                    metas.addProperty((String)entry.getKey(), (Number)entry.getValue());
                }
                form.add("metacounter", (JsonElement)metas);
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void updateMetaCounters(final boolean isOpenChannel, final String channelUrl, final Map<String, Integer> metaCounterMap, final boolean upsert, final int mode, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                JsonObject metas = new JsonObject();
                for (Map.Entry entry : metaCounterMap.entrySet()) {
                    metas.addProperty((String)entry.getKey(), (Number)entry.getValue());
                }
                form.add("metacounter", (JsonElement)metas);
                form.addProperty("upsert", Boolean.valueOf(upsert));
                switch (mode) {
                    case 0: {
                        form.addProperty("mode", "set");
                        break;
                    }
                    case 1: {
                        form.addProperty("mode", "increase");
                        break;
                    }
                    case 2: {
                        form.addProperty("mode", "decrease");
                    }
                }
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getAllMetaCounters(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        this.getMetaCounters(isOpenChannel, channelUrl, new ArrayList<String>(), handler);
    }

    void getMetaCounters(final boolean isOpenChannel, final String channelUrl, final Collection<String> keys, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, Collection> paramsWithListValue = new HashMap<String, Collection>();
                if (keys != null && keys.size() > 0) {
                    paramsWithListValue.put("keys", keys);
                }
                APIClient.this.requestGET(url, null, paramsWithListValue, handler);
            }
        });
    }

    void deleteMetaCounter(final boolean isOpenChannel, final String channelUrl, final String key, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METACOUNTER_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METACOUNTER_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void deleteAllMetaCounters(final boolean isOpenChannel, final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METACOUNTER, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void createMetaData(final boolean isOpenChannel, final String channelUrl, final Map<String, String> metaDataMap, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                JsonObject metas = new JsonObject();
                for (Map.Entry entry : metaDataMap.entrySet()) {
                    metas.addProperty((String)entry.getKey(), (String)entry.getValue());
                }
                form.add("metadata", (JsonElement)metas);
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void updateMetaData(final boolean isOpenChannel, final String channelUrl, final Map<String, String> metaDataMap, final boolean upsert, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                JsonObject metas = new JsonObject();
                for (Map.Entry entry : metaDataMap.entrySet()) {
                    metas.addProperty((String)entry.getKey(), (String)entry.getValue());
                }
                form.add("metadata", (JsonElement)metas);
                form.addProperty("upsert", Boolean.valueOf(upsert));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getAllMetaData(boolean isOpenChannel, String channelUrl, APIClientHandler handler) {
        this.getMetaData(isOpenChannel, channelUrl, new ArrayList<String>(), handler);
    }

    void getMetaData(final boolean isOpenChannel, final String channelUrl, final Collection<String> keys, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, Collection> paramsWithListValue = new HashMap<String, Collection>();
                if (keys != null && keys.size() > 0) {
                    paramsWithListValue.put("keys", keys);
                }
                APIClient.this.requestGET(url, null, paramsWithListValue, handler);
            }
        });
    }

    void deleteMetaData(final boolean isOpenChannel, final String channelUrl, final String key, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METADATA_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METADATA_KEY, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(key));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void deleteAllMetaData(final boolean isOpenChannel, final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_METADATA, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void createUserMetaData(final String userId, final Map<String, String> metaDataMap, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_METADATA, UrlUtil.urlEncodeUTF8(userId));
                JsonObject form = APIClient.this.defaultForm();
                JsonObject metas = new JsonObject();
                for (Map.Entry entry : metaDataMap.entrySet()) {
                    metas.addProperty((String)entry.getKey(), (String)entry.getValue());
                }
                form.add("metadata", (JsonElement)metas);
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void updateUserMetaData(final String userId, final Map<String, String> metaDataMap, final boolean upsert, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_METADATA, UrlUtil.urlEncodeUTF8(userId));
                JsonObject form = APIClient.this.defaultForm();
                JsonObject metas = new JsonObject();
                for (Map.Entry entry : metaDataMap.entrySet()) {
                    metas.addProperty((String)entry.getKey(), (String)entry.getValue());
                }
                form.add("metadata", (JsonElement)metas);
                form.addProperty("upsert", Boolean.valueOf(upsert));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getAllUserMetaData(String userId, APIClientHandler handler) {
        this.getUserMetaData(userId, new ArrayList<String>(), handler);
    }

    void getUserMetaData(final String userId, final Collection<String> keys, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_METADATA, UrlUtil.urlEncodeUTF8(userId));
                HashMap<String, Collection> paramsWithListValue = new HashMap<String, Collection>();
                if (keys != null && keys.size() > 0) {
                    paramsWithListValue.put("keys", keys);
                }
                APIClient.this.requestGET(url, null, paramsWithListValue, handler);
            }
        });
    }

    void deleteUserMetaData(final String userId, final String key, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_METADATA_KEY, UrlUtil.urlEncodeUTF8(userId), UrlUtil.urlEncodeUTF8(key));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void deleteAllUserMetaData(final String userId, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_METADATA, UrlUtil.urlEncodeUTF8(userId));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    private void addMetaDataFilterToParams(Map<String, String> params, Map<String, Collection<String>> paramsWithListValue, Map<String, List<String>> metaDataFilter) {
        String key;
        List<String> values;
        Iterator<String> keys;
        if (metaDataFilter != null && (keys = metaDataFilter.keySet().iterator()).hasNext() && (values = metaDataFilter.get(key = keys.next())) != null && values.size() > 0) {
            params.put("metadatakey", key);
            paramsWithListValue.put("metadatavalues_in", values);
        }
    }

    void loadUserList(final String token, final int limit, final List<String> userIds, final Map<String, List<String>> metaDataFilter, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = APIClient.API_USERS;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                HashMap<String, List> paramsWithListValue = new HashMap<String, List>();
                if (userIds != null && userIds.size() > 0) {
                    paramsWithListValue.put("user_ids", userIds);
                }
                APIClient.this.addMetaDataFilterToParams(params, paramsWithListValue, metaDataFilter);
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void loadBlockedUserList(final String token, final int limit, final List<String> userIds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_BLOCK, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                HashMap<String, List> paramsWithListValue = new HashMap<String, List>();
                if (userIds != null && userIds.size() > 0) {
                    paramsWithListValue.put("user_ids", userIds);
                }
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void loadOpenChannelList(final String token, final int limit, final String nameKeyword, final String urlKeyword, final String customType, final String customTypeStartsWith, final ArrayList<String> customTypes, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = APIClient.API_OPENCHANNELS;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                if (customType != null) {
                    params.put("custom_type", customType);
                }
                if (nameKeyword != null) {
                    params.put("name_contains", nameKeyword);
                }
                if (urlKeyword != null) {
                    params.put("url_contains", urlKeyword);
                }
                if (customTypeStartsWith != null) {
                    params.put("custom_type_startswith", customTypeStartsWith);
                }
                HashMap<String, ArrayList> paramsWithListValue = new HashMap<String, ArrayList>();
                if (customTypes != null && customTypes.size() > 0) {
                    paramsWithListValue.put("custom_types", customTypes);
                }
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void uploadFile(File file, String mimeType, List<FileMessage.ThumbnailSize> thumbnailSizes, String channelUrl, String requestId, APIClientProgressHandler progressHandler, APIClientHandler handler) {
        this.requestFILE(API_STORAGE_FILE, file, mimeType, thumbnailSizes, channelUrl, requestId, progressHandler, handler);
    }

    void uploadProfileImage(File file, APIClientHandler handler) {
        this.requestFILE(API_STORAGE_PROFILEIMAGE, file, null, null, null, null, null, handler);
    }

    private JsonObject defaultForm() {
        return new JsonObject();
    }

    void loadUserGroupChannelList(final String token, final int limit, final boolean includeEmpty, final String order, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = APIClient.API_GROUPCHANNELS;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("user_id", SendBird.getCurrentUser().getUserId());
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                params.put("read_receipt", String.valueOf(true));
                params.put("member", String.valueOf(true));
                params.put("show_empty", String.valueOf(includeEmpty));
                params.put("order", order);
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void loadUserGroupChannelList(final String token, final int limit, final boolean includeEmpty, final String order, final String metaDataOrderKey, final GroupChannelListQuery.FilterMode mode, final List<String> filter, final GroupChannelListQuery.QueryType queryType, final String searchQuery, final List<GroupChannelListQuery.SearchField> searchFields, final String customType, final String customTypeStartsWith, final String memberState, final List<String> channelUrls, final String nameContains, final List<String> customTypes, final GroupChannelListQuery.SuperChannelFilter superChannelFilter, final GroupChannelListQuery.PublicChannelFilter publicChannelFilter, final GroupChannelListQuery.UnreadChannelFilter unreadChannelFilter, final GroupChannelListQuery.HiddenChannelFilter hiddenChannelFilter, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                String key;
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_MYGROUPCHANNELS, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                params.put("show_read_receipt", String.valueOf(true));
                params.put("show_member", String.valueOf(true));
                params.put("show_empty", String.valueOf(includeEmpty));
                params.put("distinct_mode", "all");
                params.put("order", order);
                if (order.equals("metadata_value_alphabetical") && metaDataOrderKey != null) {
                    params.put("metadata_order_key", metaDataOrderKey);
                }
                if (customType != null) {
                    params.put("custom_type", customType);
                }
                if (customTypeStartsWith != null) {
                    params.put("custom_type_startswith", customTypeStartsWith);
                }
                if (memberState != null) {
                    params.put("member_state_filter", memberState);
                }
                if (nameContains != null) {
                    params.put("name_contains", nameContains);
                }
                if (mode == GroupChannelListQuery.FilterMode.MEMBERS_EXACTLY_IN) {
                    key = "members_exactly_in";
                } else if (mode == GroupChannelListQuery.FilterMode.MEMBERS_NICKNAME_CONTAINS) {
                    key = "members_nickname_contains";
                } else if (mode == GroupChannelListQuery.FilterMode.MEMBERS_INCLUDE_IN) {
                    String qt;
                    key = "members_include_in";
                    String string = queryType == GroupChannelListQuery.QueryType.AND ? "AND" : (qt = queryType == GroupChannelListQuery.QueryType.OR ? "OR" : null);
                    if (qt != null) {
                        params.put("query_type", qt);
                    }
                } else {
                    key = null;
                }
                HashMap<String, List> paramsWithListValue = new HashMap<String, List>();
                if (key != null && filter != null && filter.size() > 0) {
                    paramsWithListValue.put(key, filter);
                }
                if (searchQuery != null && searchFields != null) {
                    params.put("search_query", searchQuery);
                    boolean hasChannelNameField = false;
                    boolean hasMemberNicknameField = false;
                    for (GroupChannelListQuery.SearchField searchField : searchFields) {
                        if (searchField == GroupChannelListQuery.SearchField.CHANNEL_NAME) {
                            hasChannelNameField = true;
                        }
                        if (searchField != GroupChannelListQuery.SearchField.MEMBER_NICKNAME) continue;
                        hasMemberNicknameField = true;
                    }
                    String fields = "";
                    if (hasChannelNameField) {
                        fields = "channel_name";
                    }
                    if (hasMemberNicknameField) {
                        fields = fields + (fields.isEmpty() ? "" : ",");
                        fields = fields + "member_nickname";
                    }
                    if (!fields.isEmpty()) {
                        params.put("search_fields", fields);
                    }
                }
                if (channelUrls != null && channelUrls.size() > 0) {
                    paramsWithListValue.put("channel_urls", channelUrls);
                }
                if (customTypes != null && customTypes.size() > 0) {
                    paramsWithListValue.put("custom_types", customTypes);
                }
                if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.ALL) {
                    params.put("super_mode", "all");
                } else if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.SUPER_CHANNEL_ONLY) {
                    params.put("super_mode", "super");
                } else if (superChannelFilter == GroupChannelListQuery.SuperChannelFilter.NONSUPER_CHANNEL_ONLY) {
                    params.put("super_mode", "nonsuper");
                }
                if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.ALL) {
                    params.put("public_mode", "all");
                } else if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.PUBLIC) {
                    params.put("public_mode", "public");
                } else if (publicChannelFilter == GroupChannelListQuery.PublicChannelFilter.PRIVATE) {
                    params.put("public_mode", "private");
                }
                if (unreadChannelFilter == GroupChannelListQuery.UnreadChannelFilter.ALL) {
                    params.put("unread_filter", "all");
                } else if (unreadChannelFilter == GroupChannelListQuery.UnreadChannelFilter.UNREAD_MESSAGE) {
                    params.put("unread_filter", "unread_message");
                }
                if (hiddenChannelFilter == GroupChannelListQuery.HiddenChannelFilter.UNHIDDEN) {
                    params.put("hidden_mode", "unhidden_only");
                } else if (hiddenChannelFilter == GroupChannelListQuery.HiddenChannelFilter.HIDDEN) {
                    params.put("hidden_mode", "hidden_only");
                } else if (hiddenChannelFilter == GroupChannelListQuery.HiddenChannelFilter.HIDDEN_ALLOW_AUTO_UNHIDE) {
                    params.put("hidden_mode", "hidden_allow_auto_unhide");
                } else if (hiddenChannelFilter == GroupChannelListQuery.HiddenChannelFilter.HIDDEN_PREVENT_AUTO_UNHIDE) {
                    params.put("hidden_mode", "hidden_prevent_auto_unhide");
                }
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void loadPublicGroupChannelList(final String token, final int limit, final boolean includeEmpty, final String order, final String metaDataOrderKey, final String customTypeStartsWith, final String memberState, final List<String> channelUrls, final String nameContains, final List<String> customTypes, final PublicGroupChannelListQuery.SuperChannelFilter superChannelFilter, final PublicGroupChannelListQuery.MembershipFilter membershipFilter, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = APIClient.API_GROUPCHANNELS;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("public_mode", "public");
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                params.put("show_read_receipt", String.valueOf(true));
                params.put("show_member", String.valueOf(true));
                params.put("show_empty", String.valueOf(includeEmpty));
                params.put("distinct_mode", "all");
                params.put("order", order);
                if (order.equals("metadata_value_alphabetical") && metaDataOrderKey != null) {
                    params.put("metadata_order_key", metaDataOrderKey);
                }
                if (customTypeStartsWith != null) {
                    params.put("custom_type_startswith", customTypeStartsWith);
                }
                if (memberState != null) {
                    params.put("member_state_filter", memberState);
                }
                if (nameContains != null) {
                    params.put("name_contains", nameContains);
                }
                HashMap<String, List> paramsWithListValue = new HashMap<String, List>();
                if (channelUrls != null && channelUrls.size() > 0) {
                    paramsWithListValue.put("channel_urls", channelUrls);
                }
                if (customTypes != null && customTypes.size() > 0) {
                    paramsWithListValue.put("custom_types", customTypes);
                }
                if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.ALL) {
                    params.put("super_mode", "all");
                } else if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.SUPER_CHANNEL_ONLY) {
                    params.put("super_mode", "super");
                } else if (superChannelFilter == PublicGroupChannelListQuery.SuperChannelFilter.NONSUPER_CHANNEL_ONLY) {
                    params.put("super_mode", "nonsuper");
                }
                if (membershipFilter == PublicGroupChannelListQuery.MembershipFilter.ALL) {
                    params.put("public_membership_mode", "all");
                } else if (membershipFilter == PublicGroupChannelListQuery.MembershipFilter.JOINED) {
                    params.put("public_membership_mode", "joined");
                }
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void loadOpenChannelParticipantList(final String channelUrl, final String token, final int limit, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_OPENCHANNELS_CHANNELURL_PARTICIPANTS, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void loadMutedUserList(final boolean isOpenChannel, final String channelUrl, final String token, final int limit, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void loadBannedUserList(final boolean isOpenChannel, final String channelUrl, final String token, final int limit, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void loadOperatorList(final boolean isOpenChannel, final String channelUrl, final String token, final int limit, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_OPERATORS, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_OPERATORS, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("token", token);
                params.put("limit", String.valueOf(limit));
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void registerPushToken(final String gcmRegToken, final boolean unique, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSH_GCM, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("gcm_reg_token", gcmRegToken);
                form.addProperty("is_unique", Boolean.valueOf(unique));
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void unregisterPushToken(final String gcmRegToken, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSH_GCM_TOKEN, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(gcmRegToken));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void unregisterPushTokenAll(final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSH, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void getMyPushTokens(final String token, final SendBird.PushTokenType type, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String pushTokenType = "";
                switch (type) {
                    case GCM: {
                        pushTokenType = "gcm";
                        break;
                    }
                    case APNS: {
                        pushTokenType = "apns";
                        break;
                    }
                    case APNS_VOIP: {
                        pushTokenType = "apns_voip";
                    }
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSH_TOKENTYPE_DEVICETOKENS, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), pushTokenType);
                HashMap<String, String> params = new HashMap<String, String>();
                if (token != null) {
                    params.put("token", token);
                }
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void setPushTemplate(final String template, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSH_TEMPLATE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("name", template);
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getPushTemplate(final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSH_TEMPLATE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void setPushTriggerOption(final SendBird.PushTriggerOption pushTriggerOption, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String triggerOption = "";
                if (pushTriggerOption == SendBird.PushTriggerOption.ALL) {
                    triggerOption = "all";
                } else if (pushTriggerOption == SendBird.PushTriggerOption.MENTION_ONLY) {
                    triggerOption = "mention_only";
                } else if (pushTriggerOption == SendBird.PushTriggerOption.OFF) {
                    triggerOption = "off";
                }
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("push_trigger_option", triggerOption);
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getPushTriggerOption(final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void setAutoAcceptInvitation(final boolean autoAccept, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_CHANNELINVITATIONPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("auto_accept", Boolean.valueOf(autoAccept));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getAutoAcceptInvitation(final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_CHANNELINVITATIONPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void blockUser(final String blockeeUserId, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_BLOCK, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("target_id", blockeeUserId);
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void unblockUser(final String blockeeUserId, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_BLOCK_TARGETID, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(blockeeUserId));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void addFriends(final List<String> userIds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_FRIENDS, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                JsonArray userIdsObj = new JsonArray();
                for (String friendUserId : userIds) {
                    userIdsObj.add(friendUserId);
                }
                form.add("user_ids", (JsonElement)userIdsObj);
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void deleteFriends(final List<String> userIds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_FRIENDS, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, List> paramsWithListValue = new HashMap<String, List>();
                paramsWithListValue.put("user_ids", userIds);
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, null, paramsWithListValue, (JsonElement)form, handler);
            }
        });
    }

    void deleteFriend(final String friendUserId, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_FRIENDS_USERID, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(friendUserId));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void uploadFriendDiscoveries(final Map<String, String> discoveries, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_FRIENDDISCOVERIES, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                JsonArray discoveriesArray = new JsonArray();
                for (String key : discoveries.keySet()) {
                    if (key == null || key.length() <= 0) continue;
                    String value = (String)discoveries.get(key);
                    JsonObject discoveryObj = new JsonObject();
                    discoveryObj.addProperty("friend_discovery_key", key);
                    discoveryObj.addProperty("friend_name", value);
                    discoveriesArray.add((JsonElement)discoveryObj);
                }
                form.add("friend_discoveries", (JsonElement)discoveriesArray);
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void deleteFriendDiscoveries(final List<String> discoveryKeys, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_FRIENDDISCOVERIES, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, List> paramsWithListValue = new HashMap<String, List>();
                paramsWithListValue.put("friend_discovery_keys", discoveryKeys);
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, null, paramsWithListValue, (JsonElement)form, handler);
            }
        });
    }

    void deleteFriendDiscovery(final String discoveryKey, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_FRIENDDISCOVERIES_DISCOVERYKEY, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(discoveryKey));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void getFriendChangeLogsByToken(final String token, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_FRIENDS_CHANGELOGS, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, String> params = new HashMap<String, String>();
                if (token != null) {
                    params.put("token", token);
                }
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void loadFriendList(final String token, final int limit, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_FRIENDS, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, String> params = new HashMap<String, String>();
                if (token != null) {
                    params.put("token", token);
                }
                params.put("limit", String.valueOf(limit));
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void loadGroupChannelMemberList(final String channelUrl, final String token, final int limit, final GroupChannelMemberListQuery.OperatorFilter operatorFilter, final GroupChannelMemberListQuery.MutedMemberFilter mutedMemberFilter, final String order, final String memberState, final String nicknameStartsWith, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MEMBERS, UrlUtil.urlEncodeUTF8(channelUrl));
                HashMap<String, String> params = new HashMap<String, String>();
                if (token != null) {
                    params.put("token", token);
                }
                params.put("limit", String.valueOf(limit));
                params.put("order", order);
                if (operatorFilter == GroupChannelMemberListQuery.OperatorFilter.ALL) {
                    params.put("operator_filter", "all");
                } else if (operatorFilter == GroupChannelMemberListQuery.OperatorFilter.OPERATOR) {
                    params.put("operator_filter", "operator");
                } else if (operatorFilter == GroupChannelMemberListQuery.OperatorFilter.NONOPERATOR) {
                    params.put("operator_filter", "nonoperator");
                }
                if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.ALL) {
                    params.put("muted_member_filter", "all");
                } else if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.MUTED) {
                    params.put("muted_member_filter", "muted");
                } else if (mutedMemberFilter == GroupChannelMemberListQuery.MutedMemberFilter.UNMUTED) {
                    params.put("muted_member_filter", "unmuted");
                }
                params.put("member_state_filter", memberState);
                if (nicknameStartsWith != null) {
                    params.put("nickname_startswith", nicknameStartsWith);
                }
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void banUser(final boolean isOpenChannel, final String channelUrl, final String userId, final String description, final int seconds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_BAN, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", userId);
                if (description != null) {
                    form.addProperty("description", description);
                }
                form.addProperty("seconds", String.valueOf(seconds));
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void unbanUser(final boolean isOpenChannel, final String channelUrl, final String userId, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_BAN_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_BAN_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void muteUser(final boolean isOpenChannel, final String channelUrl, final String userId, final String description, final Integer seconds, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MUTE, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", userId);
                if (description != null) {
                    form.addProperty("description", description);
                }
                if (seconds != null) {
                    form.addProperty("seconds", String.valueOf(seconds));
                }
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void unmuteUser(final boolean isOpenChannel, final String channelUrl, final String userId, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MUTE_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MUTE_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(userId));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void freezeGroupChannel(final String channelUrl, final boolean freeze, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_FREEZE, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("freeze", Boolean.valueOf(freeze));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getTotalUnreadMessageCount(final GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter superChannelFilter, final List<String> channelCustomTypes, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_UNREADMESSAGECOUNT, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, String> params = new HashMap<String, String>();
                if (superChannelFilter == GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter.ALL) {
                    params.put("super_mode", "all");
                } else if (superChannelFilter == GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter.SUPER_CHANNEL_ONLY) {
                    params.put("super_mode", "super");
                } else if (superChannelFilter == GroupChannelTotalUnreadMessageCountParams.SuperChannelFilter.NONSUPER_CHANNEL_ONLY) {
                    params.put("super_mode", "nonsuper");
                }
                HashMap<String, List> paramsWithListValue = new HashMap<String, List>();
                if (channelCustomTypes != null && channelCustomTypes.size() > 0) {
                    paramsWithListValue.put("custom_types", channelCustomTypes);
                }
                APIClient.this.requestGET(url, params, paramsWithListValue, handler);
            }
        });
    }

    void getUnreadItemCount(final Collection<GroupChannel.UnreadItemKey> keys, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_UNREADITEMCOUNT, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap paramsWithListValue = new HashMap();
                LinkedHashSet<String> itemKeys = new LinkedHashSet<String>();
                for (GroupChannel.UnreadItemKey key : keys) {
                    if (key == GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MESSAGE_COUNT) {
                        itemKeys.add("group_channel_unread_message_count");
                        continue;
                    }
                    if (key == GroupChannel.UnreadItemKey.GROUP_CHANNEL_UNREAD_MENTION_COUNT) {
                        itemKeys.add("group_channel_unread_mention_count");
                        continue;
                    }
                    if (key == GroupChannel.UnreadItemKey.GROUP_CHANNEL_INVITATION_COUNT) {
                        itemKeys.add("group_channel_invitation_count");
                        continue;
                    }
                    if (key == GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MESSAGE_COUNT) {
                        itemKeys.add("non_super_group_channel_unread_message_count");
                        continue;
                    }
                    if (key == GroupChannel.UnreadItemKey.SUPER_UNREAD_MESSAGE_COUNT) {
                        itemKeys.add("super_group_channel_unread_message_count");
                        continue;
                    }
                    if (key == GroupChannel.UnreadItemKey.NONSUPER_UNREAD_MENTION_COUNT) {
                        itemKeys.add("non_super_group_channel_unread_mention_count");
                        continue;
                    }
                    if (key == GroupChannel.UnreadItemKey.SUPER_UNREAD_MENTION_COUNT) {
                        itemKeys.add("super_group_channel_unread_mention_count");
                        continue;
                    }
                    if (key == GroupChannel.UnreadItemKey.NONSUPER_INVITATION_COUNT) {
                        itemKeys.add("non_super_group_channel_invitation_count");
                        continue;
                    }
                    if (key != GroupChannel.UnreadItemKey.SUPER_INVITATION_COUNT) continue;
                    itemKeys.add("super_group_channel_invitation_count");
                }
                if (itemKeys.size() > 0) {
                    paramsWithListValue.put("item_keys", itemKeys);
                }
                APIClient.this.requestGET(url, null, paramsWithListValue, handler);
            }
        });
    }

    void getTotalUnreadChannelCount(final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_UNREADCHANNELCOUNT, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void getChannelCount(final String state, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_GROUPCHANNELCOUNT, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                HashMap<String, String> params = new HashMap<String, String>();
                if (state != null) {
                    params.put("state", state);
                }
                APIClient.this.requestGET(url, params, null, handler);
            }
        });
    }

    void setDoNotDisturb(final boolean enable, final int startHour, final int startMin, final int endHour, final int endMin, final String timezone, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("do_not_disturb", Boolean.valueOf(enable));
                form.addProperty("start_hour", (Number)startHour);
                form.addProperty("start_min", (Number)startMin);
                form.addProperty("end_hour", (Number)endHour);
                form.addProperty("end_min", (Number)endMin);
                form.addProperty("timezone", timezone);
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getDoNotDisturb(final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void setSnoozePeriod(final boolean enable, final long startTs, final long endTs, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("snooze_enabled", Boolean.valueOf(enable));
                form.addProperty("snooze_start_ts", (Number)startTs);
                form.addProperty("snooze_end_ts", (Number)endTs);
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getSnoozePeriod(final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void setPushSound(final String sound, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("push_sound", sound);
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getPushSound(final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void setPushPreference(final String channelUrl, final boolean value, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("enable", Boolean.valueOf(value));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getPushPreference(final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(channelUrl));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void setMyPushTriggerOption(final String channelUrl, final GroupChannel.PushTriggerOption pushTriggerOption, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                JsonObject form = APIClient.this.defaultForm();
                if (pushTriggerOption == GroupChannel.PushTriggerOption.ALL) {
                    form.addProperty("push_trigger_option", "all");
                } else if (pushTriggerOption == GroupChannel.PushTriggerOption.OFF) {
                    form.addProperty("push_trigger_option", "off");
                } else if (pushTriggerOption == GroupChannel.PushTriggerOption.MENTION_ONLY) {
                    form.addProperty("push_trigger_option", "mention_only");
                } else if (pushTriggerOption == GroupChannel.PushTriggerOption.DEFAULT) {
                    form.addProperty("push_trigger_option", "default");
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(channelUrl));
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void getMyPushTriggerOption(final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_PUSHPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(channelUrl));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void setMyCountPreference(final String channelUrl, final GroupChannel.CountPreference preference, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_USERS_USERID_COUNTPREFERENCE_CHANNELURL, UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()), UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                if (preference != null) {
                    if (preference == GroupChannel.CountPreference.ALL) {
                        form.addProperty("count_preference", "all");
                    } else if (preference == GroupChannel.CountPreference.UNREAD_MESSAGE_COUNT_ONLY) {
                        form.addProperty("count_preference", "unread_message_count_only");
                    } else if (preference == GroupChannel.CountPreference.UNREAD_MENTION_COUNT_ONLY) {
                        form.addProperty("count_preference", "unread_mention_count_only");
                    } else if (preference == GroupChannel.CountPreference.OFF) {
                        form.addProperty("count_preference", "off");
                    }
                }
                APIClient.this.requestPUT(url, (JsonElement)form, handler);
            }
        });
    }

    void deleteMessage(final boolean isOpenChannel, final String channelUrl, final long messageId, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void deleteChannel(final boolean isOpenChannel, final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void addReaction(final boolean isOpenChannel, final String channelUrl, final long messageId, final String key, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                if (key != null) {
                    form.addProperty("reaction", key);
                }
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void deleteReaction(final boolean isOpenChannel, final String channelUrl, final long messageId, final String key, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId)) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID_REACTIONS, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("user_id", SendBird.getCurrentUser().getUserId());
                form.addProperty("msg_id", (Number)messageId);
                if (key != null) {
                    form.addProperty("reaction", key);
                }
                form.addProperty("updated_at", (Number)System.currentTimeMillis());
                APIClient.this.requestDELETE(url, (JsonElement)form, handler);
            }
        });
    }

    void queryFullTextMessageSearch(final String query, final String channelUrl, final String channelCustomType, final int limit, final Object before, final Object after, final String token, final Long messageTsFrom, final Long messageTsTo, final String order, final boolean reverse, final boolean exactMatch, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("query", query);
                if (!TextUtils.isEmpty((CharSequence)channelUrl)) {
                    params.put("channel_url", channelUrl);
                }
                if (!TextUtils.isEmpty((CharSequence)channelCustomType)) {
                    params.put("custom_type", channelCustomType);
                }
                params.put("limit", String.valueOf(limit));
                if (before != null) {
                    params.put("before", String.valueOf(before));
                }
                if (after != null) {
                    params.put("after", String.valueOf(after));
                }
                if (!TextUtils.isEmpty((CharSequence)token)) {
                    params.put("token", token);
                }
                if (messageTsFrom != null) {
                    params.put("message_ts_from", String.valueOf(messageTsFrom));
                }
                if (messageTsTo != null) {
                    params.put("message_ts_to", String.valueOf(messageTsTo));
                }
                params.put("sort_field", order);
                params.put("reverse", String.valueOf(reverse));
                params.put("exact_match", String.valueOf(exactMatch));
                APIClient.this.requestGET(APIClient.API_SEARCH_MESSAGES, params, null, handler);
            }
        });
    }

    void getMyMutedInfo(final boolean isOpenChannel, final String channelUrl, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_OPENCHANNELS_CHANNELURL_MUTE_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId())) : String.format(APIClient.API_GROUPCHANNELS_CHANNELURL_MUTE_USERID, UrlUtil.urlEncodeUTF8(channelUrl), UrlUtil.urlEncodeUTF8(SendBird.getCurrentUser().getUserId()));
                APIClient.this.requestGET(url, handler);
            }
        });
    }

    void reportChannel(final boolean isOpenChannel, final String channelUrl, final BaseChannel.ReportCategory reportCategory, final String reportDescription, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_REPORT_OPENCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl)) : String.format(APIClient.API_REPORT_GROUPCHANNELS_CHANNELURL, UrlUtil.urlEncodeUTF8(channelUrl));
                JsonObject form = APIClient.this.defaultForm();
                if (reportCategory != null) {
                    switch (reportCategory) {
                        case SUSPICIOUS: {
                            form.addProperty("report_category", "suspicious");
                            break;
                        }
                        case HARASSING: {
                            form.addProperty("report_category", "harassing");
                            break;
                        }
                        case SPAM: {
                            form.addProperty("report_category", "spam");
                            break;
                        }
                        case INAPPROPRIATE: {
                            form.addProperty("report_category", "inappropriate");
                        }
                    }
                }
                if (reportDescription != null) {
                    form.addProperty("report_description", reportDescription);
                }
                form.addProperty("reporting_user_id", SendBird.getCurrentUser().getUserId());
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void reportUser(final boolean isOpenChannel, final String channelUrl, final String offendingUserId, final BaseChannel.ReportCategory reportCategory, final String reportDescription, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = String.format(APIClient.API_REPORT_USERS_OFFENDINGUSERID, UrlUtil.urlEncodeUTF8(offendingUserId));
                JsonObject form = APIClient.this.defaultForm();
                form.addProperty("channel_type", isOpenChannel ? "open_channels" : "group_channels");
                if (channelUrl != null) {
                    form.addProperty("channel_url", channelUrl);
                }
                if (reportCategory != null) {
                    switch (reportCategory) {
                        case SUSPICIOUS: {
                            form.addProperty("report_category", "suspicious");
                            break;
                        }
                        case HARASSING: {
                            form.addProperty("report_category", "harassing");
                            break;
                        }
                        case SPAM: {
                            form.addProperty("report_category", "spam");
                            break;
                        }
                        case INAPPROPRIATE: {
                            form.addProperty("report_category", "inappropriate");
                        }
                    }
                }
                if (reportDescription != null) {
                    form.addProperty("report_description", reportDescription);
                }
                form.addProperty("reporting_user_id", SendBird.getCurrentUser().getUserId());
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    void reportMessage(final boolean isOpenChannel, final String channelUrl, final String offendingUserId, final long messageId, final BaseChannel.ReportCategory reportCategory, final String reportDescription, final APIClientHandler handler) {
        ConnectionManager.ready(true, new ConnectionManager.ReadyHandler(){

            @Override
            public void onReady(User user, boolean reconnected, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        handler.onResult(null, ConnectionManager.getConnectionRequiredException());
                    }
                    return;
                }
                String url = isOpenChannel ? String.format(APIClient.API_REPORT_OPENCHANNELS_CHANNELURL_MESSAGES_MESSAGEID, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId)) : String.format(APIClient.API_REPORT_GROUPCHANNELS_CHANNELURL_MESSAGES_MESSAGEID, UrlUtil.urlEncodeUTF8(channelUrl), Long.toString(messageId));
                JsonObject form = APIClient.this.defaultForm();
                if (offendingUserId != null) {
                    form.addProperty("offending_user_id", offendingUserId);
                }
                if (reportCategory != null) {
                    switch (reportCategory) {
                        case SUSPICIOUS: {
                            form.addProperty("report_category", "suspicious");
                            break;
                        }
                        case HARASSING: {
                            form.addProperty("report_category", "harassing");
                            break;
                        }
                        case SPAM: {
                            form.addProperty("report_category", "spam");
                            break;
                        }
                        case INAPPROPRIATE: {
                            form.addProperty("report_category", "inappropriate");
                        }
                    }
                }
                if (reportDescription != null) {
                    form.addProperty("report_description", reportDescription);
                }
                form.addProperty("reporting_user_id", SendBird.getCurrentUser().getUserId());
                APIClient.this.requestPOST(url, (JsonElement)form, handler);
            }
        });
    }

    synchronized void setSessionKey(String sessionKey) {
        if (sessionKey == null) {
            return;
        }
        if (this.mSessionKey == null || !this.mSessionKey.equals(sessionKey)) {
            this.mSessionKey = sessionKey;
            User user = SendBird.getCurrentUser();
            if (user != null) {
                KeyStore.saveSessionKey(user.getUserId(), sessionKey);
            } else {
                KeyStore.clearAll();
            }
        }
    }

    synchronized void setEKey(String encryptionKey) {
        if (encryptionKey == null) {
            return;
        }
        this.mEKey = encryptionKey;
    }

    synchronized String getSessionKey() {
        if (TextUtils.isEmpty((CharSequence)this.mSessionKey)) {
            this.mSessionKey = KeyStore.getSessionKey();
        }
        return this.mSessionKey;
    }

    synchronized String getEKey() {
        return this.mEKey;
    }

    public void makeDummyCallToKeepConnectionAlive(String url) {
        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(url).build();
        this.newCall(request, false, null);
    }

    private void requestGET(String url, APIClientHandler handler) {
        this.requestGET(url, null, null, handler);
    }

    private void requestGET(final String url, final Map<String, String> params, final Map<String, Collection<String>> paramsWithListValue, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String queryUrl = APIClient.this.getQueryUrl(apiHost, url, params, paramsWithListValue);
                        Logger.d("GET: " + queryUrl);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.getSessionKey()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(queryUrl).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestPOST(final String url, final JsonElement form, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    Logger.d("POST: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create((MediaType)MIME_JSON, (String)formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.getSessionKey()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(apiHost + url).post(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestPOST(final String url, final Map<String, String> form, final String fieldFilename, final File file, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block7: {
                    Logger.d("POST: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    ArrayList<Headers> partHeaders = new ArrayList<Headers>();
                    ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
                    try {
                        for (Map.Entry content : form.entrySet()) {
                            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"", content.getKey())}));
                            partBodies.add(RequestBody.create(null, (String)((String)content.getValue())));
                        }
                        if (fieldFilename != null && file != null) {
                            String fileMime = APIClient.checkMimeType(file, null, handler);
                            if (fileMime == null) {
                                return;
                            }
                            MediaType MIME_FILE = MediaType.parse((String)fileMime);
                            Logger.d("File: " + file);
                            Logger.d("Mime: " + fileMime);
                            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", fieldFilename, URLEncoder.encode(file.getName(), "UTF-8")), "Content-Transfer-Encoding", "binary"}));
                            partBodies.add(RequestBody.create((MediaType)MIME_FILE, (File)file));
                        }
                        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, null, null);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.getSessionKey()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(apiHost + url).post((RequestBody)body).build();
                        APIClient.this.newCall(request, fieldFilename != null && file != null, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block7;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestFILE(final String url, final File file, final String mimeType, final List<FileMessage.ThumbnailSize> thumbnailSizes, final String channelUrl, final String requestId, final APIClientProgressHandler progressHandler, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block8: {
                    Logger.d("FILE: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String fileMime = APIClient.checkMimeType(file, mimeType, handler);
                        if (fileMime == null) {
                            return;
                        }
                        MediaType MIME_FILE = MediaType.parse((String)fileMime);
                        MediaType textMime = MediaType.parse((String)"text/plain");
                        Logger.d("File: " + file);
                        Logger.d("Mime: " + fileMime);
                        ArrayList<Headers> partHeaders = new ArrayList<Headers>();
                        ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
                        partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"file\"; filename=\"" + URLEncoder.encode(file.getName(), "UTF-8") + "\"", "Content-Transfer-Encoding", "binary"}));
                        partBodies.add(RequestBody.create((MediaType)MIME_FILE, (File)file));
                        if (thumbnailSizes != null) {
                            int idx = 1;
                            for (FileMessage.ThumbnailSize thumbnailSize : thumbnailSizes) {
                                partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"thumbnail" + idx + "\""}));
                                partBodies.add(RequestBody.create((MediaType)textMime, (String)(thumbnailSize.getMaxWidth() + "," + thumbnailSize.getMaxHeight())));
                                ++idx;
                            }
                        }
                        if (channelUrl != null) {
                            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", "form-data; name=\"channel_url\""}));
                            partBodies.add(RequestBody.create((MediaType)textMime, (String)channelUrl));
                        }
                        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, progressHandler, requestId);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.getSessionKey()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(apiHost + url).post((RequestBody)body).build();
                        APIClient.this.newCall(request, true, requestId, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block8;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    static String checkMimeType(File file, String mimeType, APIClientHandler handler) {
        String fileMime;
        try {
            fileMime = mimeType != null && mimeType.length() > 0 ? mimeType : file.toURI().toURL().openConnection().getContentType();
        }
        catch (IOException e) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
            }
            return null;
        }
        catch (StringIndexOutOfBoundsException e2) {
            fileMime = "application/octet-stream";
        }
        return fileMime;
    }

    private void requestPUT(final String url, final JsonElement form, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    Logger.d("PUT: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create((MediaType)MIME_JSON, (String)formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.getSessionKey()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(apiHost + url).put(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestPUT(final String url, final Map<String, String> form, final String fieldFilename, final File file, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block7: {
                    Logger.d("PUT: " + apiHost + url);
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    ArrayList<Headers> partHeaders = new ArrayList<Headers>();
                    ArrayList<RequestBody> partBodies = new ArrayList<RequestBody>();
                    try {
                        for (Map.Entry content : form.entrySet()) {
                            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"", content.getKey())}));
                            partBodies.add(RequestBody.create(null, (String)((String)content.getValue())));
                        }
                        if (fieldFilename != null && file != null) {
                            String fileMime = APIClient.checkMimeType(file, null, handler);
                            if (fileMime == null) {
                                return;
                            }
                            MediaType MIME_FILE = MediaType.parse((String)fileMime);
                            Logger.d("File: " + file);
                            Logger.d("Mime: " + fileMime);
                            partHeaders.add(Headers.of((String[])new String[]{"Content-Disposition", String.format("form-data; name=\"%s\"; filename=\"%s\"", fieldFilename, URLEncoder.encode(file.getName(), "UTF-8")), "Content-Transfer-Encoding", "binary"}));
                            partBodies.add(RequestBody.create((MediaType)MIME_FILE, (File)file));
                        }
                        FixedLengthMultipartRequestBody body = new FixedLengthMultipartRequestBody(partHeaders, partBodies, null, null);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.getSessionKey()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(apiHost + url).put((RequestBody)body).build();
                        APIClient.this.newCall(request, fieldFilename != null && file != null, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block7;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private void requestDELETE(String url, JsonElement form, APIClientHandler handler) {
        this.requestDELETE(url, null, null, form, handler);
    }

    private void requestDELETE(final String url, final Map<String, String> params, final Map<String, Collection<String>> paramsWithListValue, final JsonElement form, final APIClientHandler handler) {
        if (this.getSessionKey() == null || this.getSessionKey().length() == 0) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("Connection must be made.", 800101));
            }
            return;
        }
        this.checkRouting(new CheckRouting.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block4: {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    try {
                        String queryUrl = APIClient.this.getQueryUrl(apiHost, url, params, paramsWithListValue);
                        Logger.d("DELETE: " + queryUrl);
                        String formJson = sGson.toJson(form);
                        Logger.d("API request: " + formJson);
                        RequestBody body = RequestBody.create((MediaType)MIME_JSON, (String)formJson);
                        Request request = new Request.Builder().header("Accept", "application/json").header("User-Agent", "Jand/" + SendBird.getSDKVersion()).header("SendBird", "Android," + SendBird.getOSVersion() + "," + SendBird.getSDKVersion() + "," + SendBird.getApplicationId()).header("Connection", "keep-alive").header("Session-Key", APIClient.this.getSessionKey()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(queryUrl).delete(body).build();
                        APIClient.this.newCall(request, false, handler);
                    }
                    catch (Exception e1) {
                        if (handler == null) break block4;
                        handler.onResult(null, new SendBirdException(e1.getMessage(), 800220));
                    }
                }
            }
        });
    }

    private synchronized void newCall(Request request, boolean waitLong, final APIClientHandler handler) {
        OkHttpClient client = waitLong ? this.mOkHttpClientLong : this.mOkHttpClient;
        client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                if (handler != null) {
                    handler.onResult(null, new SendBirdException(e.getMessage(), 800120));
                }
            }

            public void onResponse(Call call, Response response) throws IOException {
                block6: {
                    if (response.code() == 500 && handler != null) {
                        handler.onResult(null, new SendBirdException(response.message(), 500901));
                        return;
                    }
                    try {
                        JsonElement result = APIClient.processResponse(response);
                        if (handler != null) {
                            handler.onResult(result, null);
                        }
                    }
                    catch (SendBirdException e) {
                        Logger.d(e);
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                    }
                    catch (Exception e) {
                        Logger.d(e);
                        if (handler == null) break block6;
                        handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void newCall(Request request, boolean waitLong, final String requestId, final APIClientHandler handler) {
        OkHttpClient client = waitLong ? this.mOkHttpClientLong : this.mOkHttpClient;
        Call call = client.newCall(request);
        call.enqueue(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onFailure(Call call, IOException e) {
                Object object = APIClient.this.mOngoingRequestsLock;
                synchronized (object) {
                    if (handler != null) {
                        if (APIClient.this.mOngoingRequestsMap.containsKey(requestId)) {
                            handler.onResult(null, new SendBirdException(e.getMessage(), 800120));
                        } else {
                            handler.onResult(null, new SendBirdException(e.getMessage(), 800240));
                        }
                    }
                }
                object = APIClient.this.mOngoingRequestsLock;
                synchronized (object) {
                    APIClient.this.mOngoingRequestsMap.remove(requestId);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onResponse(Call call, Response response) throws IOException {
                block9: {
                    Object object = APIClient.this.mOngoingRequestsLock;
                    synchronized (object) {
                        APIClient.this.mOngoingRequestsMap.remove(requestId);
                    }
                    if (response.code() == 500 && handler != null) {
                        handler.onResult(null, new SendBirdException(response.message(), 500901));
                        return;
                    }
                    try {
                        JsonElement result = APIClient.processResponse(response);
                        if (handler != null) {
                            handler.onResult(result, null);
                        }
                    }
                    catch (SendBirdException e) {
                        Logger.d(e);
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                    }
                    catch (Exception e) {
                        Logger.d(e);
                        if (handler == null) break block9;
                        handler.onResult(null, new SendBirdException(e.getMessage(), 800220));
                    }
                }
            }
        });
        if (requestId != null) {
            Object object = this.mOngoingRequestsLock;
            synchronized (object) {
                this.mOngoingRequestsMap.put(requestId, call);
            }
        }
    }

    protected static JsonElement processResponse(Response response) throws SendBirdException {
        JsonElement json;
        String body;
        try {
            body = response.body().string();
            String tlsVersion = "";
            if (response.handshake() != null) {
                tlsVersion = "(" + response.handshake().tlsVersion().javaName() + ")";
            }
            Logger.d("API response" + tlsVersion + ": " + body);
        }
        catch (IOException e) {
            throw new SendBirdException(e.getMessage(), 800130);
        }
        if (body == null || body.length() <= 0) {
            return JsonNull.INSTANCE;
        }
        try {
            json = new JsonParser().parse(body);
        }
        catch (Exception e) {
            throw new SendBirdException(e.getMessage(), 800130);
        }
        if (!response.isSuccessful() && json.isJsonObject() && json.getAsJsonObject().has("error") && json.getAsJsonObject().get("error").isJsonPrimitive() && json.getAsJsonObject().get("error").getAsBoolean()) {
            String message = "";
            int code = 0;
            if (json.getAsJsonObject().has("message") && json.getAsJsonObject().get("message").isJsonPrimitive()) {
                message = json.getAsJsonObject().get("message").getAsString();
            }
            if (json.getAsJsonObject().has("code") && json.getAsJsonObject().get("code").isJsonPrimitive()) {
                code = json.getAsJsonObject().get("code").getAsInt();
            }
            throw new SendBirdException(message, code);
        }
        return json;
    }

    private String getQueryString(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return sb.toString();
    }

    private String getQueryUrl(String apiHost, String url, Map<String, String> params, Map<String, Collection<String>> paramsWithListValue) {
        String queryUrl;
        Object value;
        String key;
        HashMap<String, String> paramsAll = new HashMap<String, String>();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                key = entry.getKey();
                value = (String)entry.getValue();
                paramsAll.put(UrlUtil.urlEncodeUTF8(key), UrlUtil.urlEncodeUTF8((String)value));
            }
        }
        if (paramsWithListValue != null && paramsWithListValue.size() > 0) {
            for (Map.Entry<String, Object> entry : paramsWithListValue.entrySet()) {
                key = entry.getKey();
                value = (Collection)entry.getValue();
                paramsAll.put(UrlUtil.urlEncodeUTF8(key), UrlUtil.urlEncodeUTF8((Collection<String>)value));
            }
        }
        if (paramsAll.size() > 0) {
            String query = this.getQueryString(paramsAll);
            queryUrl = apiHost + url + "?" + query;
        } else {
            queryUrl = apiHost + url;
        }
        return queryUrl;
    }

    protected void checkRouting(CheckRouting.CheckRoutingHandler handler) {
        CheckRouting.check(this.mOkHttpClient, handler);
    }

    protected void initCheckRouting() {
        CheckRouting.init();
    }

    protected static class CheckRouting {
        private static CheckRouting sInstance;
        private static Object sLock;
        private String mAPIHost;
        private String mWSHost;
        private long mRoutingUpdatedAt = 0L;

        protected CheckRouting() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void check(OkHttpClient okHttpClient, CheckRoutingHandler handler) {
            Object object = sLock;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new CheckRouting();
                    sInstance.getHostsFromPref();
                }
            }
            sInstance.run(okHttpClient, handler);
        }

        static void init() {
            SendBird.getInstance().setAPIHostToPref(null);
            SendBird.getInstance().setWSHostToPref(null);
            if (sInstance != null) {
                sInstance.getHostsFromPref();
            }
        }

        private void getHostsFromPref() {
            this.mAPIHost = SendBird.getInstance().getAPIHostFromPref();
            this.mWSHost = SendBird.getInstance().getWSHostFromPref();
        }

        private void setHostsToPref() {
            SendBird.getInstance().setAPIHostToPref(this.mAPIHost);
            SendBird.getInstance().setWSHostToPref(this.mWSHost);
        }

        private boolean checkHosts() {
            return this.mAPIHost != null && this.mAPIHost.length() > 0 && this.mWSHost != null && this.mWSHost.length() > 0;
        }

        private void run(OkHttpClient okHttpClient, CheckRoutingHandler handler) {
            if (SendBird.getApplicationId() == null || SendBird.getApplicationId().length() == 0) {
                if (handler != null) {
                    handler.onResult(null, null, new SendBirdException("Application ID is not set. Initialize SendBird class.", 800100));
                }
                return;
            }
            if (SendBird.CUSTOM_WS_HOST != null && SendBird.CUSTOM_API_HOST != null) {
                if (handler != null) {
                    handler.onResult(SendBird.CUSTOM_API_HOST, SendBird.CUSTOM_WS_HOST, null);
                }
                return;
            }
            String apiHost = "https://api-" + SendBird.getApplicationId() + ".sendbird.com";
            String wsHost = "wss://ws-" + SendBird.getApplicationId() + ".sendbird.com";
            if (handler != null) {
                handler.onResult(apiHost, wsHost, null);
            }
        }

        static {
            sLock = new Object();
        }

        public static interface CheckRoutingHandler {
            public void onResult(String var1, String var2, SendBirdException var3);
        }
    }

    static final class FixedLengthMultipartRequestBody
    extends RequestBody {
        private static final MediaType FORM = MediaType.parse((String)"multipart/form-data");
        private static final byte[] COLONSPACE = new byte[]{58, 32};
        private static final byte[] CRLF = new byte[]{13, 10};
        private static final byte[] DASHDASH = new byte[]{45, 45};
        private final ByteString boundary = ByteString.encodeUtf8((String)UUID.randomUUID().toString());
        private final MediaType contentType = MediaType.parse((String)(FORM + "; boundary=" + this.boundary.utf8()));
        private final List<Headers> partHeaders;
        private final List<RequestBody> partBodies;
        private long totalSent;
        private long totalToSend;
        private final APIClientProgressHandler progressHandler;
        private final String requestId;

        FixedLengthMultipartRequestBody(List<Headers> partHeaders, List<RequestBody> partBodies, APIClientProgressHandler progressHandler, String requestId) {
            this.partHeaders = Util.immutableList(partHeaders);
            this.partBodies = Util.immutableList(partBodies);
            this.totalSent = 0L;
            this.totalToSend = 0L;
            this.progressHandler = progressHandler;
            this.requestId = requestId;
        }

        public MediaType contentType() {
            return this.contentType;
        }

        public long contentLength() throws IOException {
            int length = 0;
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                long contentLength = body.contentLength();
                if (contentLength == -1L) {
                    return -1L;
                }
                length += DASHDASH.length + this.boundary.size() + CRLF.length;
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        length += headers.name(h).getBytes("UTF-8").length + COLONSPACE.length + headers.value(h).getBytes("UTF-8").length + CRLF.length;
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    length += "Content-Type: ".getBytes("UTF-8").length + contentType.toString().getBytes("UTF-8").length + CRLF.length;
                }
                length += "Content-Length: ".getBytes("UTF-8").length + Long.toString(contentLength).getBytes("UTF-8").length + CRLF.length;
                length = (int)((long)length + ((long)CRLF.length + contentLength + (long)CRLF.length));
            }
            this.totalToSend = length += DASHDASH.length + this.boundary.size() + DASHDASH.length + CRLF.length;
            return length;
        }

        public void writeTo(BufferedSink sink) throws IOException {
            ForwardingSink forwardingSink = new ForwardingSink((Sink)sink){

                public void write(Buffer source, long byteCount) throws IOException {
                    super.write(source, byteCount);
                    FixedLengthMultipartRequestBody.this.totalSent = FixedLengthMultipartRequestBody.this.totalSent + byteCount;
                    if (FixedLengthMultipartRequestBody.this.progressHandler != null) {
                        FixedLengthMultipartRequestBody.this.progressHandler.onProgress(FixedLengthMultipartRequestBody.this.requestId, byteCount, FixedLengthMultipartRequestBody.this.totalSent, FixedLengthMultipartRequestBody.this.totalToSend);
                    }
                }
            };
            BufferedSink bufferedSink = Okio.buffer((Sink)forwardingSink);
            int partCount = this.partHeaders.size();
            for (int p = 0; p < partCount; ++p) {
                long contentLength;
                MediaType contentType;
                Headers headers = this.partHeaders.get(p);
                RequestBody body = this.partBodies.get(p);
                bufferedSink.write(DASHDASH);
                bufferedSink.write(this.boundary);
                bufferedSink.write(CRLF);
                if (headers != null) {
                    int headerCount = headers.size();
                    for (int h = 0; h < headerCount; ++h) {
                        bufferedSink.writeUtf8(headers.name(h)).write(COLONSPACE).writeUtf8(headers.value(h)).write(CRLF);
                    }
                }
                if ((contentType = body.contentType()) != null) {
                    bufferedSink.writeUtf8("Content-Type: ").writeUtf8(contentType.toString()).write(CRLF);
                }
                if ((contentLength = body.contentLength()) != -1L) {
                    bufferedSink.writeUtf8("Content-Length: ").writeUtf8(Long.toString(contentLength)).write(CRLF);
                }
                bufferedSink.write(CRLF);
                body.writeTo(bufferedSink);
                bufferedSink.write(CRLF);
            }
            bufferedSink.write(DASHDASH);
            bufferedSink.write(this.boundary);
            bufferedSink.write(DASHDASH);
            bufferedSink.write(CRLF);
            bufferedSink.flush();
        }
    }

    static class UrlUtil {
        UrlUtil() {
        }

        static String urlEncodeUTF8(String s) {
            String result = null;
            if (s != null) {
                try {
                    result = URLEncoder.encode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new UnsupportedOperationException(e);
                }
            }
            return result;
        }

        static String urlEncodeUTF8(Collection<String> strList) {
            String result = null;
            if (strList != null && strList.size() > 0) {
                StringBuilder sb = new StringBuilder();
                String separator = "";
                for (String str : strList) {
                    sb.append(separator);
                    separator = ",";
                    sb.append(UrlUtil.urlEncodeUTF8(str));
                }
                result = sb.toString();
            }
            return result;
        }
    }

    public static interface APIClientProgressHandler {
        public void onProgress(String var1, long var2, long var4, long var6);
    }

    public static interface APIClientHandler {
        public void onResult(JsonElement var1, SendBirdException var2);
    }
}

