/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseMessageParams;
import com.sendbird.android.FileMessage;
import com.sendbird.android.HashUtils;
import com.sendbird.android.MessageMetaArray;
import com.sendbird.android.Reaction;
import com.sendbird.android.ReactionEvent;
import com.sendbird.android.SendBird;
import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.log.Logger;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class BaseMessage {
    protected static final Set<Integer> RESENDABLE_ERROR_CODES = new HashSet<Integer>(Arrays.asList(800101, 800120, 800180, 800200, 800210));
    protected long mMessageId;
    protected String mChannelUrl;
    protected String mChannelType;
    protected String mData = "";
    protected String mCustomType = "";
    protected long mCreatedAt;
    protected long mUpdatedAt;
    protected BaseMessageParams.MentionType mMentionType = BaseMessageParams.MentionType.USERS;
    protected List<String> mMentionedUserIds;
    protected List<User> mMentionedUsers;
    protected List<MessageMetaArray> mMetaArrays;
    protected boolean mIsGlobalBlocked;
    protected int mErrorCode = 0;
    private boolean mIsSilent = false;
    private boolean forceUpdateLastMessage = false;
    private final Map<String, Reaction> reactionMap = new ConcurrentHashMap<String, Reaction>();

    public abstract String getRequestId();

    public abstract String getMessage();

    public abstract Sender getSender();

    public boolean isResendable() {
        return false;
    }

    protected static BaseMessage build(JsonElement el, String channelUrl, String channelType) {
        try {
            String type;
            JsonObject obj = el.getAsJsonObject();
            switch (type = obj.get("type").getAsString()) {
                case "MESG": {
                    String mentionTypeString;
                    String reqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
                    UserMessage.RequestState requestState = UserMessage.RequestState.SUCCEEDED;
                    if (obj.has("request_state")) {
                        String requestStateString = obj.get("request_state").getAsString();
                        if (requestStateString.equals("none")) {
                            requestState = UserMessage.RequestState.NONE;
                        } else if (requestStateString.equals("pending")) {
                            requestState = UserMessage.RequestState.PENDING;
                        } else if (requestStateString.equals("failed")) {
                            requestState = UserMessage.RequestState.FAILED;
                        } else if (requestStateString.equals("succeeded")) {
                            requestState = UserMessage.RequestState.SUCCEEDED;
                        }
                    }
                    Sender sender = new Sender(obj.get("user"));
                    long msgId = obj.has("message_id") ? obj.get("message_id").getAsLong() : 0L;
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String translations = obj.has("translations") ? obj.get("translations").toString() : null;
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String reactions = obj.has("reactions") ? obj.get("reactions").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    String metaArrayKeyOrder = obj.has("metaarray_key_order") ? obj.get("metaarray_key_order").toString() : null;
                    String sortedMetaArray = obj.has("sorted_metaarray") ? obj.get("sorted_metaarray").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    int errorCode = obj.has("error_code") ? obj.get("error_code").getAsInt() : 0;
                    boolean isSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
                    boolean forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
                    return new UserMessage(UserMessage.build(reqId, requestState, msgId, sender, channelUrl, channelType, message, data, customType, translations, createdAt, updatedAt, mentionType, null, mentionedUsers, reactions, metaArray, metaArrayKeyOrder, sortedMetaArray, isGlobalBlocked, errorCode, isSilent, forceUpdateLastMessage));
                }
                case "FILE": {
                    String mentionTypeString;
                    String reqId = obj.has("req_id") ? obj.get("req_id").getAsString() : "";
                    FileMessage.RequestState requestState = FileMessage.RequestState.SUCCEEDED;
                    if (obj.has("request_state")) {
                        String requestStateString = obj.get("request_state").getAsString();
                        if (requestStateString.equals("none")) {
                            requestState = FileMessage.RequestState.NONE;
                        } else if (requestStateString.equals("pending")) {
                            requestState = FileMessage.RequestState.PENDING;
                        } else if (requestStateString.equals("failed")) {
                            requestState = FileMessage.RequestState.FAILED;
                        } else if (requestStateString.equals("succeeded")) {
                            requestState = FileMessage.RequestState.SUCCEEDED;
                        }
                    }
                    Sender sender = new Sender(obj.get("user"));
                    long msgId = obj.get("message_id").getAsLong();
                    JsonObject file = obj.get("file").getAsJsonObject();
                    String url = file.get("url").getAsString();
                    String name = file.get("name").getAsString();
                    String fileType = file.get("type").getAsString();
                    int size = file.get("size").getAsInt();
                    String data = file.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    String thumbnails = obj.has("thumbnails") ? obj.get("thumbnails").toString() : null;
                    boolean requireAuth = obj.has("require_auth") && obj.get("require_auth").getAsBoolean();
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String reactions = obj.has("reactions") ? obj.get("reactions").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    String metaArrayKeyOrder = obj.has("metaarray_key_order") ? obj.get("metaarray_key_order").toString() : null;
                    String sortedMetaArray = obj.has("sorted_metaarray") ? obj.get("sorted_metaarray").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    int errorCode = obj.has("error_code") ? obj.get("error_code").getAsInt() : 0;
                    boolean isSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
                    boolean forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
                    return new FileMessage(FileMessage.build(reqId, requestState, msgId, sender, channelUrl, channelType, url, name, fileType, size, data, customType, thumbnails, requireAuth, createdAt, updatedAt, mentionType, null, mentionedUsers, reactions, metaArray, metaArrayKeyOrder, sortedMetaArray, isGlobalBlocked, errorCode, isSilent, forceUpdateLastMessage));
                }
                case "BRDM": 
                case "ADMM": {
                    String mentionTypeString;
                    long msgId = obj.get("message_id").getAsLong();
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    long updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
                    String customType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
                    BaseMessageParams.MentionType mentionType = BaseMessageParams.MentionType.USERS;
                    if (obj.has("mention_type") && (mentionTypeString = obj.get("mention_type").getAsString()) != null) {
                        if (mentionTypeString.equals("users")) {
                            mentionType = BaseMessageParams.MentionType.USERS;
                        } else if (mentionTypeString.equals("channel")) {
                            mentionType = BaseMessageParams.MentionType.CHANNEL;
                        }
                    }
                    String mentionedUsers = obj.has("mentioned_users") ? obj.get("mentioned_users").toString() : null;
                    String reactions = obj.has("reactions") ? obj.get("reactions").toString() : null;
                    String metaArray = obj.has("metaarray") ? obj.get("metaarray").toString() : null;
                    String metaArrayKeyOrder = obj.has("metaarray_key_order") ? obj.get("metaarray_key_order").toString() : null;
                    boolean isGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
                    boolean isSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
                    boolean forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
                    return new AdminMessage(AdminMessage.build(msgId, channelUrl, channelType, message, data, customType, createdAt, updatedAt, mentionType, null, mentionedUsers, reactions, metaArray, metaArrayKeyOrder, isGlobalBlocked, isSilent, forceUpdateLastMessage));
                }
            }
            Logger.e("Unknown message type: " + type);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        return null;
    }

    public BaseMessage(String channelUrl, long msgId, long createdAt) {
        this.mChannelUrl = channelUrl;
        this.mMessageId = msgId;
        this.mCreatedAt = createdAt;
    }

    protected BaseMessage(JsonElement el) {
        int i;
        JsonArray array;
        JsonObject obj = el.getAsJsonObject();
        this.mMessageId = obj.has("msg_id") ? obj.get("msg_id").getAsLong() : 0L;
        this.mChannelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.mChannelType = obj.has("channel_type") ? obj.get("channel_type").getAsString() : "group";
        this.mCreatedAt = obj.has("ts") ? obj.get("ts").getAsLong() : 0L;
        long l = this.mUpdatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
        if (obj.has("mention_type")) {
            String mentionType = obj.get("mention_type").getAsString();
            if (mentionType.equals("users")) {
                this.mMentionType = BaseMessageParams.MentionType.USERS;
            } else if (mentionType.equals("channel")) {
                this.mMentionType = BaseMessageParams.MentionType.CHANNEL;
            }
        }
        this.mMentionedUserIds = new ArrayList<String>();
        if (obj.has("mentioned_user_ids")) {
            array = obj.getAsJsonArray("mentioned_user_ids");
            for (i = 0; i < array.size(); ++i) {
                if (array.get(i) == null) continue;
                this.mMentionedUserIds.add(array.get(i).getAsString());
            }
        }
        this.mMentionedUsers = new ArrayList<User>();
        if (obj.has("mentioned_users")) {
            array = obj.getAsJsonArray("mentioned_users");
            for (i = 0; i < array.size(); ++i) {
                this.mMentionedUsers.add(new User(array.get(i)));
            }
        }
        if (obj.has("reactions")) {
            array = obj.getAsJsonArray("reactions");
            for (i = 0; i < array.size(); ++i) {
                Reaction reaction = new Reaction(array.get(i));
                if (reaction.getUserIds().size() <= 0) continue;
                this.addReaction(reaction);
            }
        }
        this.mMetaArrays = new ArrayList<MessageMetaArray>();
        if (obj.has("metaarray")) {
            HashMap<String, MessageMetaArray> metaArrayMap = new HashMap<String, MessageMetaArray>();
            JsonObject metaArrayObj = obj.getAsJsonObject("metaarray");
            for (String key : metaArrayObj.keySet()) {
                if (key == null) continue;
                ArrayList<String> values = new ArrayList<String>();
                JsonArray array2 = metaArrayObj.get(key).getAsJsonArray();
                for (int i2 = 0; i2 < array2.size(); ++i2) {
                    String value = array2.get(i2).getAsString();
                    values.add(value);
                }
                metaArrayMap.put(key, new MessageMetaArray(key, values));
            }
            if (obj.has("metaarray_key_order")) {
                JsonArray metaArrayKeyOrderArray = obj.getAsJsonArray("metaarray_key_order");
                for (int i3 = 0; i3 < metaArrayKeyOrderArray.size(); ++i3) {
                    String orderedKey = metaArrayKeyOrderArray.get(i3).getAsString();
                    if (!metaArrayMap.containsKey(orderedKey)) continue;
                    this.mMetaArrays.add((MessageMetaArray)metaArrayMap.get(orderedKey));
                }
            } else {
                this.mMetaArrays.addAll(metaArrayMap.values());
            }
        } else if (obj.has("sorted_metaarray")) {
            JsonArray sortedMetaArray = obj.get("sorted_metaarray").getAsJsonArray();
            for (i = 0; i < sortedMetaArray.size(); ++i) {
                JsonArray valueArray;
                JsonObject metaArrayObj = sortedMetaArray.get(i).getAsJsonObject();
                String key = metaArrayObj.has("key") ? metaArrayObj.get("key").getAsString() : null;
                JsonArray jsonArray = valueArray = metaArrayObj.has("value") ? metaArrayObj.get("value").getAsJsonArray() : null;
                if (key == null) continue;
                ArrayList<String> value = new ArrayList<String>();
                if (valueArray != null) {
                    for (int j = 0; j < valueArray.size(); ++j) {
                        value.add(valueArray.get(j).getAsString());
                    }
                }
                this.mMetaArrays.add(new MessageMetaArray(key, value));
            }
        }
        this.mIsGlobalBlocked = obj.has("is_global_block") && obj.get("is_global_block").getAsBoolean();
        this.mIsSilent = obj.has("silent") && obj.get("silent").getAsBoolean();
        this.forceUpdateLastMessage = obj.has("force_update_last_message") && obj.get("force_update_last_message").getAsBoolean();
    }

    JsonElement toJson() {
        JsonArray array;
        JsonObject obj = new JsonObject();
        obj.addProperty("message_id", (Number)this.mMessageId);
        obj.addProperty("channel_url", this.mChannelUrl);
        obj.addProperty("channel_type", this.mChannelType);
        obj.addProperty("created_at", (Number)this.mCreatedAt);
        obj.addProperty("updated_at", (Number)this.mUpdatedAt);
        if (this.mMentionType == BaseMessageParams.MentionType.USERS) {
            obj.addProperty("mention_type", "users");
        } else if (this.mMentionType == BaseMessageParams.MentionType.CHANNEL) {
            obj.addProperty("mention_type", "channel");
        }
        if (this.mMentionedUserIds != null && this.mMentionedUserIds.size() > 0) {
            array = new JsonArray();
            for (String mentionedUserId : this.mMentionedUserIds) {
                if (mentionedUserId == null) continue;
                array.add(mentionedUserId);
            }
            obj.add("mentioned_user_ids", (JsonElement)array);
        }
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            array = new JsonArray();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null) continue;
                array.add(mentionedUser.toJson());
            }
            obj.add("mentioned_users", (JsonElement)array);
        }
        if (this.reactionMap.size() > 0) {
            array = new JsonArray();
            for (Reaction reaction : this.reactionMap.values()) {
                if (reaction == null) continue;
                array.add(reaction.toJson());
            }
            obj.add("reactions", (JsonElement)array);
        }
        if (this.mMetaArrays != null && this.mMetaArrays.size() > 0) {
            JsonArray sortedMetaArray = new JsonArray();
            for (MessageMetaArray metaArray : this.mMetaArrays) {
                sortedMetaArray.add((JsonElement)metaArray.toJson());
            }
            obj.add("sorted_metaarray", (JsonElement)sortedMetaArray);
        }
        obj.addProperty("is_global_block", Boolean.valueOf(this.mIsGlobalBlocked));
        obj.addProperty("silent", Boolean.valueOf(this.mIsSilent));
        obj.addProperty("force_update_last_message", Boolean.valueOf(this.forceUpdateLastMessage));
        return obj;
    }

    public static BaseMessage buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            JsonObject obj = new JsonParser().parse(str).getAsJsonObject();
            return BaseMessage.build((JsonElement)obj, obj.get("channel_url").getAsString(), obj.get("channel_type").getAsString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long getMessageId() {
        return this.mMessageId;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public long getUpdatedAt() {
        return this.mUpdatedAt;
    }

    public BaseMessageParams.MentionType getMentionType() {
        return this.mMentionType;
    }

    public List<User> getMentionedUsers() {
        return this.mMentionedUsers;
    }

    List<String> getMentionedUserIds() {
        ArrayList<String> mentionedUserIds = null;
        if (this instanceof UserMessage && ((UserMessage)this).getRequestState() != UserMessage.RequestState.SUCCEEDED && this.mMentionedUserIds != null && this.mMentionedUserIds.size() > 0) {
            mentionedUserIds = new ArrayList<String>(this.mMentionedUserIds);
            return mentionedUserIds;
        }
        if (this instanceof FileMessage && ((FileMessage)this).getRequestState() != FileMessage.RequestState.SUCCEEDED && this.mMentionedUserIds != null && this.mMentionedUserIds.size() > 0) {
            mentionedUserIds = new ArrayList<String>(this.mMentionedUserIds);
            return mentionedUserIds;
        }
        if (this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
            mentionedUserIds = new ArrayList();
            for (User mentionedUser : this.mMentionedUsers) {
                if (mentionedUser == null || mentionedUser.getUserId() == null || mentionedUser.getUserId().length() <= 0) continue;
                mentionedUserIds.add(mentionedUser.getUserId());
            }
        }
        return mentionedUserIds;
    }

    boolean isMentionedFromSomeoneToMe(User sender) {
        String currentUserId;
        boolean result = false;
        String string = currentUserId = SendBird.getCurrentUser() != null ? SendBird.getCurrentUser().getUserId() : null;
        if (sender == null || currentUserId != null && !currentUserId.equals(sender.getUserId())) {
            if (this.mMentionType == BaseMessageParams.MentionType.CHANNEL) {
                result = true;
            } else if (currentUserId != null && currentUserId.length() > 0 && this.mMentionedUsers != null && this.mMentionedUsers.size() > 0) {
                for (User mentionedUser : this.mMentionedUsers) {
                    if (!mentionedUser.getUserId().equals(currentUserId)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public boolean isOpenChannel() {
        return this.mChannelType.equals("open");
    }

    public boolean isGroupChannel() {
        return this.mChannelType.equals("group");
    }

    public String getData() {
        return this.mData;
    }

    public String getCustomType() {
        return this.mCustomType;
    }

    public List<Reaction> getReactions() {
        ArrayList<Reaction> reactionList = new ArrayList<Reaction>(this.reactionMap.values());
        Collections.sort(reactionList);
        return Collections.unmodifiableList(reactionList);
    }

    public Map<String, List<String>> getAllMetaArray() {
        HashMap<String, List<String>> metaArrayMap = new HashMap<String, List<String>>();
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            metaArrayMap.put(metaArray.getKey(), metaArray.getValue());
        }
        return metaArrayMap;
    }

    public List<MessageMetaArray> getAllMetaArrays() {
        return new ArrayList<MessageMetaArray>(this.mMetaArrays);
    }

    public Map<String, List<String>> getMetaArray(Collection<String> metaArrayKeys) {
        HashMap<String, List<String>> resultMap = new HashMap<String, List<String>>();
        List<MessageMetaArray> metaArrays = this.getMetaArrays(metaArrayKeys);
        for (MessageMetaArray metaArray : metaArrays) {
            resultMap.put(metaArray.getKey(), metaArray.getValue());
        }
        return resultMap;
    }

    public List<MessageMetaArray> getMetaArrays(Collection<String> metaArrayKeys) {
        ArrayList<MessageMetaArray> metaArrays = new ArrayList<MessageMetaArray>();
        if (this.mMetaArrays != null && metaArrayKeys != null && metaArrayKeys.size() > 0) {
            for (String key : metaArrayKeys) {
                MessageMetaArray metaArray = this.getMetaArrayByKey(key);
                if (metaArray == null) continue;
                metaArrays.add(metaArray);
            }
        }
        return metaArrays;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    private void addReaction(Reaction reaction) {
        this.reactionMap.put(reaction.getKey(), reaction);
    }

    private void removeReaction(Reaction reaction) {
        this.reactionMap.remove(reaction.getKey());
    }

    private boolean hasReaction(String key) {
        return this.reactionMap.containsKey(key);
    }

    private Reaction getReaction(String key) {
        return this.reactionMap.get(key);
    }

    public boolean applyReactionEvent(ReactionEvent reactionEvent) {
        if (reactionEvent == null) {
            return false;
        }
        String key = reactionEvent.getKey();
        if (this.hasReaction(key)) {
            Reaction reaction = this.getReaction(key);
            if (reaction.merge(reactionEvent)) {
                if (reactionEvent.getOperation() == ReactionEvent.ReactionEventAction.DELETE && reaction.getUserIds().size() == 0) {
                    this.removeReaction(reaction);
                }
                return true;
            }
            return false;
        }
        if (reactionEvent.getOperation() == ReactionEvent.ReactionEventAction.ADD) {
            this.addReaction(new Reaction(reactionEvent));
            return true;
        }
        return false;
    }

    MessageMetaArray getMetaArrayByKey(String key) {
        if (key == null) {
            return null;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            return metaArray;
        }
        return null;
    }

    void addMetaArray(String key) {
        this.addMetaArray(key, new ArrayList<String>());
    }

    void addMetaArray(String key, List<String> value) {
        if (key == null) {
            return;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            return;
        }
        this.mMetaArrays.add(new MessageMetaArray(key, value));
    }

    void setMetaArray(String key, List<String> value) {
        if (key == null) {
            return;
        }
        for (MessageMetaArray metaArray : this.mMetaArrays) {
            if (!key.equals(metaArray.getKey())) continue;
            metaArray.setValue(value);
            return;
        }
        this.mMetaArrays.add(new MessageMetaArray(key, value));
    }

    void removeMetaArrayByKey(String key) {
        if (key == null) {
            return;
        }
        for (int i = 0; i < this.mMetaArrays.size(); ++i) {
            if (!key.equals(this.mMetaArrays.get(i).getKey())) continue;
            this.mMetaArrays.remove(i);
            break;
        }
    }

    boolean isSilent() {
        return this.mIsSilent;
    }

    boolean shouldForceUpdateLastMessage() {
        return this.forceUpdateLastMessage;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        BaseMessage message = (BaseMessage)o;
        if (this.getMessageId() != message.getMessageId() || !this.getChannelUrl().equals(message.getChannelUrl()) || this.getCreatedAt() != message.getCreatedAt()) {
            return false;
        }
        if (this.getMessageId() == 0L && message.getMessageId() == 0L) {
            return this.getRequestId().equals(message.getRequestId());
        }
        return true;
    }

    public int hashCode() {
        return HashUtils.generateHashCode(this.getMessageId(), this.getChannelUrl(), this.getCreatedAt(), this.getRequestId());
    }

    public String toString() {
        return "BaseMessage{mMessageId=" + this.mMessageId + ", mChannelUrl='" + this.mChannelUrl + '\'' + ", mChannelType='" + this.mChannelType + '\'' + ", mData='" + this.mData + '\'' + ", mCustomType='" + this.mCustomType + '\'' + ", mCreatedAt=" + this.mCreatedAt + ", mUpdatedAt=" + this.mUpdatedAt + ", mMentionType=" + (Object)((Object)this.mMentionType) + ", mMentionedUserIds=" + this.mMentionedUserIds + ", mMentionedUsers=" + this.mMentionedUsers + ", mMetaArrays=" + this.mMetaArrays + ", mIsGlobalBlocked=" + this.mIsGlobalBlocked + ", mErrorCode=" + this.mErrorCode + ", mIsSilent=" + this.mIsSilent + ", forceUpdateLastMessage=" + this.forceUpdateLastMessage + ", reactionMap=" + this.reactionMap + '}';
    }
}

