/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.SendBird;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;

public class ReactionEvent {
    private String channelUrl;
    private String channelType;
    private long messageId;
    private final String key;
    private final String userId;
    private final ReactionEventAction operation;
    private final long updatedAt;

    ReactionEvent(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        if (obj.has("channel_url")) {
            this.channelUrl = obj.get("channel_url").getAsString();
        }
        if (obj.has("channel_type")) {
            this.channelType = obj.get("channel_type").getAsString();
        }
        if (obj.has("msg_id")) {
            this.messageId = obj.get("msg_id").getAsLong();
        }
        this.key = obj.get("reaction").getAsString();
        this.userId = obj.get("user_id").getAsString();
        String operation = obj.get("operation").getAsString();
        this.operation = operation.equals("ADD") ? ReactionEventAction.ADD : ReactionEventAction.DELETE;
        this.updatedAt = obj.has("updated_at") ? obj.get("updated_at").getAsLong() : 0L;
    }

    JsonElement toJson() {
        JsonObject obj = new JsonObject();
        if (this.channelUrl != null) {
            obj.addProperty("channel_url", this.channelUrl);
        }
        if (this.channelType != null) {
            obj.addProperty("channel_type", this.channelType);
        }
        obj.addProperty("msg_id", (Number)this.messageId);
        if (this.key != null) {
            obj.addProperty("reaction", this.key);
        }
        if (this.userId != null) {
            obj.addProperty("user_id", this.userId);
        }
        if (this.operation == ReactionEventAction.ADD) {
            obj.addProperty("operation", "ADD");
        } else if (this.operation == ReactionEventAction.DELETE) {
            obj.addProperty("operation", "DELETE");
        }
        obj.addProperty("updated_at", (Number)this.updatedAt);
        return obj;
    }

    public static ReactionEvent buildFromSerializedData(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] copiedData = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            copiedData[i] = (byte)(data[i] ^ i & 0xFF);
        }
        try {
            String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
            return new ReactionEvent(new JsonParser().parse(str));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getChannelUrl() {
        return this.channelUrl;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public boolean isOpenChannel() {
        return this.channelType.equals("open");
    }

    public boolean isGroupChannel() {
        return this.channelType.equals("group");
    }

    public long getMessageId() {
        return this.messageId;
    }

    public String getKey() {
        return this.key;
    }

    public String getUserId() {
        return this.userId;
    }

    public ReactionEventAction getOperation() {
        return this.operation;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public String toString() {
        return "ReactionEvent{channelUrl='" + this.channelUrl + '\'' + ", channelType='" + this.channelType + '\'' + ", messageId=" + this.messageId + ", key='" + this.key + '\'' + ", userId='" + this.userId + '\'' + ", operation=" + (Object)((Object)this.operation) + ", updatedAt=" + this.updatedAt + '}';
    }

    public static enum ReactionEventAction {
        ADD,
        DELETE;

    }
}

