/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.Sender;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public class Member
extends User {
    private MemberState mState;
    private boolean mIsBlockingMe;
    private boolean mIsBlockedByMe;

    protected Member(JsonElement el) {
        super(el);
        if (el.isJsonNull()) {
            return;
        }
        JsonObject obj = el.getAsJsonObject();
        this.mState = obj.has("state") && obj.get("state").getAsString().equals("invited") ? MemberState.INVITED : MemberState.JOINED;
        this.mIsBlockingMe = obj.has("is_blocking_me") && obj.get("is_blocking_me").getAsBoolean();
        this.mIsBlockedByMe = obj.has("is_blocked_by_me") && obj.get("is_blocked_by_me").getAsBoolean();
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        if (this.mState == MemberState.INVITED) {
            obj.addProperty("state", "invited");
        } else {
            obj.addProperty("state", "joined");
        }
        obj.addProperty("is_blocking_me", Boolean.valueOf(this.mIsBlockingMe));
        obj.addProperty("is_blocked_by_me", Boolean.valueOf(this.mIsBlockedByMe));
        return obj;
    }

    void setIsBlockingMe(boolean tf) {
        this.mIsBlockingMe = tf;
    }

    void setIsBlockedByMe(boolean tf) {
        this.mIsBlockedByMe = tf;
    }

    void updatePropertiesBySender(Sender destSender) {
        super.updatePropertiesByUser(destSender);
        this.setIsBlockedByMe(destSender.isBlockedByMe());
    }

    @Deprecated
    public InvitationState getState() {
        InvitationState invitationState = InvitationState.INVITED;
        if (this.mState == MemberState.INVITED) {
            invitationState = InvitationState.INVITED;
        } else if (this.mState == MemberState.JOINED) {
            invitationState = InvitationState.JOINED;
        }
        return invitationState;
    }

    public MemberState getMemberState() {
        return this.mState;
    }

    void setState(MemberState state) {
        this.mState = state;
    }

    public boolean isBlockingMe() {
        return this.mIsBlockingMe;
    }

    public boolean isBlockedByMe() {
        return this.mIsBlockedByMe;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Member other = (Member)o;
        if (this.isBlockedByMe() != other.isBlockedByMe()) {
            return false;
        }
        if (this.isBlockingMe() != other.isBlockingMe()) {
            return false;
        }
        return this.getMemberState() == other.getMemberState();
    }

    public static enum MutedState {
        UNMUTED,
        MUTED;

    }

    public static enum Role {
        NONE,
        OPERATOR;

    }

    public static enum MemberState {
        NONE,
        INVITED,
        JOINED;

    }

    @Deprecated
    public static enum InvitationState {
        INVITED,
        JOINED;

    }
}

