/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import android.util.Base64;
import com.sendbird.android.AES256Chiper;
import com.sendbird.android.Logger;

class KeyStore {
    private static final String PREFERENCE_FILE_NAME = "com.sendbird.sdk.messaging.keystore";
    private static final String PREFERENCE_KEY_SESSION_KEY = "PREFERENCE_KEY_SESSION_KEY";
    private static final String PREFERENCE_KEY_SEED = "PREFERENCE_KEY_SEED";
    private static SharedPreferences preferences;

    private KeyStore() {
    }

    static void init(Context context) {
        preferences = context.getSharedPreferences(PREFERENCE_FILE_NAME, 0);
    }

    static void clearAll() {
        SharedPreferences.Editor editor = preferences.edit();
        editor.clear().apply();
    }

    static void saveSessionKey(String key, String sessionKey) {
        if (TextUtils.isEmpty((CharSequence)key)) {
            return;
        }
        try {
            String seed = KeyStore.generateSeed(key);
            String encryptedSessionKey = AES256Chiper.encrypt(seed, sessionKey);
            SharedPreferences.Editor editor = preferences.edit();
            editor.putString(PREFERENCE_KEY_SESSION_KEY, encryptedSessionKey).apply();
        }
        catch (Exception e) {
            Logger.e(e);
        }
    }

    static String getSessionKey() {
        String seed = preferences.getString(PREFERENCE_KEY_SEED, "");
        if (!TextUtils.isEmpty((CharSequence)seed)) {
            try {
                String encryptedSessionKey = preferences.getString(PREFERENCE_KEY_SESSION_KEY, "");
                return AES256Chiper.decrypt(seed, encryptedSessionKey);
            }
            catch (Exception e) {
                Logger.e(e);
            }
        }
        return "";
    }

    private static String generateSeed(String key) {
        String seed = Base64.encodeToString((byte[])key.getBytes(), (int)2);
        SharedPreferences.Editor editor = preferences.edit();
        editor.putString(PREFERENCE_KEY_SEED, seed).apply();
        return seed;
    }
}

