/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public class Sender
extends User {
    private boolean mIsBlockedByMe;

    protected Sender(JsonElement el) {
        super(el);
        if (el.isJsonNull()) {
            return;
        }
        JsonObject obj = el.getAsJsonObject();
        this.mIsBlockedByMe = obj.has("is_blocked_by_me") && obj.get("is_blocked_by_me").getAsBoolean();
    }

    @Override
    JsonElement toJson() {
        JsonObject obj = super.toJson().getAsJsonObject();
        obj.addProperty("is_blocked_by_me", this.mIsBlockedByMe);
        return obj;
    }

    static Sender toSender(User user) {
        if (user == null) {
            return null;
        }
        return new Sender(user.toJson());
    }

    public boolean isBlockedByMe() {
        return this.mIsBlockedByMe;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Sender other = (Sender)o;
        return this.isBlockedByMe() == other.isBlockedByMe();
    }
}

