/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

class CountDownTimer {
    private boolean mLoop;
    private int mTimeout;
    private int mTick;
    private Thread mTimer;
    private CountDownTimerEventHandler mHandler;
    private boolean mCanceled;

    public CountDownTimer(int timeout) {
        this(timeout, 100);
    }

    public CountDownTimer(int timeout, int tick) {
        this(timeout, tick, false);
    }

    public CountDownTimer(int timeout, int tick, boolean loop) {
        this.mTimeout = timeout;
        this.mTick = tick;
        this.mLoop = loop;
    }

    public void setEventHandler(CountDownTimerEventHandler handler) {
        this.mHandler = handler;
    }

    void setTimeout(int timeout) {
        this.mTimeout = timeout;
    }

    public synchronized void start() {
        this.stop();
        this.mTimer = new Thread(){

            @Override
            public void run() {
                int count = 0;
                if (CountDownTimer.this.mHandler != null) {
                    CountDownTimer.this.mHandler.onStart();
                }
                try {
                    while (true) {
                        Thread.sleep(CountDownTimer.this.mTick);
                        if ((count += CountDownTimer.this.mTick) < CountDownTimer.this.mTimeout) {
                            if (CountDownTimer.this.mHandler != null) {
                                CountDownTimer.this.mHandler.onTick(CountDownTimer.this.mTimeout, count);
                            }
                        } else if (CountDownTimer.this.mHandler != null) {
                            CountDownTimer.this.mHandler.onTimeout();
                        }
                        if (count < CountDownTimer.this.mTimeout) continue;
                        if (CountDownTimer.this.mLoop) {
                            count = 0;
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (CountDownTimer.this.mHandler != null) {
                    if (CountDownTimer.this.mCanceled) {
                        CountDownTimer.this.mHandler.onCancel();
                    } else {
                        CountDownTimer.this.mHandler.onStop();
                    }
                }
            }
        };
        this.mTimer.start();
    }

    public synchronized void stop() {
        if (this.mTimer != null) {
            this.mTimer.interrupt();
            this.mTimer = null;
        }
    }

    public synchronized void cancel() {
        this.mCanceled = true;
        this.stop();
    }

    public static interface CountDownTimerEventHandler {
        public void onStart();

        public void onStop();

        public void onCancel();

        public void onTimeout();

        public void onTick(int var1, int var2);
    }
}

