/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.util.Base64;
import com.sendbird.android.APIClient;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import com.sendbird.android.shadow.com.google.gson.JsonParser;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public final class GroupChannelListQuery {
    private static final String ORDER_LATEST_LAST_MESSAGE = "latest_last_message";
    private static final String ORDER_CHRONOLOGICAL = "chronological";
    private static final String ORDER_CHANNEL_NAME_ALPHABETICAL = "channel_name_alphabetical";
    static final String ORDER_METADATA_VALUE_ALPHABETICAL = "metadata_value_alphabetical";
    private static final String MEMBER_STATE_ALL = "all";
    private static final String MEMBER_STATE_INVITED_ONLY = "invited_only";
    private static final String MEMBER_STATE_INVITED_BY_FRIEND_ONLY = "invited_by_friend";
    private static final String MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY = "invited_by_non_friend";
    private static final String MEMBER_STATE_JOINED_ONLY = "joined_only";
    private final User mUser;
    private String mToken = "";
    private boolean mHasNext = true;
    private int mLimit = 20;
    private boolean mLoading = false;
    private boolean mIncludeEmpty = false;
    private String mOrder = "latest_last_message";
    private String mMetaDataOrderKey;
    private FilterMode mFilterMode = FilterMode.ALL;
    private QueryType mQueryType = QueryType.AND;
    private ArrayList<String> mFilter;
    private String mSearchQuery;
    private List<SearchField> mSearchFields;
    private String mCustomType;
    private String mCustomTypeStartsWith;
    private String mMemberState = "all";
    private ArrayList<String> mChannelUrls;
    private String mNameContains;
    private ArrayList<String> mCustomTypes;
    private SuperChannelFilter mSuperChannelFilter = SuperChannelFilter.ALL;
    private PublicChannelFilter mPublicChannelFilter = PublicChannelFilter.ALL;
    private UnreadChannelFilter mUnreadChannelFilter = UnreadChannelFilter.ALL;
    private HiddenChannelFilter mHiddenChannelFilter = HiddenChannelFilter.UNHIDDEN;

    GroupChannelListQuery(User user) {
        this.mUser = user;
    }

    GroupChannelListQuery(JsonElement el) {
        String hiddenChannelFilter;
        String unreadChannelFilter;
        String publicChannelFilter;
        String superChannelFilter;
        JsonArray customTypes;
        JsonArray searchFields;
        JsonArray channelUrls;
        JsonArray filter;
        String queryType;
        String filterMode;
        JsonObject obj = el.getAsJsonObject();
        this.mUser = obj.has("user") ? new User(obj.get("user")) : null;
        this.mToken = obj.has("token") ? obj.get("token").getAsString() : "";
        this.mHasNext = obj.has("has_next") ? obj.get("has_next").getAsBoolean() : true;
        this.mLimit = obj.has("limit") ? obj.get("limit").getAsInt() : 20;
        this.mIncludeEmpty = obj.has("include_empty") ? obj.get("include_empty").getAsBoolean() : false;
        this.mOrder = obj.has("order") ? obj.get("order").getAsString() : ORDER_LATEST_LAST_MESSAGE;
        this.mMetaDataOrderKey = obj.has("meta_data_order_key") ? obj.get("meta_data_order_key").getAsString() : null;
        switch (filterMode = obj.has("filter_mode") ? obj.get("filter_mode").getAsString() : MEMBER_STATE_ALL) {
            case "all": {
                this.mFilterMode = FilterMode.ALL;
                break;
            }
            case "members_exactly_in": {
                this.mFilterMode = FilterMode.MEMBERS_EXACTLY_IN;
                break;
            }
            case "members_include_in": {
                this.mFilterMode = FilterMode.MEMBERS_INCLUDE_IN;
                break;
            }
            case "members_nickname_contains": {
                this.mFilterMode = FilterMode.MEMBERS_NICKNAME_CONTAINS;
                break;
            }
            default: {
                this.mFilterMode = FilterMode.ALL;
            }
        }
        switch (queryType = obj.has("query_type") ? obj.get("query_type").getAsString() : "and") {
            case "and": {
                this.mQueryType = QueryType.AND;
                break;
            }
            case "or": {
                this.mQueryType = QueryType.OR;
                break;
            }
            default: {
                this.mQueryType = QueryType.AND;
            }
        }
        JsonArray jsonArray = filter = obj.has("filter") ? obj.get("filter").getAsJsonArray() : null;
        if (filter != null) {
            this.mFilter = new ArrayList();
            for (int i = 0; i < filter.size(); ++i) {
                this.mFilter.add(filter.get(i).getAsString());
            }
        }
        this.mCustomType = obj.has("custom_type") ? obj.get("custom_type").getAsString() : null;
        this.mCustomTypeStartsWith = obj.has("custom_type_starts_with") ? obj.get("custom_type_starts_with").getAsString() : null;
        this.mMemberState = obj.has("member_state") ? obj.get("member_state").getAsString() : MEMBER_STATE_ALL;
        JsonArray jsonArray2 = channelUrls = obj.has("channel_urls") ? obj.get("channel_urls").getAsJsonArray() : null;
        if (channelUrls != null) {
            this.mChannelUrls = new ArrayList();
            for (int i = 0; i < channelUrls.size(); ++i) {
                this.mChannelUrls.add(channelUrls.get(i).getAsString());
            }
        }
        this.mNameContains = obj.has("name_contains") ? obj.get("name_contains").getAsString() : null;
        this.mSearchQuery = obj.has("search_query") ? obj.get("search_query").getAsString() : null;
        JsonArray jsonArray3 = searchFields = obj.has("search_fields") ? obj.get("search_fields").getAsJsonArray() : null;
        if (searchFields != null) {
            this.mSearchFields = new ArrayList<SearchField>();
            for (int i = 0; i < searchFields.size(); ++i) {
                String searchField = searchFields.get(i).getAsString();
                if ("member_nickname".equals(searchField)) {
                    this.mSearchFields.add(SearchField.MEMBER_NICKNAME);
                    continue;
                }
                if (!"channel_name".equals(searchField)) continue;
                this.mSearchFields.add(SearchField.CHANNEL_NAME);
            }
        }
        JsonArray jsonArray4 = customTypes = obj.has("custom_types") ? obj.get("custom_types").getAsJsonArray() : null;
        if (customTypes != null) {
            this.mCustomTypes = new ArrayList();
            for (int i = 0; i < customTypes.size(); ++i) {
                this.mCustomTypes.add(customTypes.get(i).getAsString());
            }
        }
        switch (superChannelFilter = obj.has("super_channel_filter") ? obj.get("super_channel_filter").getAsString() : MEMBER_STATE_ALL) {
            case "all": {
                this.mSuperChannelFilter = SuperChannelFilter.ALL;
                break;
            }
            case "super_channel_only": {
                this.mSuperChannelFilter = SuperChannelFilter.SUPER_CHANNEL_ONLY;
                break;
            }
            case "non_super_channel_only": {
                this.mSuperChannelFilter = SuperChannelFilter.NONSUPER_CHANNEL_ONLY;
                break;
            }
            default: {
                this.mSuperChannelFilter = SuperChannelFilter.ALL;
            }
        }
        switch (publicChannelFilter = obj.has("public_channel_filter") ? obj.get("public_channel_filter").getAsString() : MEMBER_STATE_ALL) {
            case "all": {
                this.mPublicChannelFilter = PublicChannelFilter.ALL;
                break;
            }
            case "public": {
                this.mPublicChannelFilter = PublicChannelFilter.PUBLIC;
                break;
            }
            case "private": {
                this.mPublicChannelFilter = PublicChannelFilter.PRIVATE;
                break;
            }
            default: {
                this.mPublicChannelFilter = PublicChannelFilter.ALL;
            }
        }
        switch (unreadChannelFilter = obj.has("unread_channel_filter") ? obj.get("unread_channel_filter").getAsString() : MEMBER_STATE_ALL) {
            case "all": {
                this.mUnreadChannelFilter = UnreadChannelFilter.ALL;
                break;
            }
            case "unread_message": {
                this.mUnreadChannelFilter = UnreadChannelFilter.UNREAD_MESSAGE;
                break;
            }
            default: {
                this.mUnreadChannelFilter = UnreadChannelFilter.ALL;
            }
        }
        switch (hiddenChannelFilter = obj.has("hidden_channel_filter") ? obj.get("hidden_channel_filter").getAsString() : "unhidden") {
            case "unhidden": {
                this.mHiddenChannelFilter = HiddenChannelFilter.UNHIDDEN;
                break;
            }
            case "hidden": {
                this.mHiddenChannelFilter = HiddenChannelFilter.HIDDEN;
                break;
            }
            case "hidden_allow_auto_unhide": {
                this.mHiddenChannelFilter = HiddenChannelFilter.HIDDEN_ALLOW_AUTO_UNHIDE;
                break;
            }
            case "hidden_prevent_auto_unhide": {
                this.mHiddenChannelFilter = HiddenChannelFilter.HIDDEN_PREVENT_AUTO_UNHIDE;
                break;
            }
            default: {
                this.mHiddenChannelFilter = HiddenChannelFilter.UNHIDDEN;
            }
        }
    }

    JsonElement toJson() {
        JsonArray array;
        JsonObject obj = new JsonObject();
        if (this.mUser != null) {
            obj.add("user", this.mUser.toJson());
        }
        obj.addProperty("token", this.mToken);
        obj.addProperty("has_next", this.mHasNext);
        obj.addProperty("limit", this.mLimit);
        obj.addProperty("include_empty", this.mIncludeEmpty);
        obj.addProperty("order", this.mOrder);
        if (this.mMetaDataOrderKey != null) {
            obj.addProperty("meta_data_order_key", this.mMetaDataOrderKey);
        }
        switch (this.mFilterMode) {
            case ALL: {
                obj.addProperty("filter_mode", MEMBER_STATE_ALL);
                break;
            }
            case MEMBERS_EXACTLY_IN: {
                obj.addProperty("filter_mode", "members_exactly_in");
                break;
            }
            case MEMBERS_INCLUDE_IN: {
                obj.addProperty("filter_mode", "members_include_in");
                break;
            }
            case MEMBERS_NICKNAME_CONTAINS: {
                obj.addProperty("filter_mode", "members_nickname_contains");
                break;
            }
            default: {
                obj.addProperty("filter_mode", MEMBER_STATE_ALL);
            }
        }
        switch (this.mQueryType) {
            case AND: {
                obj.addProperty("query_type", "and");
                break;
            }
            case OR: {
                obj.addProperty("query_type", "or");
                break;
            }
            default: {
                obj.addProperty("query_type", "and");
            }
        }
        if (this.mFilter != null) {
            array = new JsonArray();
            for (String filter : this.mFilter) {
                array.add(filter);
            }
            obj.add("filter", array);
        }
        if (this.mSearchQuery != null) {
            obj.addProperty("search_query", this.mSearchQuery);
        }
        if (this.mSearchFields != null) {
            array = new JsonArray();
            for (SearchField searchField : this.mSearchFields) {
                if (searchField == SearchField.MEMBER_NICKNAME) {
                    array.add("member_nickname");
                    continue;
                }
                if (searchField != SearchField.CHANNEL_NAME) continue;
                array.add("channel_name");
            }
            obj.add("search_fields", array);
        }
        if (this.mCustomType != null) {
            obj.addProperty("custom_type", this.mCustomType);
        }
        if (this.mCustomTypeStartsWith != null) {
            obj.addProperty("custom_type_starts_with", this.mCustomTypeStartsWith);
        }
        obj.addProperty("member_state", this.mMemberState);
        if (this.mChannelUrls != null) {
            array = new JsonArray();
            for (String channelUrl : this.mChannelUrls) {
                array.add(channelUrl);
            }
            obj.add("channel_urls", array);
        }
        if (this.mNameContains != null) {
            obj.addProperty("name_contains", this.mNameContains);
        }
        if (this.mCustomTypes != null) {
            array = new JsonArray();
            for (String customType : this.mCustomTypes) {
                array.add(customType);
            }
            obj.add("custom_types", array);
        }
        switch (this.mSuperChannelFilter) {
            case ALL: {
                obj.addProperty("super_channel_filter", MEMBER_STATE_ALL);
                break;
            }
            case SUPER_CHANNEL_ONLY: {
                obj.addProperty("super_channel_filter", "super_channel_only");
                break;
            }
            case NONSUPER_CHANNEL_ONLY: {
                obj.addProperty("super_channel_filter", "non_super_channel_only");
                break;
            }
            default: {
                obj.addProperty("super_channel_filter", MEMBER_STATE_ALL);
            }
        }
        switch (this.mPublicChannelFilter) {
            case ALL: {
                obj.addProperty("public_channel_filter", MEMBER_STATE_ALL);
                break;
            }
            case PUBLIC: {
                obj.addProperty("public_channel_filter", "public");
                break;
            }
            case PRIVATE: {
                obj.addProperty("public_channel_filter", "private");
                break;
            }
            default: {
                obj.addProperty("public_channel_filter", MEMBER_STATE_ALL);
            }
        }
        switch (this.mUnreadChannelFilter) {
            case ALL: {
                obj.addProperty("unread_channel_filter", MEMBER_STATE_ALL);
                break;
            }
            case UNREAD_MESSAGE: {
                obj.addProperty("unread_channel_filter", "unread_message");
                break;
            }
            default: {
                obj.addProperty("unread_channel_filter", MEMBER_STATE_ALL);
            }
        }
        switch (this.mHiddenChannelFilter) {
            case UNHIDDEN: {
                obj.addProperty("hidden_channel_filter", "unhidden");
                break;
            }
            case HIDDEN: {
                obj.addProperty("hidden_channel_filter", "hidden");
                break;
            }
            case HIDDEN_ALLOW_AUTO_UNHIDE: {
                obj.addProperty("hidden_channel_filter", "hidden_allow_auto_unhide");
                break;
            }
            case HIDDEN_PREVENT_AUTO_UNHIDE: {
                obj.addProperty("hidden_channel_filter", "hidden_prevent_auto_unhide");
            }
        }
        return obj;
    }

    public int getLimit() {
        return this.mLimit;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean isIncludeEmpty() {
        return this.mIncludeEmpty;
    }

    public void setIncludeEmpty(boolean includeEmpty) {
        this.mIncludeEmpty = includeEmpty;
    }

    public Order getOrder() {
        if (this.mOrder.equals(ORDER_CHRONOLOGICAL)) {
            return Order.CHRONOLOGICAL;
        }
        if (this.mOrder.equals(ORDER_CHANNEL_NAME_ALPHABETICAL)) {
            return Order.CHANNEL_NAME_ALPHABETICAL;
        }
        if (this.mOrder.equals(ORDER_METADATA_VALUE_ALPHABETICAL)) {
            return Order.METADATA_VALUE_ALPHABETICAL;
        }
        return Order.LATEST_LAST_MESSAGE;
    }

    public void setOrder(Order order) {
        this.mOrder = order == Order.CHRONOLOGICAL ? ORDER_CHRONOLOGICAL : (order == Order.CHANNEL_NAME_ALPHABETICAL ? ORDER_CHANNEL_NAME_ALPHABETICAL : (order == Order.METADATA_VALUE_ALPHABETICAL ? ORDER_METADATA_VALUE_ALPHABETICAL : ORDER_LATEST_LAST_MESSAGE));
    }

    public String getMetaDataOrderKeyFilter() {
        return this.mMetaDataOrderKey;
    }

    public void setMetaDataOrderKeyFilter(String metaDataOrderKey) {
        this.mMetaDataOrderKey = metaDataOrderKey;
    }

    public String getNicknameContainsFilter() {
        if (this.mFilterMode != FilterMode.MEMBERS_NICKNAME_CONTAINS || this.mFilter == null) {
            return null;
        }
        return this.mFilter.get(0);
    }

    public void setNicknameContainsFilter(String nickname) {
        if (nickname == null || nickname.length() == 0) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = FilterMode.MEMBERS_NICKNAME_CONTAINS;
        this.mFilter = new ArrayList();
        this.mFilter.add(nickname);
    }

    @Deprecated
    public void setUserIdsFilter(List<String> userIds, boolean exactMatch) {
        if (userIds == null) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = exactMatch ? FilterMode.MEMBERS_EXACTLY_IN : FilterMode.MEMBERS_INCLUDE_IN;
        this.mFilter = new ArrayList();
        this.mFilter.addAll(userIds);
    }

    public List<String> getUserIdsIncludeFilter() {
        if (this.mFilterMode != FilterMode.MEMBERS_INCLUDE_IN || this.mFilter == null) {
            return null;
        }
        return new ArrayList<String>(this.mFilter);
    }

    public QueryType getUserIdsIncludeFilterQueryType() {
        return this.mQueryType;
    }

    public void setUserIdsIncludeFilter(List<String> userIds, QueryType queryType) {
        if (userIds == null) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = FilterMode.MEMBERS_INCLUDE_IN;
        this.mQueryType = queryType;
        this.mFilter = new ArrayList();
        this.mFilter.addAll(userIds);
    }

    public List<String> getUserIdsExactFilter() {
        if (this.mFilterMode != FilterMode.MEMBERS_EXACTLY_IN || this.mFilter == null) {
            return null;
        }
        return new ArrayList<String>(this.mFilter);
    }

    public void setUserIdsExactFilter(List<String> userIds) {
        if (userIds == null) {
            this.mFilterMode = FilterMode.ALL;
            return;
        }
        this.mFilterMode = FilterMode.MEMBERS_EXACTLY_IN;
        this.mFilter = new ArrayList();
        this.mFilter.addAll(userIds);
    }

    public void setSearchFilter(List<SearchField> searchFields, String query) {
        if (searchFields == null || searchFields.size() == 0) {
            return;
        }
        if (query == null || query.isEmpty()) {
            return;
        }
        this.mSearchQuery = query;
        this.mSearchFields = searchFields;
    }

    public String getSearchQuery() {
        return this.mSearchQuery;
    }

    public List<SearchField> getSearchFields() {
        if (this.mSearchFields == null) {
            return null;
        }
        return new ArrayList<SearchField>(this.mSearchFields);
    }

    @Deprecated
    public void setCustomTypeFilter(String customType) {
        this.mCustomType = customType;
    }

    public String getCustomTypeStartsWithFilter() {
        return this.mCustomTypeStartsWith;
    }

    public void setCustomTypeStartsWithFilter(String customType) {
        this.mCustomTypeStartsWith = customType;
    }

    public List<String> getCustomTypesFilter() {
        return this.mCustomTypes;
    }

    public void setCustomTypesFilter(List<String> customTypes) {
        if (customTypes == null || customTypes.size() <= 0) {
            return;
        }
        this.mCustomTypes = new ArrayList();
        this.mCustomTypes.addAll(customTypes);
    }

    @Deprecated
    public void setMemberStateFilter(MemberState memberState) {
        this.mMemberState = memberState == MemberState.INVITED_ONLY ? MEMBER_STATE_INVITED_ONLY : (memberState == MemberState.JOINED_ONLY ? MEMBER_STATE_JOINED_ONLY : MEMBER_STATE_ALL);
    }

    @Deprecated
    public void setMemberStateFilter(GroupChannel.MemberState memberState) {
        this.mMemberState = memberState == GroupChannel.MemberState.INVITED ? MEMBER_STATE_INVITED_ONLY : (memberState == GroupChannel.MemberState.INVITED_BY_FRIEND ? MEMBER_STATE_INVITED_BY_FRIEND_ONLY : (memberState == GroupChannel.MemberState.INVITED_BY_NON_FRIEND ? MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY : (memberState == GroupChannel.MemberState.JOINED ? MEMBER_STATE_JOINED_ONLY : MEMBER_STATE_ALL)));
    }

    public MemberStateFilter getMemberStateFilter() {
        if (this.mMemberState.equals(MEMBER_STATE_INVITED_ONLY)) {
            return MemberStateFilter.INVITED;
        }
        if (this.mMemberState.equals(MEMBER_STATE_INVITED_BY_FRIEND_ONLY)) {
            return MemberStateFilter.INVITED_BY_FRIEND;
        }
        if (this.mMemberState.equals(MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY)) {
            return MemberStateFilter.INVITED_BY_NON_FRIEND;
        }
        if (this.mMemberState.equals(MEMBER_STATE_JOINED_ONLY)) {
            return MemberStateFilter.JOINED;
        }
        return MemberStateFilter.ALL;
    }

    public void setMemberStateFilter(MemberStateFilter memberStateFilter) {
        this.mMemberState = memberStateFilter == MemberStateFilter.INVITED ? MEMBER_STATE_INVITED_ONLY : (memberStateFilter == MemberStateFilter.INVITED_BY_FRIEND ? MEMBER_STATE_INVITED_BY_FRIEND_ONLY : (memberStateFilter == MemberStateFilter.INVITED_BY_NON_FRIEND ? MEMBER_STATE_INVITED_BY_NON_FRIEND_ONLY : (memberStateFilter == MemberStateFilter.JOINED ? MEMBER_STATE_JOINED_ONLY : MEMBER_STATE_ALL)));
    }

    public List<String> getChannelUrlsFilter() {
        return this.mChannelUrls;
    }

    public void setChannelUrlsFilter(List<String> channelUrls) {
        if (channelUrls == null || channelUrls.size() <= 0) {
            return;
        }
        this.mChannelUrls = new ArrayList();
        this.mChannelUrls.addAll(channelUrls);
    }

    public String getChannelNameContainsFilter() {
        return this.mNameContains;
    }

    public void setChannelNameContainsFilter(String channelName) {
        this.mNameContains = channelName;
    }

    public SuperChannelFilter getSuperChannelFilter() {
        return this.mSuperChannelFilter;
    }

    public void setSuperChannelFilter(SuperChannelFilter superChannelFilter) {
        this.mSuperChannelFilter = superChannelFilter;
    }

    public PublicChannelFilter getPublicChannelFilter() {
        return this.mPublicChannelFilter;
    }

    public void setPublicChannelFilter(PublicChannelFilter publicChannelFilter) {
        this.mPublicChannelFilter = publicChannelFilter;
    }

    public UnreadChannelFilter getUnreadChannelFilter() {
        return this.mUnreadChannelFilter;
    }

    public void setUnreadChannelFilter(UnreadChannelFilter unreadChannelFilter) {
        this.mUnreadChannelFilter = unreadChannelFilter;
    }

    public HiddenChannelFilter getHiddenChannelFilter() {
        return this.mHiddenChannelFilter;
    }

    public void setHiddenChannelFilter(HiddenChannelFilter hiddenChannelFilter) {
        this.mHiddenChannelFilter = hiddenChannelFilter;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final GroupChannelListQueryResultHandler handler) {
        if (!this.hasNext()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new ArrayList<GroupChannel>(), null);
                    }
                });
            }
            return;
        }
        if (this.isLoading()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                });
            }
            return;
        }
        this.setLoading(true);
        APIClient.getInstance().loadUserGroupChannelList(this.mToken, this.mLimit, this.mIncludeEmpty, this.mOrder, this.mMetaDataOrderKey, this.mFilterMode, this.mFilter, this.mQueryType, this.mSearchQuery, this.mSearchFields, this.mCustomType, this.mCustomTypeStartsWith, this.mMemberState, this.mChannelUrls, this.mNameContains, this.mCustomTypes, this.mSuperChannelFilter, this.mPublicChannelFilter, this.mUnreadChannelFilter, this.mHiddenChannelFilter, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                GroupChannelListQuery.this.setLoading(false);
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                GroupChannelListQuery.this.mToken = result.get("next").getAsString();
                if (GroupChannelListQuery.this.mToken == null || GroupChannelListQuery.this.mToken.length() <= 0) {
                    GroupChannelListQuery.this.mHasNext = false;
                }
                JsonArray channelObjs = result.get("channels").getAsJsonArray();
                final ArrayList<GroupChannel> channels = new ArrayList<GroupChannel>();
                for (int i = 0; i < channelObjs.size(); ++i) {
                    channels.add(GroupChannel.upsert(channelObjs.get(i), false));
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channels, null);
                        }
                    });
                }
            }
        });
    }

    public static GroupChannelListQuery buildFromSerializedData(byte[] data) {
        GroupChannelListQuery query = null;
        if (data != null) {
            byte[] copiedData = new byte[data.length];
            for (int i = 0; i < data.length; ++i) {
                copiedData[i] = (byte)(data[i] ^ i & 0xFF);
            }
            try {
                String str = new String(Base64.decode((byte[])copiedData, (int)0), "UTF-8");
                query = new GroupChannelListQuery(new JsonParser().parse(str));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return query;
    }

    public byte[] serialize() {
        JsonObject obj = this.toJson().getAsJsonObject();
        obj.addProperty("version", SendBird.getSDKVersion());
        try {
            byte[] data = Base64.encode((byte[])obj.toString().getBytes("UTF-8"), (int)0);
            for (int i = 0; i < data.length; ++i) {
                data[i] = (byte)(data[i] ^ i & 0xFF);
            }
            return data;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static interface GroupChannelListQueryResultHandler {
        public void onResult(List<GroupChannel> var1, SendBirdException var2);
    }

    static enum FilterMode {
        ALL,
        MEMBERS_EXACTLY_IN,
        MEMBERS_NICKNAME_CONTAINS,
        MEMBERS_INCLUDE_IN;

    }

    public static enum SearchField {
        MEMBER_NICKNAME,
        CHANNEL_NAME;

    }

    public static enum HiddenChannelFilter {
        UNHIDDEN,
        HIDDEN,
        HIDDEN_ALLOW_AUTO_UNHIDE,
        HIDDEN_PREVENT_AUTO_UNHIDE;

    }

    public static enum UnreadChannelFilter {
        ALL,
        UNREAD_MESSAGE;

    }

    public static enum PublicChannelFilter {
        ALL,
        PUBLIC,
        PRIVATE;

    }

    public static enum SuperChannelFilter {
        ALL,
        SUPER_CHANNEL_ONLY,
        NONSUPER_CHANNEL_ONLY;

    }

    public static enum MemberStateFilter {
        ALL,
        INVITED,
        INVITED_BY_FRIEND,
        INVITED_BY_NON_FRIEND,
        JOINED;

    }

    @Deprecated
    public static enum MemberState {
        ALL,
        INVITED_ONLY,
        JOINED_ONLY;

    }

    public static enum QueryType {
        AND,
        OR;

    }

    public static enum Order {
        CHRONOLOGICAL,
        LATEST_LAST_MESSAGE,
        CHANNEL_NAME_ALPHABETICAL,
        METADATA_VALUE_ALPHABETICAL;

    }
}

