/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.Logger;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ConnectionManager {
    private static final Set<ReadyHandler> sReadyHandlers = new LinkedHashSet<ReadyHandler>();

    static void init() {
        ConnectionManager.errorAllReadyHandlers(false);
    }

    static void ready(boolean forcedApi, ReadyHandler handler) {
        Logger.d("[ConnectionManager] ready(forcedApi:" + forcedApi + ")");
        if (forcedApi) {
            Logger.d("[ConnectionManager] ready() => forcedApi => true");
            if (handler != null) {
                if (SendBird.getCurrentUser() != null) {
                    handler.onReady(SendBird.getCurrentUser(), false, null);
                } else {
                    handler.onReady(null, false, ConnectionManager.getConnectionRequiredException());
                }
            }
            return;
        }
        ConnectionManager.addReadyHandler(handler);
        if (SendBird.getInstance().isReconnectingFromOnError()) {
            Logger.d("[ConnectionManager] ready() => isReconnectingFromOnError() => true");
            ConnectionManager.errorAllReadyHandlers(false);
            return;
        }
        if (SendBird.getConnectionState() == SendBird.ConnectionState.OPEN) {
            Logger.d("[ConnectionManager] ready() => SendBird.ConnectionState.OPEN");
            ConnectionManager.processAllReadyHandlers(false, null);
        } else if (SendBird.getConnectionState() == SendBird.ConnectionState.CONNECTING) {
            Logger.d("[ConnectionManager] ready() => SendBird.ConnectionState.CONNECTING");
        } else if (SendBird.getConnectionState() == SendBird.ConnectionState.CLOSED) {
            Logger.d("[ConnectionManager] ready() => SendBird.ConnectionState.CLOSED");
            ConnectionManager.errorAllReadyHandlers(false);
        } else {
            Logger.d("[ConnectionManager] ready() => ?");
            ConnectionManager.errorAllReadyHandlers(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addReadyHandler(ReadyHandler handler) {
        if (handler != null) {
            Set<ReadyHandler> set = sReadyHandlers;
            synchronized (set) {
                sReadyHandlers.add(handler);
                Logger.d("[ConnectionManager] addReadyHandler() => size:" + sReadyHandlers.size());
            }
        }
    }

    static void errorAllReadyHandlers(boolean reconnected) {
        Logger.d("[ConnectionManager] errorAllReadyHandlers(reconnected:" + reconnected + ")");
        ConnectionManager.processAllReadyHandlers(reconnected, ConnectionManager.getConnectionRequiredException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processAllReadyHandlers(boolean reconnected, SendBirdException e) {
        Logger.d("[ConnectionManager] processAllReadyHandlers()");
        LinkedHashSet<ReadyHandler> tempReadyHandlers = null;
        Set<ReadyHandler> set = sReadyHandlers;
        synchronized (set) {
            if (sReadyHandlers.size() > 0) {
                tempReadyHandlers = new LinkedHashSet<ReadyHandler>(sReadyHandlers);
                sReadyHandlers.clear();
            }
        }
        if (tempReadyHandlers != null) {
            for (ReadyHandler handler : tempReadyHandlers) {
                if (handler == null) continue;
                Logger.d("[ConnectionManager] onReady(userId:" + (SendBird.getCurrentUser() != null ? SendBird.getCurrentUser().getUserId() : "") + ", reconnected:" + reconnected + ", e:" + (e != null ? e.getMessage() : "") + ")");
                handler.onReady(SendBird.getCurrentUser(), reconnected, e);
            }
        }
    }

    static SendBirdException getConnectionRequiredException() {
        return new SendBirdException("Connection must be made.", 800101);
    }

    public static void authenticate(AuthInfoRequestHandler authInfoRequestHandler, final AuthenticateHandler handler) {
        Logger.d("[ConnectionManager] authenticate()");
        if (SendBird.getCurrentUser() != null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    Logger.d("[ConnectionManager] onAuthenticated()");
                    if (handler != null) {
                        handler.onAuthenticated(SendBird.getCurrentUser(), null);
                    }
                }
            });
        } else {
            final Timer timer = new Timer();
            SendBird.getInstance().addAuthenticationTimer(timer);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            if (SendBird.getInstance().removeAuthenticationTimer(timer)) {
                                Logger.d("[ConnectionManager] onAuthenticated() => Timeout");
                                if (handler != null) {
                                    handler.onAuthenticated(null, new SendBirdException("setAuthInfo() or setAuthInfoWithHostInfo() in AuthInfoRequester must be called before authentication timeout."));
                                }
                                ConnectionManager.errorAllReadyHandlers(false);
                            }
                        }
                    });
                }
            }, SendBird.Options.authenticationTimeout * 1000);
            if (authInfoRequestHandler != null) {
                authInfoRequestHandler.onAuthInfoRequest(new AuthInfoRequester(){

                    @Override
                    public void setAuthInfo(String userId, String accessToken) {
                        ConnectionManager.localAuthenticate(userId, accessToken, null, null, handler, timer);
                    }

                    @Override
                    public void setAuthInfoWithHostInfo(String userId, String accessToken, String apiHost, String wsHost) {
                        ConnectionManager.localAuthenticate(userId, accessToken, apiHost, wsHost, handler, timer);
                    }
                });
            }
        }
    }

    private static void localAuthenticate(String userId, String accessToken, String apiHost, String wsHost, final AuthenticateHandler handler, Timer timer) {
        if (SendBird.getInstance().removeAuthenticationTimer(timer)) {
            Logger.d("[ConnectionManager] localAuthenticate()");
            SendBird.connect(userId, accessToken, apiHost, wsHost, new SendBird.ConnectHandler(){

                @Override
                public void onConnected(User user, SendBirdException e) {
                    Logger.d("[ConnectionManager] onAuthenticated()" + (e != null ? " => " + e.getMessage() : ""));
                    if (handler != null) {
                        handler.onAuthenticated(user, e);
                    }
                }
            });
        }
    }

    public static void addNetworkHandler(String identifier, final NetworkHandler handler) {
        SendBird.addLocalNetworkHandler(identifier, new SendBird.LocalNetworkHandler(){

            @Override
            public void onLocalUnexpectedDisconnect() {
                Logger.d("[ConnectionManager] onUnexpectedDisconnect()");
            }

            @Override
            public void onLocalReconnected() {
                Logger.d("[ConnectionManager] onReconnected()");
                if (handler != null) {
                    handler.onReconnected();
                }
            }

            @Override
            public void onLocalReconnectFailed() {
                Logger.d("[ConnectionManager] onReconnectFailed()");
            }
        });
    }

    public static void removeNetworkHandler(String identifier) {
        SendBird.removeLocalNetworkHandler(identifier);
    }

    public static void removeAllNetworkHandlers() {
        SendBird.removeAllLocalNetworkHandlers();
    }

    public static abstract class NetworkHandler {
        public abstract void onReconnected();
    }

    public static interface AuthenticateHandler {
        public void onAuthenticated(User var1, SendBirdException var2);
    }

    public static interface AuthInfoRequester {
        public void setAuthInfo(String var1, String var2);

        public void setAuthInfoWithHostInfo(String var1, String var2, String var3, String var4);
    }

    public static interface AuthInfoRequestHandler {
        public void onAuthInfoRequest(AuthInfoRequester var1);
    }

    static interface ReadyHandler {
        public void onReady(User var1, boolean var2, SendBirdException var3);
    }
}

