/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import com.sendbird.android.APIClient;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.ChannelEvent;
import com.sendbird.android.Command;
import com.sendbird.android.CountDownTimer;
import com.sendbird.android.FileMessage;
import com.sendbird.android.GroupChannel;
import com.sendbird.android.Logger;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.ReadStatus;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.UserListQuery;
import com.sendbird.android.UserMessage;
import com.sendbird.android.WSClient;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SendBird {
    private static final String VERSION = "3.0.1";
    private static final int CMD_ACK_TIMEOUT = 10000;
    protected static final boolean DEBUG_HOST = false;
    protected static final String DEBUG_WS_HOST = "ws://192.168.0.159:9000";
    protected static final String DEBUG_API_HOST = "http://192.168.0.159:8000/api";
    private static SendBird sInstance;
    private static final Handler sUIThreadHandler;
    private final String mAppId;
    private final Context mAppContext;
    private WSClient mWSClient;
    private User mCurrentUser;
    private int mReconnectDelay = 3000;
    private int mReconnectCount;
    private CountDownTimer mReconnectTimer;
    private CountDownTimer mLoginTimer;
    private CountDownTimer mGlobalTimer;
    private final HashMap<String, HashMap<String, Object>> mAckStateMap = new HashMap();
    private final ConcurrentHashMap<String, ChannelHandler> mChannelHandlers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ConnectionHandler> mConnectionHandlers = new ConcurrentHashMap();
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_INFO = 1;

    public static String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getSDKVersion() {
        return VERSION;
    }

    public static String getApplicationId() {
        return SendBird.getInstance().mAppId;
    }

    public static void setLoggerLevel(int level) {
        Logger.sLevel = level;
    }

    private SendBird(String appId, Context context) {
        this.mAppId = appId;
        this.mAppContext = context;
    }

    private void startGlobalTimer() {
        if (this.mGlobalTimer != null) {
            this.mGlobalTimer.cancel();
            this.mGlobalTimer = null;
        }
        this.mGlobalTimer = new CountDownTimer(1000, 100, true);
        this.mGlobalTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
            long tickCount = 0L;

            @Override
            public void onStart() {
            }

            @Override
            public void onStop() {
            }

            @Override
            public void onCancel() {
            }

            @Override
            public void onTimeout() {
            }

            @Override
            public void onTick(int timeout, int elapsed) {
                ++this.tickCount;
                if (this.tickCount % 10L == 0L && GroupChannel.sCachedChannels != null) {
                    for (final GroupChannel channel : GroupChannel.sCachedChannels.values()) {
                        channel.fireMarkAsRead();
                        if (!channel.invalidateTypingStatus()) continue;
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onTypingStatusUpdated(channel);
                                }
                            }
                        });
                    }
                }
                if (this.tickCount % 20L == 2L) {
                    // empty if block
                }
                if (this.tickCount % 50L == 2L) {
                    // empty if block
                }
            }
        });
        this.mGlobalTimer.start();
    }

    protected static void runOnUIThread(Runnable runnable) {
        if (sUIThreadHandler != null) {
            sUIThreadHandler.post(runnable);
        } else {
            runnable.run();
        }
    }

    protected static synchronized SendBird getInstance() {
        if (sInstance == null) {
            Logger.e("SendBird instance hasn't been initialized. Try SendBird.init().");
            throw new RuntimeException("SendBird instance hasn't been initialized.");
        }
        return sInstance;
    }

    protected static synchronized boolean isInitialized() {
        return sInstance != null;
    }

    public static synchronized void init(String appId, Context context) {
        if (sInstance == null) {
            sInstance = new SendBird(appId, context.getApplicationContext());
            APIClient.init();
        }
    }

    public static ConnectionState getConnectionState() {
        if (!SendBird.isInitialized()) {
            return ConnectionState.CLOSED;
        }
        try {
            if (SendBird.getInstance().mWSClient == null) {
                return ConnectionState.CLOSED;
            }
            return SendBird.getInstance().mWSClient.getConnectionState();
        }
        catch (RuntimeException e) {
            return ConnectionState.CLOSED;
        }
    }

    public static void connect(String userId, ConnectHandler handler) {
        SendBird.connect(userId, null, handler);
    }

    public static void connect(String userId, String accessToken, final ConnectHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onConnected(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        User currentUser = SendBird.getCurrentUser();
        if (currentUser == null || !currentUser.getUserId().equals(userId)) {
            if (currentUser != null && !currentUser.getUserId().equals(userId)) {
                SendBird.disconnect(true, null);
            }
            APIClient.getInstance().login(userId, accessToken, new APIClient.APIClientHandler(){

                @Override
                public void onResult(JsonElement response, final SendBirdException e) {
                    if (e != null) {
                        SendBird.disconnect(true, null);
                        if (handler != null) {
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    handler.onConnected(null, e);
                                }
                            });
                        }
                        return;
                    }
                    User user = new User(response);
                    SendBird.connectWS(user, handler);
                }
            });
        } else {
            SendBird.connectWS(currentUser, handler);
        }
    }

    public static void addChannelHandler(String identifier, ChannelHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mChannelHandlers.put(identifier, handler);
    }

    public static ChannelHandler removeChannelHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mChannelHandlers.remove(identifier);
    }

    public static void addConnectionHandler(String identifier, ConnectionHandler handler) {
        if (identifier == null || identifier.length() == 0 || handler == null) {
            return;
        }
        SendBird.getInstance().mConnectionHandlers.put(identifier, handler);
    }

    public static ConnectionHandler removeConnectionHandler(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBird.getInstance().mConnectionHandlers.remove(identifier);
    }

    private static void reconnectWS(final User user) {
        final SendBird I = SendBird.getInstance();
        I.mReconnectDelay = Math.min(I.mReconnectDelay, 300000);
        ++I.mReconnectCount;
        if (I.mReconnectCount == 1) {
            Logger.d("Reconnect Started.");
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                        handler.onReconnectStarted();
                    }
                }
            });
        }
        if (I.mReconnectCount <= 5) {
            if (I.mReconnectTimer == null) {
                I.mReconnectTimer = new CountDownTimer(I.mReconnectDelay, 1000);
                I.mReconnectTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

                    @Override
                    public void onStart() {
                        Logger.d("ReconnectTimer start.");
                    }

                    @Override
                    public void onStop() {
                        I.mReconnectTimer = null;
                        Logger.d("ReconnectTimer stop.");
                    }

                    @Override
                    public void onCancel() {
                        I.mReconnectTimer = null;
                        Logger.d("ReconnectTimer cancel.");
                    }

                    @Override
                    public void onTimeout() {
                        I.mReconnectTimer = null;
                        Logger.d("ReconnectTimer timeout. Try to reconnect...");
                        if (I.mWSClient != null) {
                            I.mWSClient.disconnect();
                            I.mWSClient = null;
                        }
                        I.mWSClient = new WSClient();
                        I.mWSClient.setEventHandler(new WSClient.WSClientHandler(){

                            @Override
                            public void onReady() {
                                Logger.d("WS Ready.");
                                I.mWSClient.connect();
                            }

                            @Override
                            public void onOpen() {
                                Logger.d("WS Open.");
                                I.mReconnectDelay = 3000;
                                I.mReconnectCount = 0;
                                this.startLoginTimer();
                            }

                            private void startLoginTimer() {
                                I.mLoginTimer = new CountDownTimer(10000, 100);
                                I.mLoginTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                                    private boolean timeout;

                                    @Override
                                    public void onStart() {
                                    }

                                    @Override
                                    public void onStop() {
                                        if (this.timeout) {
                                            Logger.d("Reconnect login timer failed.");
                                            SendBird.disconnect(false, null);
                                            if (I.mConnectionHandlers.size() > 0) {
                                                SendBird.runOnUIThread(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                            handler.onReconnectFailed();
                                                        }
                                                    }
                                                });
                                            }
                                        } else {
                                            Logger.d("Reconnect login timer succeeded.");
                                            Collection<OpenChannel> enteredOpenChannels = OpenChannel.getEnteredChannels();
                                            final AtomicBoolean errorOnEnter = new AtomicBoolean(false);
                                            if (enteredOpenChannels.size() > 0) {
                                                Logger.d("Enter open channels: " + enteredOpenChannels.size());
                                                final CountDownLatch latch = new CountDownLatch(enteredOpenChannels.size());
                                                for (OpenChannel channel : OpenChannel.getEnteredChannels()) {
                                                    channel.enter(new OpenChannel.OpenChannelEnterHandler(){

                                                        @Override
                                                        public void onResult(SendBirdException e) {
                                                            if (e != null) {
                                                                Logger.d(e);
                                                                errorOnEnter.set(true);
                                                            }
                                                            latch.countDown();
                                                        }
                                                    });
                                                }
                                                try {
                                                    latch.await();
                                                }
                                                catch (InterruptedException e) {
                                                    errorOnEnter.set(true);
                                                }
                                                if (errorOnEnter.get()) {
                                                    Logger.d("Error on enter: true");
                                                    SendBird.disconnect(false, null);
                                                } else {
                                                    Logger.d("Error on enter: false");
                                                }
                                                if (I.mConnectionHandlers.size() > 0) {
                                                    SendBird.runOnUIThread(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                                if (errorOnEnter.get()) {
                                                                    handler.onReconnectFailed();
                                                                    continue;
                                                                }
                                                                handler.onReconnectSucceeded();
                                                            }
                                                        }
                                                    });
                                                }
                                            } else {
                                                Logger.d("No open channels to enter.");
                                                if (I.mConnectionHandlers.size() > 0) {
                                                    SendBird.runOnUIThread(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                                                                handler.onReconnectSucceeded();
                                                            }
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                        I.mLoginTimer = null;
                                    }

                                    @Override
                                    public void onCancel() {
                                        Logger.d("Reconnect login timer canceled.");
                                        I.mLoginTimer = null;
                                    }

                                    @Override
                                    public void onTimeout() {
                                        this.timeout = true;
                                    }

                                    @Override
                                    public void onTick(int timeout, int elapsed) {
                                    }
                                });
                                I.mLoginTimer.start();
                            }

                            @Override
                            public void onClose() {
                                Logger.d("WS onClose.");
                            }

                            @Override
                            public void onMessage(String message) {
                                Logger.d("WS onMessage: " + message);
                                I.messageReceived(message);
                            }

                            @Override
                            public void onError(SendBirdException e) {
                                Logger.d("WS onError.");
                                Logger.d(e);
                                SendBird.reconnectWS(user);
                            }
                        });
                        I.mWSClient.initWebSocket();
                    }

                    @Override
                    public void onTick(int timeout, int elapsed) {
                        Logger.d("ReconnectTimer Tick: " + (timeout - elapsed));
                    }
                });
                I.mReconnectTimer.start();
            } else {
                Logger.d("Reconnecting is in progress.");
            }
            I.mReconnectDelay *= 2;
        } else {
            Logger.d("Reconnect Failed.");
            SendBird.disconnect(true, null);
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    for (ConnectionHandler handler : I.mConnectionHandlers.values()) {
                        handler.onReconnectFailed();
                    }
                }
            });
        }
    }

    private static void connectWS(final User user, final ConnectHandler handler) {
        final SendBird I = SendBird.getInstance();
        if (I.mWSClient != null) {
            I.mWSClient.disconnect();
            I.mWSClient = null;
            I.mReconnectDelay = 3000;
            I.mReconnectCount = 0;
        }
        I.mWSClient = new WSClient();
        I.mWSClient.setEventHandler(new WSClient.WSClientHandler(){
            private boolean isOpened;

            @Override
            public void onReady() {
                Logger.d("WS Ready.");
                I.mWSClient.connect();
            }

            @Override
            public void onOpen() {
                Logger.d("WS Open.");
                this.isOpened = true;
                I.mReconnectDelay = 3000;
                I.mReconnectCount = 0;
                I.mLoginTimer = new CountDownTimer(10000, 100);
                I.mLoginTimer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){
                    private boolean timeout;

                    @Override
                    public void onStart() {
                    }

                    @Override
                    public void onStop() {
                        if (this.timeout) {
                            Logger.d("Connect login timer failed.");
                            SendBird.disconnect(false, null);
                            if (handler != null) {
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        handler.onConnected(null, new SendBirdException("Login timeout.", 800190));
                                    }
                                });
                            }
                        } else {
                            Logger.d("Connect login timer succeeded.");
                            I.mCurrentUser = user;
                            I.startGlobalTimer();
                            if (handler != null) {
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        handler.onConnected(user, null);
                                    }
                                });
                            }
                        }
                        I.mLoginTimer = null;
                    }

                    @Override
                    public void onCancel() {
                        Logger.d("Connect login timer canceled.");
                        I.mLoginTimer = null;
                    }

                    @Override
                    public void onTimeout() {
                        this.timeout = true;
                    }

                    @Override
                    public void onTick(int timeout, int elapsed) {
                    }
                });
                I.mLoginTimer.start();
            }

            @Override
            public void onClose() {
                Logger.d("WS Close.");
            }

            @Override
            public void onMessage(String message) {
                Logger.d("WS Received: " + message);
                I.messageReceived(message);
            }

            @Override
            public void onError(final SendBirdException e) {
                Logger.d("WS Error.");
                Logger.d(e);
                if (!this.isOpened) {
                    SendBird.disconnect(false, null);
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onConnected(null, e);
                            }
                        });
                    }
                    return;
                }
                SendBird.reconnectWS(user);
            }
        });
        I.mWSClient.initWebSocket();
    }

    public static void disconnect(DisconnectHandler handler) {
        SendBird.disconnect(true, handler);
    }

    static void disconnect(boolean deleteSessionKey, final DisconnectHandler handler) {
        Logger.d("Disconnect.");
        SendBird I = SendBird.getInstance();
        I.mReconnectDelay = 3000;
        I.mReconnectCount = 0;
        if (I.mGlobalTimer != null) {
            I.mGlobalTimer.cancel();
            I.mGlobalTimer = null;
        }
        if (I.mLoginTimer != null) {
            I.mLoginTimer.cancel();
            I.mLoginTimer = null;
        }
        if (I.mReconnectTimer != null) {
            I.mReconnectTimer.cancel();
            I.mReconnectTimer = null;
        }
        if (I.mWSClient != null) {
            I.mWSClient.disconnect();
            I.mWSClient = null;
        }
        if (I.mCurrentUser != null) {
            I.mCurrentUser = null;
        }
        if (deleteSessionKey) {
            APIClient.getInstance().setSessionKey("");
        }
        OpenChannel.clearEnteredChannels();
        if (handler != null) {
            SendBird.runOnUIThread(new Runnable(){

                @Override
                public void run() {
                    handler.onDisconnected();
                }
            });
        }
    }

    public static User getCurrentUser() {
        return SendBird.getInstance().mCurrentUser;
    }

    public static UserListQuery createUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.ALL_USER);
    }

    public static UserListQuery createBlockedUserListQuery() {
        return new UserListQuery(UserListQuery.QueryType.BLOCKED_USER);
    }

    public static void updateCurrentUserInfoWithProfileImage(final String nickname, File profileImage, final UserInfoUpdateHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(new SendBirdException("Connection must be made before you update user information.", 800101));
                    }
                });
            }
            return;
        }
        if (profileImage == null) {
            SendBird.updateCurrentUserInfo(nickname, null, handler);
        } else {
            APIClient.getInstance().uploadProfileImage(profileImage, new APIClient.APIClientHandler(){

                @Override
                public void onResult(JsonElement response, final SendBirdException e) {
                    if (e != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                if (handler != null) {
                                    handler.onUpdated(e);
                                }
                            }
                        });
                        return;
                    }
                    JsonObject result = response.getAsJsonObject();
                    String fileUrl = result.get("url").getAsString();
                    SendBird.updateCurrentUserInfo(nickname, fileUrl, handler);
                }
            });
        }
    }

    public static void updateCurrentUserInfo(final String nickname, final String profileUrl, final UserInfoUpdateHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUpdated(new SendBirdException("Connection must be made before you update user information.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().updateUserInfo(SendBird.getCurrentUser().getUserId(), nickname, profileUrl, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUpdated(e);
                            }
                        });
                    }
                    return;
                }
                if (nickname != null) {
                    SendBird.getCurrentUser().setNickname(nickname);
                }
                if (profileUrl != null) {
                    SendBird.getCurrentUser().setProfileUrl(profileUrl);
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUpdated(null);
                        }
                    });
                }
            }
        });
    }

    public static void registerPushTokenForCurrentUser(String gcmRegToken, final RegisterPushTokenHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(new SendBirdException("Connection must be made before you register push token.", 800101));
                    }
                });
            }
            return;
        }
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onRegistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().registerPushToken(SendBird.getCurrentUser().getUserId(), gcmRegToken, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onRegistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onRegistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenForCurrentUser(String gcmRegToken, final UnregisterPushTokenHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Connection must be made before you unregister push token.", 800101));
                    }
                });
            }
            return;
        }
        if (gcmRegToken == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unregisterPushToken(SendBird.getCurrentUser().getUserId(), gcmRegToken, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void unregisterPushTokenAllForCurrentUser(final UnregisterPushTokenHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnregistered(new SendBirdException("Connection must be made before you unregister all push token.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unregisterPushTokenAll(SendBird.getCurrentUser().getUserId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnregistered(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnregistered(null);
                        }
                    });
                }
            }
        });
    }

    public static void blockUser(User userToBlock, final UserBlockHandler handler) {
        if (userToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.blockUserWithUserId(userToBlock.getUserId(), handler);
    }

    public static void blockUserWithUserId(String userIdToBlock, final UserBlockHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Connection must be made before you block a user.", 800101));
                    }
                });
            }
            return;
        }
        if (userIdToBlock == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onBlocked(null, new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().blockUser(SendBird.getCurrentUser().getUserId(), userIdToBlock, new APIClient.APIClientHandler(){

            @Override
            public void onResult(final JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onBlocked(null, e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onBlocked(new User(response), null);
                        }
                    });
                }
            }
        });
    }

    public static void unblockUser(User blockedUser, final UserUnblockHandler handler) {
        if (blockedUser == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        SendBird.unblockUserWithUserId(blockedUser.getUserId(), handler);
    }

    public static void unblockUserWithUserId(String blockedUserId, final UserUnblockHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Connection must be made before you unblock a user.", 800101));
                    }
                });
            }
            return;
        }
        if (blockedUserId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onUnblocked(new SendBirdException("Invalid operation.", 800110));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().unblockUser(SendBird.getCurrentUser().getUserId(), blockedUserId, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onUnblocked(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onUnblocked(null);
                        }
                    });
                }
            }
        });
    }

    private void messageReceived(String message) {
        Command cmd = new Command(message);
        Logger.d(cmd.getRequestId() + ":" + cmd.getCommand() + ":" + cmd.getPayload());
        if (cmd.hasRequestId()) {
            HashMap<String, Object> ackInfo = this.getAckInfo(cmd.getRequestId());
            if (ackInfo == null) {
                return;
            }
            CountDownTimer timer = (CountDownTimer)ackInfo.get("timer");
            Command.SendCommandHandler handler = (Command.SendCommandHandler)ackInfo.get("handler");
            timer.stop();
            if (handler != null) {
                if (cmd.getCommand().equals("EROR")) {
                    JsonObject error = cmd.getJsonElement().getAsJsonObject();
                    int errCode = error.get("code").getAsInt();
                    String errMessage = error.get("message").getAsString();
                    handler.onResult(cmd, new SendBirdException(errMessage, errCode));
                } else {
                    handler.onResult(cmd, null);
                }
            }
            return;
        }
        if (cmd.getCommand().equals("LOGI")) {
            if (this.mLoginTimer != null) {
                this.mLoginTimer.stop();
            }
        } else if (cmd.getCommand().equals("MESG") || cmd.getCommand().equals("FILE") || cmd.getCommand().equals("BRDM") || cmd.getCommand().equals("ADMM")) {
            BaseMessage msg;
            if (cmd.getCommand().equals("MESG")) {
                msg = new UserMessage(cmd.getJsonElement());
            } else if (cmd.getCommand().equals("FILE")) {
                msg = new FileMessage(cmd.getJsonElement());
            } else if (cmd.getCommand().equals("BRDM") || cmd.getCommand().equals("ADMM")) {
                msg = new AdminMessage(cmd.getJsonElement());
            } else {
                Logger.d("Discard a command: " + cmd.getCommand());
                return;
            }
            if (msg.isGroupChannel()) {
                GroupChannel.getChannel(msg.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        channel.setLastMessage(msg);
                        channel.setUnreadMessageCount(channel.getUnreadMessageCount() + 1);
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onMessageReceived(channel, msg);
                                }
                            }
                        });
                    }
                });
            } else {
                OpenChannel.getChannel(msg.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command.");
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onMessageReceived(channel, msg);
                                }
                            }
                        });
                    }
                });
            }
        } else if (cmd.getCommand().equals("READ")) {
            final ReadStatus rst = new ReadStatus(cmd.getJsonElement());
            GroupChannel.getChannel(rst.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                @Override
                public void onResult(final GroupChannel channel, SendBirdException e) {
                    if (e != null) {
                        Logger.d("Discard a command. ");
                        return;
                    }
                    channel.updateReadReceipt(rst.getReader().getUserId(), rst.getTimestamp());
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onReadReceiptUpdated(channel);
                            }
                        }
                    });
                }
            });
        } else if (!(cmd.getCommand().equals("TPST") || cmd.getCommand().equals("TPEN") || cmd.getCommand().equals("MTIO"))) {
            if (cmd.getCommand().equals("SYEV")) {
                this.processChannelEvent(cmd);
            } else if (cmd.getCommand().equals("DELM")) {
                JsonObject obj = cmd.getJsonElement().getAsJsonObject();
                String channelType = obj.get("channel_type").getAsString();
                String channelUrl = obj.get("channel_url").getAsString();
                final long msgId = obj.get("msg_id").getAsLong();
                switch (channelType) {
                    case "open": {
                        OpenChannel.getChannel(channelUrl, new OpenChannel.OpenChannelGetHandler(){

                            @Override
                            public void onResult(final OpenChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageDeleted(channel, msgId);
                                        }
                                    }
                                });
                            }
                        });
                        break;
                    }
                    case "group": {
                        GroupChannel.getChannel(channelUrl, new GroupChannel.GroupChannelGetHandler(){

                            @Override
                            public void onResult(final GroupChannel channel, SendBirdException e) {
                                if (e != null) {
                                    Logger.d("Discard a command.");
                                    return;
                                }
                                SendBird.runOnUIThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                            handler.onMessageDeleted(channel, msgId);
                                        }
                                    }
                                });
                            }
                        });
                        break;
                    }
                    default: {
                        Logger.d("Discard a command.");
                        return;
                    }
                }
            } else if (!cmd.getCommand().equals("LEAV") && !cmd.getCommand().equals("JOIN")) {
                Logger.d("Discard a command: " + cmd.getCommand());
            }
        }
    }

    private void processChannelEvent(final Command cmd) {
        final ChannelEvent event = new ChannelEvent(cmd.getJsonElement());
        switch (event.getCategory()) {
            case 10000: 
            case 10001: {
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        if (event.getCategory() == 10000) {
                            channel.addMember(user);
                        } else {
                            channel.removeMember(user);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10000) {
                                        handler.onUserJoined(channel, user);
                                        continue;
                                    }
                                    handler.onUserLeft(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10900: 
            case 10901: {
                GroupChannel.getChannel(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        User user = new User(event.getData());
                        if (event.getCategory() == 10900) {
                            channel.updateTypingStatus(user, true);
                        } else {
                            channel.updateTypingStatus(user, false);
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onTypingStatusUpdated(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10102: 
            case 10103: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10102) {
                                        handler.onUserEntered(channel, user);
                                        continue;
                                    }
                                    handler.onUserExited(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10200: 
            case 10201: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10201) {
                                        handler.onUserMuted(channel, user);
                                        continue;
                                    }
                                    handler.onUserUnmuted(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10600: 
            case 10601: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        final User user = new User(event.getData());
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10601) {
                                        handler.onUserBanned(channel, user);
                                        continue;
                                    }
                                    handler.onUserUnbanned(channel, user);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 10700: 
            case 10701: {
                OpenChannel.getChannel(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                    @Override
                    public void onResult(final OpenChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    if (event.getCategory() == 10701) {
                                        handler.onChannelFrozen(channel);
                                        continue;
                                    }
                                    handler.onChannelUnfrozen(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 11000: {
                if (event.isOpenChannel()) {
                    OpenChannel.getChannelWithoutCache(event.getChannelUrl(), new OpenChannel.OpenChannelGetHandler(){

                        @Override
                        public void onResult(final OpenChannel channel, SendBirdException e) {
                            if (e != null) {
                                Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                                return;
                            }
                            SendBird.runOnUIThread(new Runnable(){

                                @Override
                                public void run() {
                                    for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                        handler.onChannelChanged(channel);
                                    }
                                }
                            });
                        }
                    });
                    break;
                }
                GroupChannel.getChannelWithoutCache(event.getChannelUrl(), new GroupChannel.GroupChannelGetHandler(){

                    @Override
                    public void onResult(final GroupChannel channel, SendBirdException e) {
                        if (e != null) {
                            Logger.d("Discard a command: " + cmd.getCommand() + ":" + event.getCategory());
                            return;
                        }
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                    handler.onChannelChanged(channel);
                                }
                            }
                        });
                    }
                });
                break;
            }
            case 12000: {
                final String channelUrl = event.getChannelUrl();
                if (event.isOpenChannel()) {
                    OpenChannel.removeChannelFromCache(event.getChannelUrl());
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                                handler.onChannelDeleted(channelUrl, BaseChannel.ChannelType.OPEN);
                            }
                        }
                    });
                    break;
                }
                GroupChannel.removeChannelFromCache(event.getChannelUrl());
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (ChannelHandler handler : SendBird.this.mChannelHandlers.values()) {
                            handler.onChannelDeleted(channelUrl, BaseChannel.ChannelType.GROUP);
                        }
                    }
                });
            }
        }
    }

    void sendCommand(final Command cmd, final Command.SendCommandHandler handler) {
        if (this.mWSClient == null || this.mWSClient.getConnectionState() != ConnectionState.OPEN) {
            if (handler != null) {
                handler.onResult(null, new SendBirdException("WS connection closed.", 800200));
            }
            return;
        }
        if (cmd.isAckRequired()) {
            this.startAckTimer(cmd, handler);
            this.mWSClient.send(cmd, new WSClient.WSClientSendHandler(){

                @Override
                public void onResult(SendBirdException e) {
                    if (e != null) {
                        HashMap ackInfo = SendBird.this.getAckInfo(cmd.getRequestId());
                        if (ackInfo != null) {
                            CountDownTimer timer = (CountDownTimer)ackInfo.get("timer");
                            Command.SendCommandHandler handler2 = (Command.SendCommandHandler)ackInfo.get("handler");
                            timer.stop();
                        }
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                }
            });
        } else {
            this.mWSClient.send(cmd, new WSClient.WSClientSendHandler(){

                @Override
                public void onResult(SendBirdException e) {
                    if (e != null) {
                        if (handler != null) {
                            handler.onResult(null, e);
                        }
                        return;
                    }
                    if (handler != null) {
                        handler.onResult(null, null);
                    }
                }
            });
        }
    }

    private void startAckTimer(Command command, final Command.SendCommandHandler handler) {
        final String reqId = command.getRequestId();
        CountDownTimer timer = new CountDownTimer(10000, 100);
        timer.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

            @Override
            public void onStart() {
            }

            @Override
            public void onStop() {
                SendBird.this.mAckStateMap.remove(reqId);
            }

            @Override
            public void onCancel() {
                SendBird.this.mAckStateMap.remove(reqId);
            }

            @Override
            public void onTimeout() {
                handler.onResult(null, new SendBirdException("Command received no ack.", 800180));
            }

            @Override
            public void onTick(int timeout, int elapsed) {
            }
        });
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("handler", handler);
        map.put("timer", timer);
        this.mAckStateMap.put(reqId, map);
        timer.start();
    }

    private HashMap<String, Object> getAckInfo(String requestId) {
        return this.mAckStateMap.get(requestId);
    }

    static {
        sUIThreadHandler = new Handler(Looper.getMainLooper());
    }

    public static interface UserUnblockHandler {
        public void onUnblocked(SendBirdException var1);
    }

    public static interface UserBlockHandler {
        public void onBlocked(User var1, SendBirdException var2);
    }

    public static interface UserInfoUpdateHandler {
        public void onUpdated(SendBirdException var1);
    }

    public static interface UnregisterPushTokenHandler {
        public void onUnregistered(SendBirdException var1);
    }

    public static interface RegisterPushTokenHandler {
        public void onRegistered(SendBirdException var1);
    }

    public static interface DisconnectHandler {
        public void onDisconnected();
    }

    public static interface ConnectionHandler {
        public void onReconnectStarted();

        public void onReconnectSucceeded();

        public void onReconnectFailed();
    }

    public static abstract class ChannelHandler {
        public abstract void onMessageReceived(BaseChannel var1, BaseMessage var2);

        public void onMessageDeleted(BaseChannel channel, long msgId) {
        }

        public void onChannelChanged(BaseChannel channel) {
        }

        public void onChannelDeleted(String channelUrl, BaseChannel.ChannelType channelType) {
        }

        public void onReadReceiptUpdated(GroupChannel channel) {
        }

        public void onTypingStatusUpdated(GroupChannel channel) {
        }

        public void onUserJoined(GroupChannel channel, User user) {
        }

        public void onUserLeft(GroupChannel channel, User user) {
        }

        public void onUserEntered(OpenChannel channel, User user) {
        }

        public void onUserExited(OpenChannel channel, User user) {
        }

        public void onUserMuted(OpenChannel channel, User user) {
        }

        public void onUserUnmuted(OpenChannel channel, User user) {
        }

        public void onUserBanned(OpenChannel channel, User user) {
        }

        public void onUserUnbanned(OpenChannel channel, User user) {
        }

        public void onChannelFrozen(OpenChannel channel) {
        }

        public void onChannelUnfrozen(OpenChannel channel) {
        }
    }

    public static interface ConnectHandler {
        public void onConnected(User var1, SendBirdException var2);
    }

    public static enum ConnectionState {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

