/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.OpenChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class OpenChannelListQuery {
    private String mToken = "";
    private boolean mHasNext = true;
    private int mLimit = 20;
    private boolean mLoading = false;

    OpenChannelListQuery() {
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final OpenChannelListQueryResultHandler handler) {
        if (!this.hasNext()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new ArrayList<OpenChannel>(), null);
                    }
                });
            }
            return;
        }
        if (this.isLoading()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                });
            }
            return;
        }
        this.setLoading(true);
        APIClient.getInstance().loadOpenChannelList(this.mToken, this.mLimit, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                OpenChannelListQuery.this.setLoading(false);
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                OpenChannelListQuery.this.mToken = result.get("next").getAsString();
                if (OpenChannelListQuery.this.mToken == null || OpenChannelListQuery.this.mToken.length() <= 0) {
                    OpenChannelListQuery.this.mHasNext = false;
                }
                JsonArray channelObjs = result.get("channels").getAsJsonArray();
                final ArrayList<OpenChannel> channels = new ArrayList<OpenChannel>();
                for (int i = 0; i < channelObjs.size(); ++i) {
                    channels.add(OpenChannel.upsert(channelObjs.get(i)));
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channels, null);
                        }
                    });
                }
            }
        });
    }

    public static interface OpenChannelListQueryResultHandler {
        public void onResult(List<OpenChannel> var1, SendBirdException var2);
    }
}

