/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.FileMessage;
import com.sendbird.android.Logger;
import com.sendbird.android.User;
import com.sendbird.android.UserMessage;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;

public abstract class BaseMessage {
    protected long mMessageId;
    protected String mChannelUrl;
    protected String mChannelType;
    protected long mCreatedAt;

    protected static BaseMessage build(JsonElement el, BaseChannel channel) {
        try {
            String type;
            JsonObject obj = el.getAsJsonObject();
            switch (type = obj.get("type").getAsString()) {
                case "MESG": {
                    User user = new User(obj.get("user"));
                    long msgId = obj.get("message_id").getAsLong();
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    return new UserMessage(UserMessage.build("", msgId, user, channel, message, data, createdAt));
                }
                case "FILE": {
                    User user = new User(obj.get("user"));
                    long msgId = obj.get("message_id").getAsLong();
                    JsonObject file = obj.get("file").getAsJsonObject();
                    String url = file.get("url").getAsString();
                    String name = file.get("name").getAsString();
                    String fileType = file.get("type").getAsString();
                    int size = file.get("size").getAsInt();
                    String data = file.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    return new FileMessage(FileMessage.build("", msgId, user, channel, url, name, fileType, size, data, createdAt));
                }
                case "BRDM": 
                case "ADMM": {
                    long msgId = obj.get("message_id").getAsLong();
                    String message = obj.get("message").getAsString();
                    String data = obj.get("data").getAsString();
                    long createdAt = obj.get("created_at").getAsLong();
                    return new AdminMessage(AdminMessage.build(msgId, channel, message, data, createdAt));
                }
            }
            Logger.e("Unknown message type: " + type);
        }
        catch (Exception e) {
            Logger.e(e);
        }
        return null;
    }

    protected BaseMessage(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mMessageId = obj.has("msg_id") ? obj.get("msg_id").getAsLong() : 0L;
        this.mChannelUrl = obj.has("channel_url") ? obj.get("channel_url").getAsString() : "";
        this.mChannelType = obj.has("channel_type") ? obj.get("channel_type").getAsString() : "group";
        this.mCreatedAt = obj.has("ts") ? obj.get("ts").getAsLong() : 0L;
    }

    public long getMessageId() {
        return this.mMessageId;
    }

    public long getCreatedAt() {
        return this.mCreatedAt;
    }

    public String getChannelUrl() {
        return this.mChannelUrl;
    }

    public boolean isOpenChannel() {
        return this.mChannelType.equals("open");
    }

    public boolean isGroupChannel() {
        return this.mChannelType.equals("group");
    }
}

