/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.Command;
import com.sendbird.android.CountDownTimer;
import com.sendbird.android.Logger;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.shadow.okhttp3.OkHttpClient;
import com.sendbird.android.shadow.okhttp3.Request;
import com.sendbird.android.shadow.okhttp3.RequestBody;
import com.sendbird.android.shadow.okhttp3.Response;
import com.sendbird.android.shadow.okhttp3.ResponseBody;
import com.sendbird.android.shadow.okhttp3.ws.WebSocket;
import com.sendbird.android.shadow.okhttp3.ws.WebSocketCall;
import com.sendbird.android.shadow.okhttp3.ws.WebSocketListener;
import com.sendbird.android.shadow.okio.Buffer;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class WSClient {
    private WSClientHandler mHandler;
    private StringBuffer mRecvBuffer = new StringBuffer();
    private CountDownTimer mWatchdog = new CountDownTimer(5000);
    private CountDownTimer mPinger;
    private long mLastActiveMillis;
    private boolean mExplicitDisconnect;
    private Request mRequest;
    private ExecutorService mWriteExecutor;
    private OkHttpClient mOkHttpClient;
    private WebSocket mWebsocket;
    private WebSocketCall mWebsocketCall;

    public void setEventHandler(WSClientHandler handler) {
        this.mHandler = handler;
    }

    public WSClient() {
        this.mWatchdog.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

            @Override
            public void onStart() {
                Logger.d("Watchdog start.");
            }

            @Override
            public void onStop() {
                Logger.d("Watchdog stop.");
            }

            @Override
            public void onCancel() {
                Logger.d("Watchdog cancel.");
            }

            @Override
            public void onTimeout() {
                Logger.d("Watchdog timeout.");
                if (WSClient.this.mHandler != null) {
                    WSClient.this.mHandler.onError(new SendBirdException("Server is unreachable.", 800120));
                }
                WSClient.this.mHandler = null;
                WSClient.this.quit();
            }

            @Override
            public void onTick(int timeout, int elapsed) {
            }
        });
        this.mPinger = new CountDownTimer(1000, 100, true);
        this.mPinger.setEventHandler(new CountDownTimer.CountDownTimerEventHandler(){

            @Override
            public void onStart() {
                Logger.d("Pinger start.");
                WSClient.this.mWatchdog.stop();
            }

            @Override
            public void onStop() {
                Logger.d("Pinger stop.");
                WSClient.this.mWatchdog.stop();
            }

            @Override
            public void onCancel() {
                Logger.d("Pinger cancel.");
            }

            @Override
            public void onTimeout() {
                if (System.currentTimeMillis() - WSClient.this.mLastActiveMillis >= 15000L) {
                    WSClient.this.mLastActiveMillis = System.currentTimeMillis();
                    WSClient.this.send(Command.bPing(), null);
                    WSClient.this.mWatchdog.start();
                }
            }

            @Override
            public void onTick(int timeout, int elapsed) {
            }
        });
    }

    void initWebSocket() {
        APIClient.getInstance().checkRouting(new APIClient.CheckRoutingHandler(){

            @Override
            public void onResult(String apiHost, String wsHost, SendBirdException e) {
                block5: {
                    try {
                        if (e != null) {
                            if (WSClient.this.mHandler != null) {
                                WSClient.this.mHandler.onError(e);
                            }
                            return;
                        }
                        WSClient.this.mRequest = new Request.Builder().url(wsHost + "/?p=Android" + "&" + "pv=" + SendBird.getOSVersion() + "&" + "sv=" + SendBird.getSDKVersion() + "&" + "ai=" + SendBird.getApplicationId() + "&" + "key=" + APIClient.getInstance().getSessionKey()).build();
                        WSClient.this.mOkHttpClient = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
                        WSClient.this.mWriteExecutor = Executors.newSingleThreadExecutor();
                        if (WSClient.this.mHandler != null) {
                            WSClient.this.mHandler.onReady();
                        }
                    }
                    catch (Exception e1) {
                        if (WSClient.this.mHandler == null) break block5;
                        WSClient.this.mHandler.onError(new SendBirdException(e1.getMessage(), 800120));
                    }
                }
            }
        });
    }

    private void active() {
        this.mLastActiveMillis = System.currentTimeMillis();
        this.mWatchdog.stop();
    }

    public void connect() {
        if (this.mOkHttpClient != null) {
            this.mWebsocketCall = WebSocketCall.create(this.mOkHttpClient, this.mRequest);
            this.mWebsocketCall.enqueue(new WebSocketListener(){

                @Override
                public void onOpen(WebSocket webSocket, Response response) {
                    WSClient.this.mWebsocket = webSocket;
                    if (WSClient.this.mHandler != null) {
                        WSClient.this.mHandler.onOpen();
                    }
                    WSClient.this.mPinger.start();
                }

                @Override
                public void onFailure(IOException e, Response response) {
                    WSClient.this.mPinger.stop();
                    if (WSClient.this.mHandler != null) {
                        if (WSClient.this.mExplicitDisconnect) {
                            WSClient.this.mHandler.onClose();
                        } else {
                            WSClient.this.mHandler.onError(new SendBirdException(e.getMessage(), 800120));
                        }
                    }
                    WSClient.this.mHandler = null;
                    WSClient.this.quit();
                }

                @Override
                public void onMessage(ResponseBody recv) throws IOException {
                    int nl = -1;
                    WSClient.this.active();
                    WSClient.this.mRecvBuffer.append(recv.string());
                    recv.close();
                    while ((nl = WSClient.this.mRecvBuffer.indexOf("\n")) >= 0) {
                        String message = WSClient.this.mRecvBuffer.substring(0, nl);
                        WSClient.this.mRecvBuffer.delete(0, nl + 1);
                        if (WSClient.this.mHandler == null) continue;
                        Logger.d("Recv: " + message);
                        WSClient.this.mHandler.onMessage(message);
                    }
                }

                @Override
                public void onPong(Buffer payload) {
                }

                @Override
                public void onClose(int code, String reason) {
                    WSClient.this.mPinger.stop();
                    if (WSClient.this.mHandler != null) {
                        if (WSClient.this.mExplicitDisconnect) {
                            WSClient.this.mHandler.onClose();
                        } else {
                            WSClient.this.mHandler.onError(new SendBirdException("WS connection closed by server. " + code, 800200));
                        }
                    }
                    WSClient.this.mHandler = null;
                    WSClient.this.quit();
                }
            });
            this.mOkHttpClient.dispatcher().executorService().shutdown();
        }
    }

    public void disconnect() {
        this.mExplicitDisconnect = true;
        this.quit();
    }

    public SendBird.ConnectionState getConnectionState() {
        if (this.mOkHttpClient != null) {
            return SendBird.ConnectionState.OPEN;
        }
        return SendBird.ConnectionState.CLOSED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void quit() {
        this.mPinger.stop();
        if (this.mWriteExecutor != null) {
            try {
                this.mWriteExecutor.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mWriteExecutor = null;
            }
        }
        final WebSocket ws = this.mWebsocket;
        this.mWebsocket = null;
        this.mWebsocketCall = null;
        this.mOkHttpClient = null;
        try {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (ws != null) {
                            ws.close(1000, "");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
            t.start();
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void send(final Command command, final WSClientSendHandler handler) {
        Logger.d("Send: " + command.encode());
        if (this.mOkHttpClient != null && this.mWebsocket != null && this.mWriteExecutor != null) {
            try {
                this.mWriteExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            if (WSClient.this.mWebsocket != null) {
                                try {
                                    WSClient.this.mWebsocket.sendMessage(RequestBody.create(WebSocket.TEXT, command.encode()));
                                    if (handler != null) {
                                        handler.onResult(null);
                                    }
                                }
                                catch (IOException e) {
                                    if (handler == null) break block4;
                                    handler.onResult(new SendBirdException(e.getMessage(), 800210));
                                }
                            }
                        }
                    }
                });
            }
            catch (Exception e) {
                if (handler != null) {
                    handler.onResult(new SendBirdException(e.getMessage(), 800120));
                }
            }
        } else if (handler != null) {
            handler.onResult(new SendBirdException("Connection closed.", 800200));
        }
    }

    public static interface WSClientSendHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface WSClientHandler {
        public void onReady();

        public void onOpen();

        public void onClose();

        public void onMessage(String var1);

        public void onError(SendBirdException var1);
    }
}

