/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;

public final class UserListQuery {
    private QueryType mQueryType;
    private BaseChannel mChannel;
    private String mJsonArrayName;
    private String mToken = "";
    private int mLimit = 20;
    private boolean mHasNext = true;
    private boolean mLoading = false;
    private APIClient.APIClientHandler mApiClientHandler;

    UserListQuery(QueryType queryType) {
        this.mQueryType = queryType;
        switch (this.mQueryType) {
            case ALL_USER: 
            case BLOCKED_USER: {
                this.mJsonArrayName = "users";
                break;
            }
            case PARTICIPANT: {
                this.mJsonArrayName = "participants";
                break;
            }
            case MUTED_USER: {
                this.mJsonArrayName = "muted_list";
                break;
            }
            case BANNED_USER: {
                this.mJsonArrayName = "banned_list";
            }
        }
    }

    UserListQuery(QueryType queryType, BaseChannel channel) {
        this(queryType);
        this.mChannel = channel;
    }

    public void setLimit(int limit) {
        this.mLimit = limit;
    }

    public boolean hasNext() {
        return this.mHasNext;
    }

    public synchronized boolean isLoading() {
        return this.mLoading;
    }

    synchronized void setLoading(boolean tf) {
        this.mLoading = tf;
    }

    public synchronized void next(final UserListQueryResultHandler handler) {
        if (!this.hasNext()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new ArrayList<User>(), null);
                    }
                });
            }
            return;
        }
        if (this.isLoading()) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Query in progress.", 800170));
                    }
                });
            }
            return;
        }
        this.setLoading(true);
        this.mApiClientHandler = new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                UserListQuery.this.mApiClientHandler = null;
                UserListQuery.this.setLoading(false);
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                JsonObject result = response.getAsJsonObject();
                UserListQuery.this.mToken = result.get("next").getAsString();
                if (UserListQuery.this.mToken == null || UserListQuery.this.mToken.length() <= 0) {
                    UserListQuery.this.mHasNext = false;
                }
                JsonArray userObjs = result.get(UserListQuery.this.mJsonArrayName).getAsJsonArray();
                final ArrayList<User> users = new ArrayList<User>();
                for (int i = 0; i < userObjs.size(); ++i) {
                    if (UserListQuery.this.mQueryType != QueryType.BANNED_USER) {
                        users.add(new User(userObjs.get(i)));
                        continue;
                    }
                    users.add(new User(userObjs.get(i).getAsJsonObject().get("user")));
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(users, null);
                        }
                    });
                }
            }
        };
        switch (this.mQueryType) {
            case ALL_USER: {
                APIClient.getInstance().loadUserList(this.mToken, this.mLimit, this.mApiClientHandler);
                break;
            }
            case BLOCKED_USER: {
                if (SendBird.getCurrentUser() == null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, new SendBirdException("Connection must be made before you request the list.", 800101));
                            }
                        });
                    }
                    return;
                }
                APIClient.getInstance().loadBlockedUserList(SendBird.getCurrentUser().getUserId(), this.mToken, this.mLimit, this.mApiClientHandler);
                break;
            }
            case PARTICIPANT: {
                APIClient.getInstance().loadOpenChannelParticipantList(this.mChannel.getUrl(), this.mToken, this.mLimit, this.mApiClientHandler);
                break;
            }
            case MUTED_USER: {
                APIClient.getInstance().loadOpenChannelMutedList(this.mChannel.getUrl(), this.mToken, this.mLimit, this.mApiClientHandler);
                break;
            }
            case BANNED_USER: {
                APIClient.getInstance().loadOpenChannelBanList(this.mChannel.getUrl(), this.mToken, this.mLimit, this.mApiClientHandler);
            }
        }
    }

    public static interface UserListQueryResultHandler {
        public void onResult(List<User> var1, SendBirdException var2);
    }

    static enum QueryType {
        ALL_USER,
        BLOCKED_USER,
        PARTICIPANT,
        MUTED_USER,
        BANNED_USER;

    }
}

