/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.android;

import com.sendbird.android.APIClient;
import com.sendbird.android.AdminMessage;
import com.sendbird.android.BaseChannel;
import com.sendbird.android.BaseMessage;
import com.sendbird.android.Command;
import com.sendbird.android.GroupChannelListQuery;
import com.sendbird.android.SendBird;
import com.sendbird.android.SendBirdException;
import com.sendbird.android.User;
import com.sendbird.android.shadow.com.google.gson.JsonArray;
import com.sendbird.android.shadow.com.google.gson.JsonElement;
import com.sendbird.android.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class GroupChannel
extends BaseChannel {
    protected static final ConcurrentHashMap<String, GroupChannel> sCachedChannels = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Long> mCachedTypingStatus = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Long> mCachedReadReceiptStatus;
    protected boolean mIsDistinct;
    protected int mUnreadMessageCount;
    protected List<User> mMembers;
    protected HashMap<String, User> mMemberMap;
    protected BaseMessage mLastMessage;
    protected int mMemberCount;
    protected static long sMarkAsReadAllLastSentAt;
    protected long mStartTypingLastSentAt;
    protected long mEndTypingLastSentAt;
    protected long mMarkAsReadLastSentAt;
    protected boolean mMarkAsReadScheduled;

    static synchronized void removeChannelFromCache(String channelUrl) {
        sCachedChannels.remove(channelUrl);
    }

    public void refresh(final GroupChannelRefreshHandler handler) {
        GroupChannel.getChannelWithoutCache(this.getUrl(), new GroupChannelGetHandler(){

            @Override
            public void onResult(GroupChannel channel, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static GroupChannelListQuery createMyGroupChannelListQuery() {
        if (SendBird.getCurrentUser() == null) {
            return null;
        }
        return new GroupChannelListQuery(SendBird.getCurrentUser());
    }

    public static void createChannel(List<User> users, boolean isDistinct, final GroupChannelCreateHandler handler) {
        if (users == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            if (user == null) continue;
            userIds.add(user.getUserId());
        }
        GroupChannel.createChannelWithUserIds(userIds, isDistinct, null, null, null, handler);
    }

    public static void createChannel(List<User> users, boolean isDistinct, String name, String coverUrl, String data, final GroupChannelCreateHandler handler) {
        if (users == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            if (user == null) continue;
            userIds.add(user.getUserId());
        }
        GroupChannel.createChannelWithUserIds(userIds, isDistinct, name, coverUrl, data, handler);
    }

    public static void createChannelWithUserIds(List<String> userIds, boolean isDistinct, GroupChannelCreateHandler handler) {
        GroupChannel.createChannelWithUserIds(userIds, isDistinct, null, null, null, handler);
    }

    public static void createChannelWithUserIds(List<String> userIds, boolean isDistinct, String name, String coverUrl, String data, final GroupChannelCreateHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Connection must be made before you create channel.", 800101));
                    }
                });
            }
            return;
        }
        if (userIds == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        LinkedHashSet<String> userIdSet = new LinkedHashSet<String>(userIds);
        User me = SendBird.getCurrentUser();
        userIdSet.add(me.getUserId());
        userIds = new ArrayList<String>(userIdSet);
        APIClient.getInstance().createGroupChannel(userIds, isDistinct, name, coverUrl, data, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(null, e);
                            }
                        });
                    }
                    return;
                }
                final GroupChannel channel = GroupChannel.upsert(response);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(channel, null);
                        }
                    });
                }
            }
        });
    }

    protected static void getChannelWithoutCache(final String channelUrl, final GroupChannelGetHandler handler) {
        APIClient.getInstance().getGroupChannel(channelUrl, true, true, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        handler.onResult(null, e);
                    }
                    return;
                }
                GroupChannel.upsert(response);
                if (handler != null) {
                    handler.onResult(sCachedChannels.get(channelUrl), null);
                }
            }
        });
    }

    public static void getChannel(final String channelUrl, final GroupChannelGetHandler handler) {
        if (channelUrl == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(null, new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        if (sCachedChannels.containsKey(channelUrl)) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(sCachedChannels.get(channelUrl), null);
                    }
                });
            }
        } else {
            GroupChannel.getChannelWithoutCache(channelUrl, new GroupChannelGetHandler(){

                @Override
                public void onResult(final GroupChannel channel, final SendBirdException e) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(channel, e);
                            }
                        });
                    }
                }
            });
        }
    }

    protected static synchronized GroupChannel upsert(JsonElement el) {
        String channelUrl = el.getAsJsonObject().get("channel_url").getAsString();
        if (sCachedChannels.containsKey(channelUrl)) {
            sCachedChannels.get(channelUrl).update(el);
        } else {
            sCachedChannels.put(channelUrl, new GroupChannel(el));
        }
        return sCachedChannels.get(channelUrl);
    }

    protected GroupChannel(JsonElement el) {
        super(el);
    }

    @Override
    protected void update(JsonElement el) {
        super.update(el);
        this.parse(el);
    }

    private void parse(JsonElement el) {
        JsonObject obj = el.getAsJsonObject();
        this.mIsDistinct = obj.get("is_distinct").getAsBoolean();
        this.mUnreadMessageCount = obj.get("unread_message_count").getAsInt();
        if (this.mCachedReadReceiptStatus != null) {
            this.mCachedReadReceiptStatus.clear();
        } else {
            this.mCachedReadReceiptStatus = new ConcurrentHashMap();
        }
        if (obj.has("read_receipt")) {
            JsonObject readReceiptObj = obj.get("read_receipt").getAsJsonObject();
            for (Map.Entry<String, JsonElement> entry : readReceiptObj.entrySet()) {
                this.updateReadReceipt(entry.getKey(), entry.getValue().getAsLong());
            }
        }
        if (obj.has("members")) {
            if (this.mMembers != null) {
                this.mMembers.clear();
            } else {
                this.mMembers = new ArrayList<User>();
            }
            if (this.mMemberMap != null) {
                this.mMemberMap.clear();
            } else {
                this.mMemberMap = new HashMap();
            }
            JsonArray objMembers = obj.get("members").getAsJsonArray();
            for (int i = 0; i < objMembers.size(); ++i) {
                User member = new User(objMembers.get(i));
                this.mMembers.add(member);
                this.mMemberMap.put(member.getUserId(), member);
            }
            this.mMemberCount = this.mMembers.size();
        }
        if (obj.has("member_count")) {
            this.mMemberCount = obj.get("member_count").getAsInt();
        }
        this.mLastMessage = obj.has("last_message") && obj.get("last_message").isJsonObject() ? BaseMessage.build(obj.get("last_message"), this) : null;
    }

    public BaseMessage getLastMessage() {
        return this.mLastMessage;
    }

    protected synchronized void setLastMessage(BaseMessage lastMessage) {
        this.mLastMessage = lastMessage;
    }

    public int getUnreadMessageCount() {
        return this.mUnreadMessageCount;
    }

    protected synchronized void setUnreadMessageCount(int count) {
        this.mUnreadMessageCount = count;
    }

    public List<User> getMembers() {
        return this.mMembers;
    }

    public int getMemberCount() {
        return this.mMemberCount;
    }

    public boolean isDistinct() {
        return this.mIsDistinct;
    }

    public void invite(User user, final GroupChannelInviteHandler handler) {
        if (user == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(user.getUserId());
        this.inviteWithUserIds(userIds, handler);
    }

    public void invite(List<User> users, final GroupChannelInviteHandler handler) {
        if (users == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        for (User user : users) {
            userIds.add(user.getUserId());
        }
        this.inviteWithUserIds(userIds, handler);
    }

    public void inviteWithUserId(String userId, final GroupChannelInviteHandler handler) {
        if (userId == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        ArrayList<String> userIds = new ArrayList<String>();
        userIds.add(userId);
        this.inviteWithUserIds(userIds, handler);
    }

    public void inviteWithUserIds(List<String> userIds, final GroupChannelInviteHandler handler) {
        if (userIds == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Invalid arguments.", 800110));
                    }
                });
            }
            return;
        }
        LinkedHashSet<String> userIdSet = new LinkedHashSet<String>(userIds);
        userIds = new ArrayList<String>(userIdSet);
        APIClient.getInstance().groupChannelInvite(this.getUrl(), userIds, new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.upsert(response);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void hide(final GroupChannelHideHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Connection must be made before you hide channel.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().groupChannelHide(this.getUrl(), SendBird.getCurrentUser().getUserId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void leave(final GroupChannelLeaveHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Connection must be made before you leave channel.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().groupChannelLeave(this.getUrl(), SendBird.getCurrentUser().getUserId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public static void markAsReadAll(final GroupChannelMarkAsReadHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Connection must be made before you mark as read all.", 800101));
                    }
                });
            }
            return;
        }
        if (System.currentTimeMillis() - sMarkAsReadAllLastSentAt < 1000L) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("MarkAsRead rate limit exceeded.", 800160));
                    }
                });
            }
            return;
        }
        sMarkAsReadAllLastSentAt = System.currentTimeMillis();
        APIClient.getInstance().groupChannelMarkAsReadAll(SendBird.getCurrentUser().getUserId(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                for (GroupChannel channel : sCachedChannels.values()) {
                    channel.setUnreadMessageCount(0);
                }
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    protected void sendMarkAsRead(final GroupChannelMarkAsReadHandler handler) {
        if (SendBird.getCurrentUser() == null) {
            if (handler != null) {
                SendBird.runOnUIThread(new Runnable(){

                    @Override
                    public void run() {
                        handler.onResult(new SendBirdException("Connection must be made before you mark as read.", 800101));
                    }
                });
            }
            return;
        }
        APIClient.getInstance().groupChannelMarkAsRead(this.getUrl(), SendBird.getCurrentUser().getUserId(), System.currentTimeMillis(), new APIClient.APIClientHandler(){

            @Override
            public void onResult(JsonElement response, final SendBirdException e) {
                if (e != null) {
                    if (handler != null) {
                        SendBird.runOnUIThread(new Runnable(){

                            @Override
                            public void run() {
                                handler.onResult(e);
                            }
                        });
                    }
                    return;
                }
                GroupChannel.this.setUnreadMessageCount(0);
                if (handler != null) {
                    SendBird.runOnUIThread(new Runnable(){

                        @Override
                        public void run() {
                            handler.onResult(null);
                        }
                    });
                }
            }
        });
    }

    public void markAsRead() {
        this.mMarkAsReadScheduled = true;
    }

    protected void fireMarkAsRead() {
        if (this.mMarkAsReadScheduled) {
            this.sendMarkAsRead(null);
            this.mMarkAsReadScheduled = false;
        }
    }

    public int getReadReceipt(BaseMessage message) {
        if (message == null || message instanceof AdminMessage) {
            return 0;
        }
        User me = SendBird.getCurrentUser();
        if (me == null) {
            return 0;
        }
        int unreadMemberCount = 0;
        long createdAt = message.getCreatedAt();
        List<User> members = this.getMembers();
        for (User member : members) {
            String key = member.getUserId();
            if (me.getUserId().equals(key)) continue;
            Long value = this.mCachedReadReceiptStatus.get(key);
            if (value == null) {
                value = 0L;
            }
            if (value >= createdAt) continue;
            ++unreadMemberCount;
        }
        return unreadMemberCount;
    }

    protected synchronized void updateReadReceipt(String userId, long timestamp) {
        String key = userId;
        Long value = this.mCachedReadReceiptStatus.get(key);
        long newValue = timestamp;
        if (value == null || value < newValue) {
            this.mCachedReadReceiptStatus.put(key, newValue);
        }
    }

    public void startTyping() {
        if (System.currentTimeMillis() - this.mStartTypingLastSentAt < 1000L) {
            return;
        }
        this.mEndTypingLastSentAt = 0L;
        this.mStartTypingLastSentAt = System.currentTimeMillis();
        Command cmd = Command.bTypeStart(this.getUrl(), this.mStartTypingLastSentAt);
        SendBird.getInstance().sendCommand(cmd, null);
    }

    public void endTyping() {
        if (System.currentTimeMillis() - this.mEndTypingLastSentAt < 1000L) {
            return;
        }
        this.mStartTypingLastSentAt = 0L;
        this.mEndTypingLastSentAt = System.currentTimeMillis();
        Command cmd = Command.bTypeEnd(this.getUrl(), this.mEndTypingLastSentAt);
        SendBird.getInstance().sendCommand(cmd, null);
    }

    protected synchronized boolean invalidateTypingStatus() {
        boolean removed = false;
        long now = System.currentTimeMillis();
        for (Map.Entry<String, Long> entry : this.mCachedTypingStatus.entrySet()) {
            if (now - entry.getValue() < 10000L) continue;
            this.mCachedTypingStatus.remove(entry.getKey());
            removed = true;
        }
        return removed;
    }

    protected synchronized void updateTypingStatus(User user, boolean start) {
        if (start) {
            this.mCachedTypingStatus.put(user.getUserId(), System.currentTimeMillis());
        } else {
            this.mCachedTypingStatus.remove(user.getUserId());
        }
    }

    public boolean isTyping() {
        return this.mCachedTypingStatus.size() > 0;
    }

    public List<User> getTypingMembers() {
        ArrayList<User> result = new ArrayList<User>();
        for (String userId : this.mCachedTypingStatus.keySet()) {
            User user = this.mMemberMap.get(userId);
            if (user == null) continue;
            result.add(user);
        }
        return result;
    }

    protected synchronized void addMember(User user) {
        this.removeMember(user);
        this.mMemberMap.put(user.getUserId(), user);
        this.mMembers.add(user);
        ++this.mMemberCount;
        this.updateReadReceipt(user.getUserId(), 0L);
    }

    protected synchronized void removeMember(User user) {
        if (this.mMemberMap.containsKey(user.getUserId())) {
            this.mMembers.remove(this.mMemberMap.remove(user.getUserId()));
            --this.mMemberCount;
        }
    }

    public static interface GroupChannelGetHandler {
        public void onResult(GroupChannel var1, SendBirdException var2);
    }

    public static interface GroupChannelMarkAsReadHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelLeaveHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelInviteHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelHideHandler {
        public void onResult(SendBirdException var1);
    }

    public static interface GroupChannelCreateHandler {
        public void onResult(GroupChannel var1, SendBirdException var2);
    }

    public static interface GroupChannelRefreshHandler {
        public void onResult(SendBirdException var1);
    }
}

