/*
 * Decompiled with CFR 0.152.
 */
package com.semanticcms.dia.servlet;

import com.aoindustries.io.FileUtils;
import com.semanticcms.core.model.Book;
import com.semanticcms.core.model.PageRef;
import com.semanticcms.core.servlet.SemanticCMS;
import com.semanticcms.dia.servlet.impl.DiaExport;
import com.semanticcms.dia.servlet.impl.DiaImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@WebServlet(value={"/semanticcms-dia-servlet/dia-export/*"})
public class DiaExportServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String SERVLET_PATH = "/semanticcms-dia-servlet/dia-export";

    private DiaExport getThumbnail(HttpServletRequest request) throws IOException, ServletException {
        Integer width;
        Integer height;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        if (!pathInfo.endsWith(".png")) {
            return null;
        }
        int dimSepPos = pathInfo.lastIndexOf(120, pathInfo.length() - ".png".length() - 1);
        if (dimSepPos == -1) {
            return null;
        }
        String heightStr = pathInfo.substring(dimSepPos + 1, pathInfo.length() - ".png".length());
        if (heightStr.length() == 1 && heightStr.charAt(0) == '_') {
            height = null;
        } else {
            try {
                height = Integer.parseInt(heightStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        int sizeSepPos = pathInfo.lastIndexOf(45, dimSepPos - 1);
        if (sizeSepPos == -1) {
            return null;
        }
        String widthStr = pathInfo.substring(sizeSepPos + 1, dimSepPos);
        if (widthStr.length() == 1 && widthStr.charAt(0) == '_') {
            width = null;
        } else {
            try {
                width = Integer.parseInt(widthStr);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        if (width == null && height == null) {
            return null;
        }
        String combinedPath = pathInfo.substring(0, sizeSepPos) + ".dia";
        Book book = SemanticCMS.getInstance((ServletContext)this.getServletContext()).getBook(combinedPath);
        if (book == null) {
            return null;
        }
        PageRef pageRef = new PageRef(book, combinedPath.substring(book.getPathPrefix().length()));
        try {
            return DiaImpl.exportDiagram(pageRef, width, height, (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir"));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ServletException((Throwable)e);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    protected long getLastModified(HttpServletRequest request) {
        try {
            DiaExport thumbnail = this.getThumbnail(request);
            if (thumbnail == null) {
                return -1L;
            }
            long lastModified = thumbnail.getTmpFile().lastModified();
            return lastModified == 0L ? -1L : lastModified;
        }
        catch (IOException | ServletException e) {
            this.getServletContext().log(null, e);
            return -1L;
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        DiaExport thumbnail = this.getThumbnail(request);
        if (thumbnail == null) {
            response.sendError(404);
        } else {
            response.resetBuffer();
            response.setContentType("image/png");
            long length = thumbnail.getTmpFile().length();
            if (length > 0L && length <= Integer.MAX_VALUE) {
                response.setContentLength((int)length);
            }
            ServletOutputStream out = response.getOutputStream();
            FileUtils.copy((File)thumbnail.getTmpFile(), (OutputStream)out);
        }
    }
}

