/*
 * Decompiled with CFR 0.152.
 */
package com.semanticcms.dia.servlet.impl;

import com.aoindustries.awt.image.ImageSizeCache;
import com.aoindustries.encoding.TextInJavaScriptEncoder;
import com.aoindustries.encoding.TextInXhtmlAttributeEncoder;
import com.aoindustries.encoding.TextInXhtmlEncoder;
import com.aoindustries.io.FileUtils;
import com.aoindustries.lang.ProcessResult;
import com.aoindustries.net.UrlUtils;
import com.aoindustries.servlet.http.LastModifiedServlet;
import com.aoindustries.util.Sequence;
import com.aoindustries.util.UnsynchronizedSequence;
import com.aoindustries.util.WrappedException;
import com.aoindustries.util.concurrent.ConcurrencyLimiter;
import com.semanticcms.core.model.Page;
import com.semanticcms.core.model.PageRef;
import com.semanticcms.core.servlet.CaptureLevel;
import com.semanticcms.core.servlet.CountConcurrencyFilter;
import com.semanticcms.core.servlet.PageIndex;
import com.semanticcms.core.servlet.PageRefResolver;
import com.semanticcms.dia.model.Dia;
import com.semanticcms.dia.servlet.impl.DiaExport;
import java.awt.Dimension;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class DiaImpl {
    private static final String LINUX_DIA_PATH = "/usr/bin/dia";
    private static final String WINDOWS_DIA_PATH = "C:\\Program Files (x86)\\Dia\\bin\\dia.exe";
    private static final TempDirLock tempDirLock = new TempDirLock();
    private static final String TEMP_SUBDIR = DiaExport.class.getName();
    private static final String MISSING_IMAGE_PATH = "/semanticcms-dia-servlet/images/broken-chain-1164481-640x480.jpg";
    private static final int MISSING_IMAGE_WIDTH = 640;
    private static final int MISSING_IMAGE_HEIGHT = 480;
    public static final char SIZE_SEPARATOR = '-';
    public static final char EMPTY_SIZE = '_';
    public static final char DIMENSION_SEPARATOR = 'x';
    public static final String PNG_EXTENSION = ".png";
    private static final String ID_SEQUENCE_REQUEST_ATTRIBUTE_NAME = DiaImpl.class.getName() + ".idSequence";
    private static final String ALT_LINK_ID_PREFIX = "semanticcms-dia-servlet-alt-pixel-ratio-";
    private static final int DEFAULT_WIDTH = 200;
    private static final int[] PIXEL_DENSITIES = new int[]{1, 2, 3, 4};
    private static final ConcurrencyLimiter<File, Void> exportConcurrencyLimiter = new ConcurrencyLimiter();

    private static boolean isWindows() {
        String osName = System.getProperty("os.name");
        return osName != null && osName.toLowerCase(Locale.ROOT).contains("windows");
    }

    private static String getDiaExportPath() {
        if (DiaImpl.isWindows()) {
            return WINDOWS_DIA_PATH;
        }
        return LINUX_DIA_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiaExport exportDiagram(PageRef pageRef, final Integer width, final Integer height, File tmpDir) throws InterruptedException, FileNotFoundException, IOException {
        File tmpFile;
        final File diaFile = pageRef.getResourceFile(true, true);
        String diaPath = pageRef.getPath();
        if (diaPath.toLowerCase(Locale.ROOT).endsWith(".dia")) {
            diaPath = diaPath.substring(0, diaPath.length() - ".dia".length());
        }
        TempDirLock tempDirLock = DiaImpl.tempDirLock;
        synchronized (tempDirLock) {
            tmpFile = new File(tmpDir, TEMP_SUBDIR + pageRef.getBookPrefix().replace('/', File.separatorChar) + diaPath.replace('/', File.separatorChar) + "-" + (width == null ? "_" : width.toString()) + "x" + (height == null ? "_" : height.toString()) + PNG_EXTENSION);
            tmpDir = tmpFile.getParentFile();
            if (!tmpDir.exists()) {
                FileUtils.mkdirs((File)tmpDir);
            }
        }
        try {
            exportConcurrencyLimiter.executeSerialized((Object)tmpFile, (Callable)new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    if (!tmpFile.exists() || diaFile.lastModified() >= tmpFile.lastModified()) {
                        String sizeParam = width == null ? (height == null ? null : "x" + height) : (height == null ? width + "x" : width + "x" + height);
                        String diaExePath = DiaImpl.getDiaExportPath();
                        String[] command = sizeParam == null ? new String[]{diaExePath, "--export=" + tmpFile.getCanonicalPath(), "--filter=png", "--log-to-stderr", diaFile.getCanonicalPath()} : new String[]{diaExePath, "--export=" + tmpFile.getCanonicalPath(), "--filter=png", "--size=" + sizeParam, "--log-to-stderr", diaFile.getCanonicalPath()};
                        ProcessResult result = ProcessResult.exec((String[])command);
                        int exitVal = result.getExitVal();
                        if (exitVal != 0) {
                            throw new IOException(diaExePath + ": non-zero exit value: " + exitVal);
                        }
                        if (!DiaImpl.isWindows()) {
                            String normalOutput = diaFile.getCanonicalPath() + " --> " + tmpFile.getCanonicalPath();
                            boolean foundNormalOutput = false;
                            String stderr = result.getStderr();
                            try (BufferedReader errIn = new BufferedReader(new StringReader(stderr));){
                                String line;
                                while ((line = errIn.readLine()) != null) {
                                    if (!line.equals(normalOutput)) continue;
                                    foundNormalOutput = true;
                                    break;
                                }
                            }
                            if (!foundNormalOutput) {
                                throw new IOException(diaExePath + ": " + stderr);
                            }
                        }
                    }
                    return null;
                }
            });
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new WrappedException((Throwable)e);
        }
        Dimension pngSize = ImageSizeCache.getImageSize((File)tmpFile);
        return new DiaExport(tmpFile, pngSize.width, pngSize.height);
    }

    private static String buildUrlPath(HttpServletRequest request, PageRef pageRef, int width, int height, int pixelDensity, DiaExport export) throws ServletException {
        String diaPath = pageRef.getPath();
        if (!diaPath.endsWith(".dia")) {
            throw new ServletException("Unexpected file extension for diagram: " + diaPath);
        }
        diaPath = diaPath.substring(0, diaPath.length() - ".dia".length());
        StringBuilder urlPath = new StringBuilder();
        urlPath.append(request.getContextPath()).append("/semanticcms-dia-servlet/dia-export").append(pageRef.getBookPrefix()).append(diaPath).append('-');
        if (width == 0) {
            urlPath.append('_');
        } else {
            urlPath.append(width * pixelDensity);
        }
        urlPath.append('x');
        if (height == 0) {
            urlPath.append('_');
        } else {
            urlPath.append(height * pixelDensity);
        }
        urlPath.append(PNG_EXTENSION);
        if (!"false".equalsIgnoreCase(request.getHeader("X-com-aoindustries-servlet-http-LastModifiedServlet-lastModified"))) {
            urlPath.append('?').append("lastModified").append('=').append(LastModifiedServlet.encodeLastModified((long)export.getTmpFile().lastModified()));
        }
        return urlPath.toString();
    }

    public static void writeDiaImpl(ServletContext servletContext, HttpServletRequest request, HttpServletResponse response, Appendable out, Dia dia) throws ServletException, IOException {
        block20: {
            try {
                List exports;
                File resourceFile;
                CaptureLevel captureLevel = CaptureLevel.getCaptureLevel((ServletRequest)request);
                if (captureLevel.compareTo((Enum)CaptureLevel.META) < 0) break block20;
                final PageRef pageRef = PageRefResolver.getPageRef((ServletContext)servletContext, (HttpServletRequest)request, (String)dia.getBook(), (String)dia.getPath());
                if (captureLevel != CaptureLevel.BODY) break block20;
                String responseEncoding = response.getCharacterEncoding();
                int width = dia.getWidth();
                int height = dia.getHeight();
                if (width == 0 && height == 0) {
                    width = 200;
                }
                if ((resourceFile = pageRef.getResourceFile(false, true)) == null) {
                    exports = null;
                } else {
                    final File tempDir = (File)servletContext.getAttribute("javax.servlet.context.tempdir");
                    final int finalWidth = width;
                    final int finalHeight = height;
                    ArrayList<2> tasks = new ArrayList<2>(PIXEL_DENSITIES.length);
                    for (int i = 0; i < PIXEL_DENSITIES.length; ++i) {
                        final int pixelDensity = PIXEL_DENSITIES[i];
                        tasks.add(new Callable<DiaExport>(){

                            @Override
                            public DiaExport call() throws InterruptedException, IOException {
                                return DiaImpl.exportDiagram(pageRef, finalWidth == 0 ? null : Integer.valueOf(finalWidth * pixelDensity), finalHeight == 0 ? null : Integer.valueOf(finalHeight * pixelDensity), tempDir);
                            }
                        });
                    }
                    try {
                        exports = CountConcurrencyFilter.getRecommendedExecutor((ServletContext)servletContext, (ServletRequest)request).callAll(tasks);
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof RuntimeException) {
                            throw (RuntimeException)cause;
                        }
                        if (cause instanceof InterruptedException) {
                            throw (InterruptedException)cause;
                        }
                        if (cause instanceof IOException) {
                            throw (IOException)cause;
                        }
                        throw new WrappedException((Throwable)e);
                    }
                }
                DiaExport export = exports == null ? null : (DiaExport)exports.get(0);
                Sequence idSequence = (Sequence)request.getAttribute(ID_SEQUENCE_REQUEST_ATTRIBUTE_NAME);
                if (idSequence == null) {
                    idSequence = new UnsynchronizedSequence();
                    request.setAttribute(ID_SEQUENCE_REQUEST_ATTRIBUTE_NAME, (Object)idSequence);
                }
                String refId = PageIndex.getRefIdInPage((ServletContext)servletContext, (HttpServletRequest)request, (Page)dia.getPage(), (String)dia.getId());
                out.append("<img id=\"");
                TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)refId, (Appendable)out);
                out.append("\" src=\"");
                String urlPath = export != null ? DiaImpl.buildUrlPath(request, pageRef, width, height, PIXEL_DENSITIES[0], export) : request.getContextPath() + MISSING_IMAGE_PATH;
                TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)response.encodeURL(UrlUtils.encodeUrlPath((String)urlPath, (String)responseEncoding)), (Appendable)out);
                out.append("\" width=\"");
                TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)Integer.toString(export != null ? export.getWidth() / PIXEL_DENSITIES[0] : (width != 0 ? width : 640 * height / 480)), (Appendable)out);
                out.append("\" height=\"");
                TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)Integer.toString(export != null ? export.getHeight() / PIXEL_DENSITIES[0] : (height != 0 ? height : 480 * width / 640)), (Appendable)out);
                out.append("\" alt=\"");
                TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)dia.getLabel(), (Appendable)out);
                out.append("\" />");
                if (export != null && PIXEL_DENSITIES.length > 1) {
                    int i;
                    assert (resourceFile != null);
                    assert (exports != null);
                    long[] altLinkNums = new long[PIXEL_DENSITIES.length];
                    for (i = 0; i < PIXEL_DENSITIES.length; ++i) {
                        long altLinkNum;
                        int pixelDensity = PIXEL_DENSITIES[i];
                        DiaExport altExport = (DiaExport)exports.get(i);
                        out.append("<a id=\"semanticcms-dia-servlet-alt-pixel-ratio-");
                        altLinkNums[i] = altLinkNum = idSequence.getNextSequenceValue();
                        out.append(Long.toString(altLinkNum));
                        out.append("\" style=\"display:none\" href=\"");
                        String altUrlPath = DiaImpl.buildUrlPath(request, pageRef, width, height, pixelDensity, altExport);
                        TextInXhtmlAttributeEncoder.encodeTextInXhtmlAttribute((CharSequence)response.encodeURL(UrlUtils.encodeUrlPath((String)altUrlPath, (String)responseEncoding)), (Appendable)out);
                        out.append("\">x");
                        TextInXhtmlEncoder.encodeTextInXhtml((CharSequence)Integer.toString(pixelDensity), (Appendable)out);
                        out.append("</a>");
                    }
                    out.append("<script type=\"text/javascript\">\n// <![CDATA[\n");
                    out.append("if(window.devicePixelRatio) {\n");
                    out.append("\t(function () {\n");
                    out.append("\t\tfunction updateImageSrc() {\n");
                    for (i = PIXEL_DENSITIES.length - 1; i >= 0; --i) {
                        long altLinkNum = altLinkNums[i];
                        out.append("\t\t\t");
                        if (i != PIXEL_DENSITIES.length - 1) {
                            out.append("else ");
                        }
                        if (i > 0) {
                            out.append("if(window.devicePixelRatio > ").append(Integer.toString(PIXEL_DENSITIES[i - 1])).append(") ");
                        }
                        out.append("{\n\t\t\t\tdocument.getElementById(\"");
                        TextInJavaScriptEncoder.encodeTextInJavaScript((CharSequence)refId, (Appendable)out);
                        out.append("\").src = document.getElementById(\"semanticcms-dia-servlet-alt-pixel-ratio-").append(Long.toString(altLinkNum)).append("\").getAttribute(\"href\");\n\t\t\t}\n");
                    }
                    out.append("\t\t}\n\t\tupdateImageSrc();\n");
                    out.append("\t\tif(window.matchMedia) {\n");
                    for (i = 0; i < PIXEL_DENSITIES.length; ++i) {
                        int pixelDensity = PIXEL_DENSITIES[i];
                        out.append("\t\t\twindow.matchMedia(\"screen and (max-resolution: ").append(Integer.toString(pixelDensity)).append("dppx)\").addListener(function(e) {\n\t\t\t\tupdateImageSrc();\n\t\t\t});\n");
                    }
                    out.append("\t\t}\n\t})();\n}\n// ]]>\n</script>");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ServletException((Throwable)e);
            }
        }
    }

    private DiaImpl() {
    }

    private static class TempDirLock {
        private TempDirLock() {
        }
    }
}

