/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.ipc;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.internal.ipc.MemoryFileBuffer;
import java.io.IOException;

public class MemoryFileBufferQueue {
    private static final String TAG = "MemoryFileBufferQueue";
    private static final int BUFFER_SIZE = 5;
    private MemoryFileBuffer[] mMemoryFileBuffers = new MemoryFileBuffer[5];
    private long[] mMemoryFileBufferUseTime = new long[5];
    private int mImageSize;
    private int mLogCount;
    private int mAcquired;
    private int mReleased;

    public MemoryFileBufferQueue(int imageSize) throws IOException {
        this.mImageSize = imageSize;
        for (int i = 0; i < this.mMemoryFileBuffers.length; ++i) {
            this.mMemoryFileBuffers[i] = new MemoryFileBuffer(imageSize, i);
            Logger.i((String)TAG, (String)" new MemoryFileBuffer in Queue constructor.");
        }
    }

    public MemoryFileBuffer next() {
        ++this.mLogCount;
        if (this.mLogCount > 100) {
            this.mLogCount = 0;
            Logger.v((String)TAG, (String)this.countUsage());
        }
        for (int i = 0; i < 5; ++i) {
            MemoryFileBuffer memoryFileBuffer = this.mMemoryFileBuffers[i];
            if (memoryFileBuffer.isDirty()) continue;
            memoryFileBuffer.setDirty(true);
            ++this.mAcquired;
            this.mMemoryFileBufferUseTime[i] = System.currentTimeMillis();
            return memoryFileBuffer;
        }
        int index = 0;
        long least = Long.MAX_VALUE;
        for (int i = 0; i < 5; ++i) {
            if (this.mMemoryFileBufferUseTime[i] >= least) continue;
            least = this.mMemoryFileBufferUseTime[i];
            index = i;
        }
        Logger.w((String)TAG, (String)("memory file buffer used up, swap new, index = " + index));
        try {
            Logger.i((String)TAG, (String)"new MemoryFileBuffer in swap.");
            MemoryFileBuffer newMemoryFileBuffer = new MemoryFileBuffer(this.mImageSize, index);
            MemoryFileBuffer memoryFileBuffer = this.mMemoryFileBuffers[index];
            Logger.i((String)TAG, (String)"close old MemoryFile.");
            memoryFileBuffer.getImageMemoryFile().close();
            memoryFileBuffer.getInfoMemoryFile().close();
            this.mMemoryFileBuffers[index] = newMemoryFileBuffer;
            Logger.i((String)TAG, (String)"swap done.");
            this.mMemoryFileBufferUseTime[index] = System.currentTimeMillis();
            return newMemoryFileBuffer;
        }
        catch (IOException e) {
            Logger.e((String)TAG, (String)"create new memory file error", (Throwable)e);
            return null;
        }
    }

    private String countUsage() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("count usage size = (" + this.mImageSize + ") usage:");
        int count = 0;
        for (MemoryFileBuffer memoryFileBuffer : this.mMemoryFileBuffers) {
            if (memoryFileBuffer.isDirty()) {
                ++count;
                stringBuffer.append("[1]");
                continue;
            }
            stringBuffer.append("[0]");
        }
        stringBuffer.append(" buffer used:" + count);
        stringBuffer.append("\n").append("acquired:" + this.mAcquired).append(" released:" + this.mReleased).append(" delta:" + (this.mAcquired - this.mReleased));
        return stringBuffer.toString();
    }

    public void releaseBuffer(int index) {
        ++this.mReleased;
        this.mMemoryFileBuffers[index].setDirty(false);
    }

    public void close() {
        Logger.i((String)TAG, (String)"closing...");
        for (MemoryFileBuffer memoryFileBuffer : this.mMemoryFileBuffers) {
            memoryFileBuffer.getImageMemoryFile().close();
            memoryFileBuffer.getInfoMemoryFile().close();
            memoryFileBuffer.setDirty(false);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }
}

