package com.segway.robot.sdk.vision.calibration;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.vision.basic.Point2DF;

/**
 * Camera Intrinsic
 */

public class Intrinsic implements Parcelable{

    /**
     * Focal length
     */
    public Point2DF focalLength = new Point2DF();

    /**
     * Principal
     */
    public Point2DF principal = new Point2DF();

    /**
     * Distortion
     */
    public Distortion distortion = new Distortion();

    public Intrinsic() {
    }

    protected Intrinsic(Parcel in) {
        focalLength = in.readParcelable(Point2DF.class.getClassLoader());
        principal = in.readParcelable(Point2DF.class.getClassLoader());
        distortion = in.readParcelable(Distortion.class.getClassLoader());
    }

    public static final Creator<Intrinsic> CREATOR = new Creator<Intrinsic>() {
        @Override
        public Intrinsic createFromParcel(Parcel in) {
            return new Intrinsic(in);
        }

        @Override
        public Intrinsic[] newArray(int size) {
            return new Intrinsic[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(focalLength, flags);
        dest.writeParcelable(principal, flags);
        dest.writeParcelable(distortion, flags);
    }

    @Override
    public String toString() {
        return "Intrinsic{" +
                "\nfocalLength=" + focalLength +
                "\nprincipal=" + principal +
                "\ndistortion=" + distortion +
                "\n}";
    }
}
