package com.segway.robot.sdk.vision.calibration;

/**
 * Created by gaominghui on 2019/7/23.
 ***/
public class FisheyeCalibration {


    /**
     * 相机模型
     */
    private String camera_model = "";
    /**
     * 畸变系数
     */
    private float distortion_coeffs = 0;
    /**
     * fov畸变模型
     */
    private String distortion_model = "";
    /**
     * 相机内参
     */
    private IntrinsicsBean intrinsics = new IntrinsicsBean();
    /**
     * 图像分辨率
     */
    private ResolutionBean resolution = new ResolutionBean();
    /**
     * rosbag topic
     */
    private String rostopic;

    public String getCamera_model() {
        return camera_model;
    }

    public void setCamera_model(String camera_model) {
        this.camera_model = camera_model;
    }
    public float getDistortion_coeffs() {
        return distortion_coeffs;
    }

    public void setDistortion_coeffs(float distortion_coeffs) {
        this.distortion_coeffs = distortion_coeffs;
    }

    public String getDistortion_model() {
        return distortion_model;
    }

    public void setDistortion_model(String distortion_model) {
        this.distortion_model = distortion_model;
    }

    public IntrinsicsBean getIntrinsics() {
        return intrinsics;
    }

    public void setIntrinsics(IntrinsicsBean intrinsics) {
        this.intrinsics = intrinsics;
    }

    public ResolutionBean getResolution() {
        return resolution;
    }

    public void setResolution(ResolutionBean resolution) {
        this.resolution = resolution;
    }

    public String getRostopic() {
        return rostopic;
    }

    public void setRostopic(String rostopic) {
        this.rostopic = rostopic;
    }

    /**
     * 相机内参
     */
    public static class IntrinsicsBean {


        /**
         * x方向主点坐标
         */
        private float cx = 0;
        /**
         * y方向主点坐标
         */
        private float cy = 0;
        /**
         * x方向归一化焦距
         */
        private float fx = 0;
        /**
         * y方向归一化焦距
         */
        private float fy = 0;

        public float getCx() {
            return cx;
        }

        public void setCx(float cx) {
            this.cx = cx;
        }

        public float getCy() {
            return cy;
        }

        public void setCy(float cy) {
            this.cy = cy;
        }

        public float getFx() {
            return fx;
        }

        public void setFx(float fx) {
            this.fx = fx;
        }

        public float getFy() {
            return fy;
        }

        public void setFy(float fy) {
            this.fy = fy;
        }

        @Override
        public String toString() {
            return "IntrinsicsBean{" +
                    "cx=" + cx +
                    ", cy=" + cy +
                    ", fx=" + fx +
                    ", fy=" + fy +
                    '}';
        }
    }

    public static class ResolutionBean {
        /**
         * height : 1080
         * width : 1920
         */

        private int height = 0;
        private int width = 0;

        public int getHeight() {
            return height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public int getWidth() {
            return width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public String toString() {
            return "ResolutionBean{" +
                    "height=" + height +
                    ", width=" + width +
                    '}';
        }
    }

    @Override
    public String toString() {
        return "FisheyeCalibration{" +
                "camera_model='" + camera_model + '\'' +
                ", distortion_coeffs=" + distortion_coeffs +
                ", distortion_model='" + distortion_model + '\'' +
                ", intrinsics=" + intrinsics.toString() +
                ", resolution=" + resolution.toString() +
                ", rostopic='" + rostopic + '\'' +
                '}';
    }
}
