/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.segway.robot.sdk.base.log.Logger;
import java.util.Map;

public class SharedPrefUtils {
    private static final String TAG = "SharedPrefUtils";
    private static SharedPreferences sharedPreferences;
    private static final String FILE_NAME = "intrisic_ext";
    private static final String BASE_KEY = "rk_sensor_intrinsics";
    private static SharedPreferences.Editor editor;

    private SharedPrefUtils() {
    }

    public static void initWithContext(Context context) {
        sharedPreferences = context.getSharedPreferences(FILE_NAME, 0);
    }

    public static synchronized void putIntrinsicsByType(int streamType, String intrinsics) {
        Logger.v((String)TAG, (String)("putIntrinsicsByType: streamType " + streamType + " intrinsics " + intrinsics));
        editor = sharedPreferences.edit();
        editor.putString(BASE_KEY + streamType, intrinsics);
        editor.apply();
    }

    public static synchronized String getIntrinsicsByType(int streamType) {
        String intrinsics = sharedPreferences.getString(BASE_KEY + streamType, "");
        Logger.v((String)TAG, (String)("getIntrinsicsByType: " + streamType + " " + intrinsics));
        return intrinsics;
    }

    public static void put(String key, Object object) {
        editor = sharedPreferences.edit();
        if (object instanceof String) {
            editor.putString(key, (String)object);
        } else if (object instanceof Integer) {
            editor.putInt(key, ((Integer)object).intValue());
        } else if (object instanceof Boolean) {
            editor.putBoolean(key, ((Boolean)object).booleanValue());
        } else if (object instanceof Float) {
            editor.putFloat(key, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            editor.putLong(key, ((Long)object).longValue());
        } else {
            editor.putString(key, object.toString());
        }
        editor.apply();
    }

    public static Object get(String key, Object defaultObject) {
        if (defaultObject instanceof String) {
            return sharedPreferences.getString(key, (String)defaultObject);
        }
        if (defaultObject instanceof Integer) {
            return sharedPreferences.getInt(key, ((Integer)defaultObject).intValue());
        }
        if (defaultObject instanceof Boolean) {
            return sharedPreferences.getBoolean(key, ((Boolean)defaultObject).booleanValue());
        }
        if (defaultObject instanceof Float) {
            return Float.valueOf(sharedPreferences.getFloat(key, ((Float)defaultObject).floatValue()));
        }
        if (defaultObject instanceof Long) {
            return sharedPreferences.getLong(key, ((Long)defaultObject).longValue());
        }
        return sharedPreferences.getString(key, null);
    }

    public static void remove(String key) {
        editor.remove(key);
        editor.apply();
    }

    public static void clear() {
        editor.clear();
        editor.apply();
    }

    public static boolean contains(int key) {
        return sharedPreferences.contains(BASE_KEY + key);
    }

    public static Map<String, ?> getAll() {
        return sharedPreferences.getAll();
    }
}

