/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.imu;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IIMUDataCallback
extends IInterface {
    public void onNewData(byte[] var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IIMUDataCallback {
        private static final String DESCRIPTOR = "com.segway.robot.sdk.vision.imu.IIMUDataCallback";
        static final int TRANSACTION_onNewData = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IIMUDataCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IIMUDataCallback) {
                return (IIMUDataCallback)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            switch (code) {
                case 1598968902: {
                    reply.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    data.enforceInterface(DESCRIPTOR);
                    byte[] _arg0 = data.createByteArray();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.onNewData(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        private static class Proxy
        implements IIMUDataCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onNewData(byte[] buff, int length, int frameCount) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(buff);
                    _data.writeInt(length);
                    _data.writeInt(frameCount);
                    this.mRemote.transact(1, _data, _reply, 0);
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }
        }
    }
}

