package com.segway.robot.sdk.vision.calibration;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.vision.basic.Point3DF;

/**
 * Created by ark338 on 2016/10/24.
 */

public class SensorIntrinsics implements Parcelable{
    public float x_y;
    public float x_z;
    public float y_x;
    public float y_z;
    public float z_x;
    public float z_y;
    public Point3DF scale = new Point3DF();
    public Point3DF bias = new Point3DF();
    public Point3DF biasVar = new Point3DF();
    public Point3DF varNoise = new Point3DF();

    public SensorIntrinsics() {
    }

    protected SensorIntrinsics(Parcel in) {
        x_y = in.readFloat();
        x_z = in.readFloat();
        y_x = in.readFloat();
        y_z = in.readFloat();
        z_x = in.readFloat();
        z_y = in.readFloat();
        scale = in.readParcelable(Point3DF.class.getClassLoader());
        bias = in.readParcelable(Point3DF.class.getClassLoader());
        biasVar = in.readParcelable(Point3DF.class.getClassLoader());
        varNoise = in.readParcelable(Point3DF.class.getClassLoader());
    }

    public static final Creator<SensorIntrinsics> CREATOR = new Creator<SensorIntrinsics>() {
        @Override
        public SensorIntrinsics createFromParcel(Parcel in) {
            return new SensorIntrinsics(in);
        }

        @Override
        public SensorIntrinsics[] newArray(int size) {
            return new SensorIntrinsics[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeFloat(x_y);
        dest.writeFloat(x_z);
        dest.writeFloat(y_x);
        dest.writeFloat(y_z);
        dest.writeFloat(z_x);
        dest.writeFloat(z_y);
        dest.writeParcelable(scale, flags);
        dest.writeParcelable(bias, flags);
        dest.writeParcelable(biasVar, flags);
        dest.writeParcelable(varNoise, flags);
    }

    @Override
    public String toString() {
        return "SensorIntrinsics{" +
                "\nx_y=" + x_y +
                "\nx_z=" + x_z +
                "\ny_x=" + y_x +
                "\ny_z=" + y_z +
                "\nz_x=" + z_x +
                "\nz_y=" + z_y +
                "\nscale=" + scale +
                "\nbias=" + bias +
                "\nbiasVar=" + biasVar +
                "\nvarNoise=" + varNoise +
                "\n}";
    }
}
