/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.utils;

import android.os.SystemClock;
import com.segway.robot.sdk.base.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class DevicesUtils {
    private static final String TAG = DevicesUtils.class.getSimpleName();
    public static final String LEFT_BOTTOM = "usb1/1-2/1-2.3";
    public static final String RIGHT_BOTTOM = "usb1/1-2/1-2.4";
    public static final String LEFT_TOP = "usb2/2-4/2-4";
    public static final String LEFT_BOTTOM_RK = "-1.2";
    public static final String LEFT_TOP_RK = "-1.4";
    public static final String LEFT_TOP_RK2 = "-1.3";
    public static final String RIGHT_BOTTOM_RK = "-1.1";
    public static final String KERNEL_PORT_INFO_LEFT_BOTTOM = "1-2.3";
    public static final String KERNEL_PORT_INFO_RIGHT_BOTTOM = "1-2.4";
    public static final String KERNEL_PORT_INFO_TOP = "2-4";
    public static final int DS5_LEFT = 1;
    public static final int DS5_RIGHT = 2;
    public static final int DEPTH_TOP = 3;
    public static final int ALL_DEVICES = 0;
    private static final int CHECK_INTERVAL = 500;
    private static final int GAP_THRESHOLD = 1000;

    public static boolean isDepthDevicesDisconnected(int depthType) {
        boolean isLeftOn = false;
        boolean isRightOn = false;
        boolean isTopOn = false;
        String devPath = "/proc/bus/input/devices";
        List<String> lines = DevicesUtils.readFileByLine(devPath);
        switch (depthType) {
            case 1: {
                for (String line : lines) {
                    if (!line.contains(LEFT_BOTTOM) && !line.contains(LEFT_BOTTOM_RK)) continue;
                    Logger.d((String)TAG, (String)(" ds5_left return false." + line));
                    return false;
                }
                break;
            }
            case 2: {
                for (String line : lines) {
                    if (!line.contains(RIGHT_BOTTOM) && !line.contains(RIGHT_BOTTOM_RK)) continue;
                    Logger.d((String)TAG, (String)" ds5_right return false.");
                    return false;
                }
                break;
            }
            case 3: {
                for (String line : lines) {
                    if (!line.contains(LEFT_TOP) && !line.contains(LEFT_TOP_RK) && !line.contains(LEFT_TOP_RK2)) continue;
                    Logger.d((String)TAG, (String)" ds5_top return false.");
                    return false;
                }
                break;
            }
            case 0: {
                for (String line : lines) {
                    if (line.contains(LEFT_BOTTOM) || line.contains(LEFT_BOTTOM_RK)) {
                        isLeftOn = true;
                        continue;
                    }
                    if (line.contains(RIGHT_BOTTOM) || line.contains(RIGHT_BOTTOM_RK)) {
                        isRightOn = true;
                        continue;
                    }
                    if (!line.contains(LEFT_TOP) && !line.contains(LEFT_TOP_RK) && !line.contains(LEFT_TOP_RK2)) continue;
                    isTopOn = true;
                }
                Logger.d((String)TAG, (String)(" check all devices return " + (!isLeftOn || !isRightOn || !isTopOn)));
                return !isLeftOn || !isRightOn || !isTopOn;
            }
            default: {
                Logger.e((String)TAG, (String)(" unknown depth type of " + depthType));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> readFileByLine(String devPath) {
        ArrayList<String> resStrings = new ArrayList<String>();
        File file = new File(devPath);
        if (file.exists()) {
            FileInputStream fis = null;
            BufferedReader bufferedReader = null;
            InputStreamReader isr = null;
            try {
                String line;
                fis = new FileInputStream(file);
                isr = new InputStreamReader(fis);
                bufferedReader = new BufferedReader(isr);
                while ((line = bufferedReader.readLine()) != null) {
                    resStrings.add(line);
                }
            }
            catch (Exception e) {
                Logger.i((String)TAG, (String)"doNothing2.");
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e1) {
                    Logger.w((String)TAG, (String)"doNothing1.");
                }
            }
        }
        return resStrings;
    }

    public static boolean isDisconnectionEverLoggedInKernel(int depthType) {
        long elapsedRealtime = SystemClock.elapsedRealtime();
        List<String> errorInfoList = DevicesUtils.getErrorInfoList();
        for (String info : errorInfoList) {
            switch (depthType) {
                case 1: {
                    if (info == null || !info.contains(KERNEL_PORT_INFO_LEFT_BOTTOM) || !DevicesUtils.checkTime(info, elapsedRealtime)) break;
                    return true;
                }
                case 2: {
                    if (info == null || !info.contains(KERNEL_PORT_INFO_RIGHT_BOTTOM) || !DevicesUtils.checkTime(info, elapsedRealtime)) break;
                    return true;
                }
                case 3: {
                    if (info == null || !info.contains(KERNEL_PORT_INFO_TOP) || !DevicesUtils.checkTime(info, elapsedRealtime)) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean checkTime(String info, long elapsedRealtime) {
        String kernelTime = info.substring(info.indexOf("[") + 1, info.indexOf("]"));
        double disconnectTime = 0.0;
        try {
            double time = Double.valueOf(kernelTime.trim());
            disconnectTime = time * 1000.0;
        }
        catch (Exception e) {
            Logger.w((String)TAG, (String)("exception in transfer log time. " + e.getLocalizedMessage()));
        }
        Logger.d((String)TAG, (String)(" elapsedRealtime=" + elapsedRealtime + ", disconnectTime=" + disconnectTime + " time gap: " + Math.abs((double)elapsedRealtime - disconnectTime - 500.0)));
        return Math.abs((double)elapsedRealtime - disconnectTime - 500.0) < 1000.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getErrorInfo() {
        BufferedReader reader = null;
        try {
            int read;
            String[] cmd = new String[]{"sh", "-c", "adb shell dmesg | grep 'USB disconnect'"};
            Process process = Runtime.getRuntime().exec(cmd);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            StringBuffer output = new StringBuffer();
            char[] buffer = new char[1024];
            while ((read = reader.read(buffer)) > 0) {
                output.append(buffer, 0, read);
            }
            String string = output.toString();
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            String string = e.getMessage();
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getErrorInfoList() {
        BufferedReader reader = null;
        ArrayList<String> outputs = new ArrayList<String>();
        try {
            String line;
            String[] cmd = new String[]{"sh", "-c", "adb shell dmesg | grep 'USB disconnect'"};
            Process process = Runtime.getRuntime().exec(cmd);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                outputs.add(line);
            }
        }
        catch (IOException e) {
            Logger.e((String)TAG, (String)(" exception :" + e.getLocalizedMessage()), (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return outputs;
    }
}

