package com.segway.robot.sdk.vision.imu;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

/**
 * Created by ark338 on 16/8/22.
 */
public class IMUFrame {
    private ByteBuffer mBuffer;

    public IMUFrame(ByteBuffer buffer) {
        mBuffer = buffer;
        mBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public IMUFrame(byte[] array) {
        mBuffer = ByteBuffer.wrap(array);
        mBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public long getTimeStamp() {
        return mBuffer.getLong(0);
    }

    public long getSequence() {
        return mBuffer.getLong(8);
    }

    public int getType() {
        return mBuffer.getInt(16);
    }

    public float getX() {
        return mBuffer.getFloat(24);
    }

    public float getY() {
        return mBuffer.getFloat(28);
    }

    public float getZ() {
        return mBuffer.getFloat(32);
    }

    public long getPlatformTimestamp() {
        return mBuffer.getLong(40);
    }

    @Override
    public String toString() {
        return "tp:" + getType()
                + " ts:" + getTimeStamp()
                + " fn:" + getSequence()
                + " x:" + getX()
                + " y:" + getY()
                + " z:" + getZ()
                + " pts:" + getPlatformTimestamp();
    }
}
