package com.segway.robot.sdk.vision.internal.framebuffer;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.frame.Frame;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/**
 * Buffer for frames
 * Max buffer length is defined as MAX_SIZE
 */
public class FrameBuffer {
    private static final String TAG = "FrameBuffer";
    final int MAX_SIZE = 10;
    List<CountableFrame> mFrameList = new LinkedList<>();
    private String mType;
    private int mCounter;

    public FrameBuffer() {
    }

    public FrameBuffer(String type) {
        mType = type;
    }

    /**
     *
     * @param frame
     */
    public synchronized boolean add(CountableFrame frame) {
        // release and remove all unlocked image
        Iterator iterator = mFrameList.iterator();
        while (iterator.hasNext()) {
            CountableFrame f = (CountableFrame) iterator.next();
            if (!f.isLocked()) {
                f.release();
                iterator.remove();
            }
        }

        // check buffer size
        mCounter++;
        if (mCounter == 100) {
            mCounter = 0;
            Logger.v(TAG, mType + " Buffer used = " + mFrameList.size());
        }

        if (mFrameList.size() > MAX_SIZE / 2) {
            Logger.w(TAG, mType + " Buffer near overflow, used = " + mFrameList.size());
        }

        if (mFrameList.size() >= MAX_SIZE) {
            Logger.v(TAG, mType + " Buffer overflow !");
            frame.release();
            return false;
        }

        mFrameList.add(frame);
        return true;
    }

    public synchronized Frame getLatest(long previousFrameTid) {
        if (mFrameList.size() == 0) {
            return null;
        }

        CountableFrame frame = mFrameList.get(mFrameList.size() - 1);
        if (frame.getTid() > previousFrameTid) {
            frame.lockCountUp();
            return frame;
        }

        return null;
    }

    public synchronized void returnFrame(Frame frame) {
        CountableFrame cur = (CountableFrame)frame;
        cur.lockCountDown();
        // try to drop frame to release frame when buffer is full
        // this helps to fix bug frame only can release in add buffer
        if (mFrameList.size() == MAX_SIZE
                && !cur.isLocked()
                && cur != mFrameList.get(mFrameList.size() - 1)) {
            cur.release();
            mFrameList.remove(cur);
        }
    }

    public synchronized void release() {
        for (CountableFrame countableFrame : mFrameList) {
            countableFrame.release();
        }
        mFrameList.clear();
    }
}
