/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.utils;

import android.graphics.Bitmap;
import android.os.Environment;
import com.google.gson.Gson;
import com.segway.robot.sdk.base.log.Logger;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class LogUtil {
    public static final int TS_MICRO = 1;
    public static final int TS_NANO = 2;
    public static final int TS_MILLI = 3;
    private static final String TAG = LogUtil.class.getName();
    private static Gson gson = new Gson();
    private static SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:mm:ss:SSS");
    static String path = Environment.getExternalStorageDirectory().getPath() + "/ecevent.log";

    public static void logFrameDetail(String tag, String streamName, long ts, long lastTs, int flag) {
        if (Logger.isLogcatEnabled((int)1) && lastTs != 0L) {
            switch (flag) {
                case 2: {
                    ts /= 1000000L;
                    lastTs /= 1000000L;
                    break;
                }
                case 1: {
                    ts /= 1000L;
                    lastTs /= 1000L;
                    break;
                }
            }
            Logger.v((String)tag, (String)(streamName + " -> nowts:" + ts + " last_ts:" + lastTs + " gap:" + (ts - lastTs) + " RTdiff:" + (System.currentTimeMillis() - ts)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveLog2LogFile(String log, String path) {
        OutputStreamWriter fileWriter = null;
        BufferedWriter bw = null;
        try {
            File file = new File(path);
            fileWriter = new FileWriter(file, true);
            bw = new BufferedWriter(fileWriter);
            bw.append(log);
            bw.newLine();
            if (file.length() > 0xA00000L) {
                File bakFile = new File(path.replace("ecevent.log", "ecevent_" + System.currentTimeMillis() + ".log"));
                file.renameTo(bakFile);
                file.delete();
                file.createNewFile();
                Logger.i((String)TAG, (String)"File size exceeds limit of 100M. delete file and recreate it.");
            }
        }
        catch (Exception e) {
            Logger.e((String)TAG, (String)"write log to file error", (Throwable)e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.flush();
                    bw.close();
                }
                catch (IOException e) {
                    Logger.w((String)TAG, (String)"close bw exception in finally , do nothing.");
                }
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException e) {
                    Logger.w((String)TAG, (String)"clse fileWriter exception in finally , do nothing.");
                }
            }
        }
    }

    public static synchronized void saveObjJson2LogFile(Object obj) {
        if (obj != null) {
            String log = sdf.format(new Date()) + " " + gson.toJson(obj);
            LogUtil.saveLog2LogFile(log, path);
        } else {
            Logger.w((String)TAG, (String)"saveObjJson2LogFile pass null.");
        }
    }

    public static Gson getGson() {
        return gson;
    }

    public static SimpleDateFormat getSdf() {
        return sdf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadConfig(String filePath) {
        String resJson = null;
        InputStreamReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            File file = new File(filePath);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            resJson = bufferedReader.readLine();
        }
        catch (Exception e) {
            System.out.println("exception -> " + e.getLocalizedMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (IOException e) {
                System.out.println("doNothing.");
            }
        }
        return resJson;
    }

    public static String trimEvtType(String evtType) {
        if (evtType == null) {
            return "";
        }
        return evtType.replaceAll("-", "").replaceAll("\\.", "");
    }

    public static synchronized void saveCSV2LogFile(String csvString, String csvFilePath) {
        LogUtil.saveLog2LogFile(csvString, csvFilePath);
    }

    public static void saveBitmap(ByteBuffer buffer) {
        Bitmap bitmap = LogUtil.createBitmap(buffer);
        String bufferDir = "bytebuffer";
        LogUtil.saveBitmap(bitmap, bufferDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBitmap(Bitmap bitmap, String dirName) {
        long ts = System.currentTimeMillis();
        Logger.i((String)TAG, (String)("saveBitmap ts = " + ts));
        String filePath = Environment.getExternalStorageDirectory().getPath() + "/DCIM/" + dirName + "/" + ts + ".jpg";
        File file = new File(filePath);
        FileOutputStream out = null;
        FilterOutputStream bos = null;
        try {
            out = new FileOutputStream(file);
            bos = new BufferedOutputStream(out);
            boolean res = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bos);
            if (res) {
                ((BufferedOutputStream)bos).flush();
            } else {
                Logger.e((String)TAG, (String)"compress ... some wrong...");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                out.close();
                bos.close();
            }
            catch (Exception e) {
                Logger.e((String)TAG, (String)"do nothing.");
            }
        }
    }

    public static Bitmap createBitmap(ByteBuffer buffer) {
        buffer.rewind();
        Bitmap bitmap = Bitmap.createBitmap((int)640, (int)480, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)buffer);
        buffer.rewind();
        return bitmap;
    }

    public static void printWarning() {
        Logger.w((String)TAG, (String)(" >>> not supported! <<<\n" + Arrays.toString(new Throwable().getStackTrace())));
    }
}

