/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.stream;

import android.os.Parcel;
import android.os.Parcelable;
import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.stream.FrameRate;
import com.segway.robot.sdk.vision.stream.PixelFormat;
import com.segway.robot.sdk.vision.stream.Resolution;
import com.segway.robot.sdk.vision.stream.StreamType;
import java.lang.reflect.Field;

public class StreamInfo
implements Parcelable {
    private static final String TAG = "StreamInfo";
    int streamType;
    int resolution;
    int width;
    int height;
    int fps;
    int pixelFormat;
    float pixelBytes;
    public static final Parcelable.Creator<StreamInfo> CREATOR = new Parcelable.Creator<StreamInfo>(){

        public StreamInfo createFromParcel(Parcel source) {
            int streamType = source.readInt();
            int resolution = source.readInt();
            int width = source.readInt();
            int height = source.readInt();
            int fps = source.readInt();
            int pixelFormat = source.readInt();
            return new StreamInfo(streamType, width, height, fps, pixelFormat);
        }

        public StreamInfo[] newArray(int size) {
            return new StreamInfo[size];
        }
    };

    public StreamInfo(int streamType, int width, int height, int fps, int pixelFormat) {
        this.streamType = streamType;
        this.width = width;
        this.height = height;
        this.fps = fps;
        this.pixelFormat = pixelFormat;
        this.pixelBytes = PixelFormat.getPixelBytes(pixelFormat);
        this.resolution = Resolution.toVisionServiceResolution(width, height);
    }

    public static StreamInfo create(int streamType, @Resolution.VisionResolution int resolution, @FrameRate.VisionFrameRate int fps, @PixelFormat.VisionPixelFormat int pixelFormat) {
        return new StreamInfo(streamType, Resolution.getWidth(resolution), Resolution.getHeight(resolution), fps, pixelFormat);
    }

    public int getStreamType() {
        return this.streamType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFps() {
        return this.fps;
    }

    @PixelFormat.VisionPixelFormat
    public int getPixelFormat() {
        return this.pixelFormat;
    }

    public float getPixelBytes() {
        return this.pixelBytes;
    }

    public int hashCode() {
        return (this.width << 24) + (this.height << 16) + (this.fps << 12) + (this.pixelFormat << 8) + this.streamType;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.streamType);
        dest.writeInt(this.resolution);
        dest.writeInt(this.width);
        dest.writeInt(this.height);
        dest.writeInt(this.fps);
        dest.writeInt(this.pixelFormat);
    }

    public static String getStreamNameByType(int streamType) {
        Field[] fields = StreamType.class.getFields();
        try {
            for (Field field : fields) {
                if (field.getInt(StreamType.class) != streamType) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException e) {
            Logger.e((String)TAG, (String)"getStreamNameByType exception", (Throwable)e);
        }
        return "unknown";
    }
}

