
package com.segway.robot.sdk.vision.utils;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.calibration.FisheyeCalibration;
import com.segway.robot.sdk.vision.calibration.RS2Intrinsic;

/**
 * Created by gaofeng on 2019/7/3.
 */
public class CheckUtils {
    private static final String TAG = "CheckUtils";

    public static boolean checkData(RS2Intrinsic rs2Intrinsic) {
        Logger.i(TAG, "checkData() rs2Intrinsic = [" + rs2Intrinsic + "]");
        if (rs2Intrinsic == null) {
            Logger.w(TAG, "checkData: RS2Intrinsic is null!");
            return false;
        }

        int delta = 100;
        int width = rs2Intrinsic.getWidth();
        int height = rs2Intrinsic.getHeight();
        float ppx = rs2Intrinsic.getPrincipalPointX();
        float ppy = rs2Intrinsic.getPrincipalPointY();
        float flx = rs2Intrinsic.getFocalLengthX();
        float fly = rs2Intrinsic.getFocalLengthY();
        if (width == 0 || width == -1) {
            return false;
        }

        if (height == 0 || height == -1) {
            return false;
        }

        if (ppx >= width || ppx < (width / 2 - delta)) {
            return false;
        }

        if (ppy >= height || ppy < (height / 2 - delta)) {
            return false;
        }

        if (flx < 10 || fly < 10) {
            return false;
        }

        return true;
    }

    public static boolean checkFisheyeIntrinsic(RS2Intrinsic rs2Intrinsic) {
        Logger.i(TAG, "checkData() rs2Intrinsic = [" + rs2Intrinsic + "]");
        if (rs2Intrinsic == null) {
            Logger.w(TAG, "checkData: RS2Intrinsic is null!");
            return false;
        }

        int delta = 100;
        int width = rs2Intrinsic.getWidth();
        int height = rs2Intrinsic.getHeight();
        float ppx = rs2Intrinsic.getPrincipalPointX();
        float ppy = rs2Intrinsic.getPrincipalPointY();
        float flx = rs2Intrinsic.getFocalLengthX();
        float fly = rs2Intrinsic.getFocalLengthY();
        if (width == 0 || width == -1) {
            return false;
        }

        if (height == 0 || height == -1) {
            return false;
        }

        if (ppx >= width || ppx < (width / 2 - delta)) {
            return false;
        }

        if (ppy >= height || ppy < (height / 2 - delta)) {
            return false;
        }

        if (flx < 10 || fly < 10) {
            return false;
        }

        if (rs2Intrinsic.getCoeffs()[0] < 0.5 || rs2Intrinsic.getCoeffs()[0] > 1){
            return false;
        }

        return true;
    }

    public static RS2Intrinsic transformBean(FisheyeCalibration fisheyeCalibration){
        if (fisheyeCalibration == null){
            return null;
        }
        float[] coeffs = {fisheyeCalibration.getDistortion_coeffs(),0,0,0,0};
        RS2Intrinsic rs2Intrinsic = new RS2Intrinsic(
                fisheyeCalibration.getResolution().getWidth(),
                fisheyeCalibration.getResolution().getHeight(),
                fisheyeCalibration.getIntrinsics().getCx(),
                fisheyeCalibration.getIntrinsics().getCy(),
                fisheyeCalibration.getIntrinsics().getFx(),
                fisheyeCalibration.getIntrinsics().getFy(),
                0,
                coeffs);
        return rs2Intrinsic;

    }

}
