/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.utils;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.calibration.FisheyeCalibration;
import com.segway.robot.sdk.vision.calibration.RS2Intrinsic;

public class CheckUtils {
    private static final String TAG = "CheckUtils";

    public static boolean checkData(RS2Intrinsic rs2Intrinsic) {
        Logger.i((String)TAG, (String)("checkData() rs2Intrinsic = [" + rs2Intrinsic + "]"));
        if (rs2Intrinsic == null) {
            Logger.w((String)TAG, (String)"checkData: RS2Intrinsic is null!");
            return false;
        }
        int delta = 100;
        int width = rs2Intrinsic.getWidth();
        int height = rs2Intrinsic.getHeight();
        float ppx = rs2Intrinsic.getPrincipalPointX();
        float ppy = rs2Intrinsic.getPrincipalPointY();
        float flx = rs2Intrinsic.getFocalLengthX();
        float fly = rs2Intrinsic.getFocalLengthY();
        if (width == 0 || width == -1) {
            return false;
        }
        if (height == 0 || height == -1) {
            return false;
        }
        if (ppx >= (float)width || ppx < (float)(width / 2 - delta)) {
            return false;
        }
        if (ppy >= (float)height || ppy < (float)(height / 2 - delta)) {
            return false;
        }
        return !(flx < 10.0f) && !(fly < 10.0f);
    }

    public static boolean checkFisheyeIntrinsic(RS2Intrinsic rs2Intrinsic) {
        Logger.i((String)TAG, (String)("checkData() rs2Intrinsic = [" + rs2Intrinsic + "]"));
        if (rs2Intrinsic == null) {
            Logger.w((String)TAG, (String)"checkData: RS2Intrinsic is null!");
            return false;
        }
        int delta = 100;
        int width = rs2Intrinsic.getWidth();
        int height = rs2Intrinsic.getHeight();
        float ppx = rs2Intrinsic.getPrincipalPointX();
        float ppy = rs2Intrinsic.getPrincipalPointY();
        float flx = rs2Intrinsic.getFocalLengthX();
        float fly = rs2Intrinsic.getFocalLengthY();
        if (width == 0 || width == -1) {
            return false;
        }
        if (height == 0 || height == -1) {
            return false;
        }
        if (ppx >= (float)width || ppx < (float)(width / 2 - delta)) {
            return false;
        }
        if (ppy >= (float)height || ppy < (float)(height / 2 - delta)) {
            return false;
        }
        if (flx < 10.0f || fly < 10.0f) {
            return false;
        }
        return !((double)rs2Intrinsic.getCoeffs()[0] < 0.5) && !(rs2Intrinsic.getCoeffs()[0] > 1.0f);
    }

    public static RS2Intrinsic transformBean(FisheyeCalibration fisheyeCalibration) {
        if (fisheyeCalibration == null) {
            return null;
        }
        float[] coeffs = new float[]{fisheyeCalibration.getDistortion_coeffs(), 0.0f, 0.0f, 0.0f, 0.0f};
        RS2Intrinsic rs2Intrinsic = new RS2Intrinsic(fisheyeCalibration.getResolution().getWidth(), fisheyeCalibration.getResolution().getHeight(), fisheyeCalibration.getIntrinsics().getCx(), fisheyeCalibration.getIntrinsics().getCy(), fisheyeCalibration.getIntrinsics().getFx(), fisheyeCalibration.getIntrinsics().getFy(), 0, coeffs);
        return rs2Intrinsic;
    }
}

