/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.framebuffer;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.frame.Frame;
import com.segway.robot.sdk.vision.internal.framebuffer.CountableFrame;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FrameBuffer {
    private static final String TAG = "FrameBuffer";
    final int MAX_SIZE = 10;
    List<CountableFrame> mFrameList = new LinkedList<CountableFrame>();
    private String mType;
    private int mCounter;

    public FrameBuffer() {
    }

    public FrameBuffer(String type) {
        this.mType = type;
    }

    public synchronized boolean add(CountableFrame frame) {
        Iterator<CountableFrame> iterator = this.mFrameList.iterator();
        while (iterator.hasNext()) {
            CountableFrame f = iterator.next();
            if (f.isLocked()) continue;
            f.release();
            iterator.remove();
        }
        ++this.mCounter;
        if (this.mCounter == 100) {
            this.mCounter = 0;
            Logger.v((String)TAG, (String)(this.mType + " Buffer used = " + this.mFrameList.size()));
        }
        if (this.mFrameList.size() > 5) {
            Logger.w((String)TAG, (String)(this.mType + " Buffer near overflow, used = " + this.mFrameList.size()));
        }
        if (this.mFrameList.size() >= 10) {
            Logger.v((String)TAG, (String)(this.mType + " Buffer overflow !"));
            frame.release();
            return false;
        }
        this.mFrameList.add(frame);
        return true;
    }

    public synchronized Frame getLatest(long previousFrameTid) {
        if (this.mFrameList.size() == 0) {
            return null;
        }
        CountableFrame frame = this.mFrameList.get(this.mFrameList.size() - 1);
        if (frame.getTid() > previousFrameTid) {
            frame.lockCountUp();
            return frame;
        }
        return null;
    }

    public synchronized void returnFrame(Frame frame) {
        CountableFrame cur = (CountableFrame)frame;
        cur.lockCountDown();
        if (this.mFrameList.size() == 10 && !cur.isLocked() && cur != this.mFrameList.get(this.mFrameList.size() - 1)) {
            cur.release();
            this.mFrameList.remove(cur);
        }
    }

    public synchronized void release() {
        for (CountableFrame countableFrame : this.mFrameList) {
            countableFrame.release();
        }
        this.mFrameList.clear();
    }
}

