/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.stream;

public abstract class Resolution {
    static final int COLOR_MASK = 0x40000000;
    static final int DEPTH_MASK = 0x20000000;
    static final int FISH_EYE_MASK = 0x10000000;

    public static int getWidth(@VisionResolution int resolution) {
        switch (resolution) {
            case 551551148: {
                return 224;
            }
            case 1094713584: {
                return 320;
            }
            case 1105199424: {
                return 480;
            }
            case 1115685344: {
                return 640;
            }
            case 1157628624: {
                return 1280;
            }
            case 1199572024: {
                return 1920;
            }
            case 557842672: {
                return 320;
            }
            case 568328552: {
                return 480;
            }
            case 578027988: {
                return 628;
            }
            case 564658416: {
                return 424;
            }
            case 568328462: {
                return 480;
            }
            case 620757712: {
                return 1280;
            }
            case 310378976: {
                return 640;
            }
            case 394265656: {
                return 1920;
            }
        }
        return 0;
    }

    public static int getHeight(@VisionResolution int resolution) {
        switch (resolution) {
            case 551551148: {
                return 172;
            }
            case 1094713584: {
                return 240;
            }
            case 1105199424: {
                return 320;
            }
            case 1115685344: {
                return 480;
            }
            case 1157628624: {
                return 720;
            }
            case 1199572024: {
                return 1080;
            }
            case 557842672: {
                return 240;
            }
            case 568328552: {
                return 360;
            }
            case 578027988: {
                return 468;
            }
            case 564658416: {
                return 240;
            }
            case 568328462: {
                return 270;
            }
            case 620757712: {
                return 720;
            }
            case 310378976: {
                return 480;
            }
            case 394265656: {
                return 1080;
            }
        }
        return 0;
    }

    public static int toVisionServiceResolution(int width, int height) {
        int colorResolution = width << 16 | height | 0x40000000;
        int depthResolution = width << 16 | height | 0x20000000;
        int fishEyeResolution = width << 16 | height | 0x10000000;
        switch (colorResolution) {
            case 1094713584: {
                return 1094713584;
            }
            case 1105199424: {
                return 1105199424;
            }
            case 1115685344: {
                return 1115685344;
            }
            case 1157628624: {
                return 1157628624;
            }
            case 1199572024: {
                return 1199572024;
            }
        }
        switch (depthResolution) {
            case 557842672: {
                return 557842672;
            }
            case 568328552: {
                return 568328552;
            }
            case 578027988: {
                return 578027988;
            }
            case 564658416: {
                return 564658416;
            }
            case 568328462: {
                return 568328462;
            }
            case 620757712: {
                return 620757712;
            }
            case 551551148: {
                return 551551148;
            }
        }
        switch (fishEyeResolution) {
            case 310378976: {
                return 310378976;
            }
            case 394265656: {
                return 394265656;
            }
        }
        return 0;
    }

    public static @interface VisionResolution {
    }

    public static interface FishEye {
        public static final int R_640_480 = 310378976;
        public static final int R_1920_1080 = 394265656;
    }

    public static interface Depth {
        public static final int R_320_240 = 557842672;
        public static final int R_480_360 = 568328552;
        public static final int R_628_468 = 578027988;
        public static final int R_424_240 = 564658416;
        public static final int R_480_270 = 568328462;
        public static final int R_1280_720 = 620757712;
        public static final int R_224_172 = 551551148;
    }

    public static interface Color {
        public static final int R_320_240 = 1094713584;
        public static final int R_480_320 = 1105199424;
        public static final int R_640_480 = 1115685344;
        public static final int R_1280_720 = 1157628624;
        public static final int R_1920_1080 = 1199572024;
    }
}

