/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.utils;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.calibration.RS2Intrinsic;

public class CheckUtils {
    private static final String TAG = "CheckUtils";

    public static boolean checkData(RS2Intrinsic rs2Intrinsic) {
        Logger.i((String)TAG, (String)("checkData() rs2Intrinsic = [" + rs2Intrinsic + "]"));
        if (rs2Intrinsic == null) {
            Logger.w((String)TAG, (String)"checkData: RS2Intrinsic is null!");
            return false;
        }
        int delta = 100;
        int width = rs2Intrinsic.getWidth();
        int height = rs2Intrinsic.getHeight();
        float ppx = rs2Intrinsic.getPrincipalPointX();
        float ppy = rs2Intrinsic.getPrincipalPointY();
        float flx = rs2Intrinsic.getFocalLengthX();
        float fly = rs2Intrinsic.getFocalLengthY();
        if (width == 0 || width == -1) {
            return false;
        }
        if (height == 0 || height == -1) {
            return false;
        }
        if (ppx >= (float)width || ppx < (float)(width / 2 - delta)) {
            return false;
        }
        if (ppy >= (float)height || ppy < (float)(height / 2 - delta)) {
            return false;
        }
        return !(flx < 10.0f) && !(fly < 10.0f);
    }
}

