package com.segway.robot.sdk.vision.calibration;

import android.os.Parcel;
import android.os.Parcelable;

import com.segway.robot.sdk.vision.basic.Matrix3F;
import com.segway.robot.sdk.vision.basic.Point3DF;

/**
 * Camera extrinsic
 */

public class Extrinsic implements Parcelable{

    /**
     * Translation
     */
    public Point3DF translation = new Point3DF();

    /**
     * Rotation
     */
    public Matrix3F rotation = new Matrix3F();

    public Extrinsic() {
    }

    protected Extrinsic(Parcel in) {
        translation = in.readParcelable(Point3DF.class.getClassLoader());
        rotation = in.readParcelable(Matrix3F.class.getClassLoader());
    }

    public static final Creator<Extrinsic> CREATOR = new Creator<Extrinsic>() {
        @Override
        public Extrinsic createFromParcel(Parcel in) {
            return new Extrinsic(in);
        }

        @Override
        public Extrinsic[] newArray(int size) {
            return new Extrinsic[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(translation, flags);
        dest.writeParcelable(rotation, flags);
    }

    @Override
    public String toString() {
        return "Extrinsic{" +
                "\ntranslation:\n" + translation +
                "\nrotation:\n" + rotation +
                "\n}";
    }
}
