package com.segway.robot.sdk.vision.stream;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * the supported stream types.
 * Note: the definition must not be above 16383, because AprSenseService keeps only 14 bits for this.
 */
public interface StreamType {
    /**
     * a color image stream.
     */
    int COLOR = 1;

    /**
     * a depth image stream.
     */
    int DEPTH = 2;//

    int IR = 4;

    /**
     * a left image stream.
     */
    int LEFT = 8;

    /**
     * a right image stream.
     */
    int RIGHT = 16;

    /**
     * Left depth camera on GX
     */
    int EXT_DEPTH_L = 32;//

    /**
     * Right depth camera on GX
     */
    int EXT_DEPTH_R = 64;//

    /**
     * a fish eye image stream.
     */
    int FISH_EYE = 256;//

    /**
     * a slam map image, not supported now.
     */
    int SLAM_MAP = 512;

    int EXT_IR_L = 1024;//

    int EXT_IR_R = 2048;//

    @IntDef(flag = true, value = {
            COLOR, DEPTH, FISH_EYE, SLAM_MAP})
    @Retention(RetentionPolicy.SOURCE)
    @interface VisionStreamTypes {}

    @IntDef(flag = false, value = {
            COLOR, DEPTH, FISH_EYE})
    @Retention(RetentionPolicy.SOURCE)
    @interface VisionStreamType {}

    @IntDef(flag = false, value = {
            COLOR, DEPTH, FISH_EYE, EXT_DEPTH_L, EXT_DEPTH_R, EXT_IR_L, EXT_IR_R})
    @Retention(RetentionPolicy.SOURCE)
    @interface VisionStreamTypeAdvanced {}
}
