package com.segway.robot.sdk.vision.utils;

import android.os.Environment;

import com.google.gson.Gson;
import com.segway.robot.sdk.base.log.Logger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;

public class LogUtil {
    public static final int TS_MICRO = 1;
    public static final int TS_NANO = 2;
    public static final int TS_MILLI = 3;
    private static final String TAG = LogUtil.class.getName();
    private static Gson gson = new Gson();
    private static SimpleDateFormat sdf = new SimpleDateFormat("MM-dd HH:mm:ss:SSS");



    public static void logFrameDetail(String tag, String streamName, long ts, long lastTs, int flag) {
        if (Logger.isLogcatEnabled(Logger.FLAG_V) && lastTs != 0) {
            switch (flag) {
                case TS_NANO:
                    ts = ts / 1000000;
                    lastTs = lastTs / 1000000;
                    break;
                case TS_MICRO:
                    ts = ts / 1000;
                    lastTs = lastTs / 1000;
                    break;
                case TS_MILLI:
                default:
                    break;
            }
            Logger.v(tag, streamName +" -> nowts:" + ts
                    + " last_ts:" + lastTs
                    + " gap:" + (ts - lastTs)
                    + " RTdiff:" + (System.currentTimeMillis() - ts)
            );
        }
    }

    static String path = Environment.getExternalStorageDirectory().getPath() + "/ecevent.log";
    public synchronized static void saveLog2LogFile(String log,String path) {
        FileWriter fileWriter = null;
        BufferedWriter bw = null;
        try {
            File file = new File(path);
            fileWriter = new FileWriter(file, true);
            bw = new BufferedWriter(fileWriter);
            bw.append(log);
            bw.newLine();
            if (file.length() > 10 * 1024 * 1024) {
                File bakFile = new File(path.replace("ecevent.log","ecevent_"+System.currentTimeMillis()+".log"));
                file.renameTo(bakFile);
                file.delete();
                file.createNewFile();
                Logger.i(TAG,"File size exceeds limit of 100M. delete file and recreate it.");
            }
        } catch (Exception e) {
            Logger.e(TAG, "write log to file error", e);
        } finally {
            if (bw != null){
                try {
                    bw.flush();
                    bw.close();
                } catch (IOException e) {
                    Logger.w(TAG,"close bw exception in finally , do nothing.");
                }
            }
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                } catch (IOException e) {
                    Logger.w(TAG,"clse fileWriter exception in finally , do nothing.");
                }
            }
        }
    }

    public synchronized static void saveObjJson2LogFile(Object obj){
        if (obj != null){
            String log = sdf.format(new Date()) + " " + gson.toJson(obj);
            saveLog2LogFile(log,path);
        } else {
            Logger.w(TAG,"saveObjJson2LogFile pass null.");
        }
    }

    public static Gson getGson(){
        return gson;
    }
    public static SimpleDateFormat getSdf(){
        return sdf;
    }

    public static String loadConfig(String filePath) {
        String resJson = null;
        FileReader fileReader = null;
        BufferedReader bufferedReader = null;
        try {
            File file = new File(filePath);
            fileReader = new FileReader(file);
            bufferedReader = new BufferedReader(fileReader);
            resJson = bufferedReader.readLine();
        } catch (Exception e) {
            System.out.println("exception -> " + e.getLocalizedMessage());
        } finally {
            try {
                if (bufferedReader != null) bufferedReader.close();
                if (fileReader != null) fileReader.close();
            } catch (IOException e) {System.out.println("doNothing.");}
        }
        return resJson;
    }

    public static String trimEvtType(String evtType){
        if (evtType == null){ return "";}
        return evtType.replaceAll("-","").replaceAll("\\.","");
    }

    public synchronized static void saveCSV2LogFile(String csvString,String csvFilePath){
        saveLog2LogFile(csvString,csvFilePath);
    }
}

