/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.internal.framebuffer;

import com.segway.robot.sdk.base.log.Logger;
import com.segway.robot.sdk.vision.frame.Frame;
import com.segway.robot.sdk.vision.internal.framebuffer.CountableFrame;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class FrameBuffer {
    private static final String TAG = "FrameBuffer";
    final int MAX_SIZE = 10;
    List<CountableFrame> mFrameList = new LinkedList<CountableFrame>();

    public synchronized boolean add(CountableFrame frame) {
        Iterator<CountableFrame> iterator = this.mFrameList.iterator();
        while (iterator.hasNext()) {
            CountableFrame f = iterator.next();
            if (f.isLocked()) continue;
            f.release();
            iterator.remove();
        }
        if (this.mFrameList.size() >= 10) {
            Logger.d((String)TAG, (String)"Buffer overflow !");
            frame.release();
            return false;
        }
        this.mFrameList.add(frame);
        return true;
    }

    public synchronized Frame getLatest(long previousFrameTid) {
        if (this.mFrameList.size() == 0) {
            return null;
        }
        CountableFrame frame = this.mFrameList.get(this.mFrameList.size() - 1);
        if (frame.getTid() > previousFrameTid) {
            frame.lockCountUp();
            return frame;
        }
        return null;
    }

    public synchronized void returnFrame(Frame frame) {
        CountableFrame cur = (CountableFrame)frame;
        cur.lockCountDown();
        if (this.mFrameList.size() == 10 && !cur.isLocked() && cur != this.mFrameList.get(this.mFrameList.size() - 1)) {
            cur.release();
            this.mFrameList.remove(cur);
        }
    }
}

