package com.segway.robot.sdk.vision.frame;

/**
 * Fish eye frame information
 */
public class FishEyeFrameInfo {
    FrameInfo mFrameInfo;

    public FishEyeFrameInfo(int streamType, int resolution, int pixelFormat,
                            int stride, int frameNum, int exposure, long timeStamp) {
        mFrameInfo = new FrameInfo(streamType, resolution, pixelFormat);
        mFrameInfo.intArg0 = stride;
        mFrameInfo.intArg1 = frameNum;
        mFrameInfo.intArg2 = exposure;
        mFrameInfo.longArg0 = timeStamp;
    }

    public FishEyeFrameInfo(FrameInfo frameInfo) {
        this.mFrameInfo = frameInfo;
    }

    public int getStride() {
        return mFrameInfo.intArg0;
    }

    public int getFrameNum() {
        return mFrameInfo.intArg1;
    }

    public int getExposure() {
        return mFrameInfo.intArg2;
    }

    public long getTimeStamp() {
        return mFrameInfo.longArg0;
    }

    public void setTimeStamp(long timeStamp) {
        mFrameInfo.longArg0 = timeStamp;
    }

    public FrameInfo getFrameInfo() {
        return mFrameInfo;
    }
}
