package com.segway.robot.sdk.vision.calibration;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * This class contains the calibration info for color camera and depth camera
 */

public class ColorDepthCalibration implements Parcelable{
    /**
     * The intrinsic for color camera
     */
    public Intrinsic colorIntrinsic = new Intrinsic();

    /**
     * The intrinsic for depth camera
     */
    public Intrinsic depthIntrinsic = new Intrinsic();

    /**
     * The extrinsic between color camera and depth camera
     */
    public Extrinsic depthToColorExtrinsic = new Extrinsic();

    public ColorDepthCalibration() {
    }

    protected ColorDepthCalibration(Parcel in) {
        colorIntrinsic = in.readParcelable(Intrinsic.class.getClassLoader());
        depthIntrinsic = in.readParcelable(Intrinsic.class.getClassLoader());
        depthToColorExtrinsic = in.readParcelable(Extrinsic.class.getClassLoader());
    }

    public static final Creator<ColorDepthCalibration> CREATOR = new Creator<ColorDepthCalibration>() {
        @Override
        public ColorDepthCalibration createFromParcel(Parcel in) {
            return new ColorDepthCalibration(in);
        }

        @Override
        public ColorDepthCalibration[] newArray(int size) {
            return new ColorDepthCalibration[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(colorIntrinsic, flags);
        dest.writeParcelable(depthIntrinsic, flags);
        dest.writeParcelable(depthToColorExtrinsic, flags);
    }

    @Override
    public String toString() {
        return "ColorDepthCalibration{" +
                "\ncolorIntrinsic=" + colorIntrinsic +
                "\ndepthIntrinsic=" + depthIntrinsic +
                "\ndepthToColorExtrinsic=" + depthToColorExtrinsic +
                "\n}";
    }
}
