/*
 * Decompiled with CFR 0.152.
 */
package com.segway.robot.sdk.vision.person;

import android.os.Parcel;
import android.os.Parcelable;

public class Point3DF
implements Parcelable {
    public float x;
    public float y;
    public float z;
    public static final Parcelable.Creator<Point3DF> CREATOR = new Parcelable.Creator<Point3DF>(){

        public Point3DF createFromParcel(Parcel in) {
            Point3DF r = new Point3DF();
            r.readFromParcel(in);
            return r;
        }

        public Point3DF[] newArray(int size) {
            return new Point3DF[size];
        }
    };

    public Point3DF() {
    }

    public Point3DF(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Point3DF(Point3DF p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public final void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public final void set(Point3DF p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
    }

    public final void negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
    }

    public final void offset(float dx, float dy, float dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
    }

    public final boolean equals(float x, float y, float z) {
        return this.x == x && this.y == y && this.z == z;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Point3DF point3DF = (Point3DF)o;
        if (Float.compare(point3DF.x, this.x) != 0) {
            return false;
        }
        if (Float.compare(point3DF.y, this.y) != 0) {
            return false;
        }
        return Float.compare(point3DF.z, this.z) == 0;
    }

    public int hashCode() {
        int result = this.x != 0.0f ? Float.floatToIntBits(this.x) : 0;
        result = 31 * result + (this.y != 0.0f ? Float.floatToIntBits(this.y) : 0);
        result = 31 * result + (this.z != 0.0f ? Float.floatToIntBits(this.z) : 0);
        return result;
    }

    public String toString() {
        return "Point3DF(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public final float length() {
        return Point3DF.length(this.x, this.y, this.z);
    }

    public static float length(float x, float y, float z) {
        return (float)Math.sqrt(x * x + y * y + z * z);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeFloat(this.x);
        out.writeFloat(this.y);
        out.writeFloat(this.z);
    }

    public void readFromParcel(Parcel in) {
        this.x = in.readFloat();
        this.y = in.readFloat();
        this.z = in.readFloat();
    }
}

